/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.util.Set;
import net.java.sip.communicator.impl.protocol.icq.ContactIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetPersistentPresenceIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.service.protocol.AbstractOperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.icbm.Conversation;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationEventInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmBuddyInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmListener;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmService;
import net.kano.joustsim.oscar.oscar.service.icbm.Message;
import net.kano.joustsim.oscar.oscar.service.icbm.MessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingListener;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingState;

public class OperationSetTypingNotificationsIcqImpl
extends AbstractOperationSetTypingNotifications<ProtocolProviderServiceIcqImpl> {
    private static final Logger logger = Logger.getLogger(OperationSetTypingNotificationsIcqImpl.class);
    private OperationSetPersistentPresenceIcqImpl opSetPersPresence = null;
    private JoustSimIcbmListener joustSimIcbmListener = new JoustSimIcbmListener();
    private JoustSimTypingListener joustSimTypingListener = new JoustSimTypingListener();
    private ProviderRegListener providerRegListener = new ProviderRegListener();

    OperationSetTypingNotificationsIcqImpl(ProtocolProviderServiceIcqImpl icqProvider) {
        super((ProtocolProviderService)icqProvider);
        icqProvider.addRegistrationStateChangeListener(this.providerRegListener);
    }

    private TypingState intToTypingState(int typingState) {
        switch (typingState) {
            case 3: {
                return TypingState.PAUSED;
            }
            case 1: {
                return TypingState.TYPING;
            }
            case 4: {
                return TypingState.NO_TEXT;
            }
        }
        return TypingState.NO_TEXT;
    }

    private int typingStateToInt(TypingState state) {
        if (state == TypingState.TYPING) {
            return 1;
        }
        if (state == TypingState.PAUSED) {
            return 3;
        }
        if (state == TypingState.NO_TEXT) {
            return 4;
        }
        return 0;
    }

    public void sendTypingNotification(Contact notifiedContact, int typingState) throws IllegalStateException, IllegalArgumentException {
        this.assertConnected();
        if (!(notifiedContact instanceof ContactIcqImpl)) {
            throw new IllegalArgumentException("The specified contact is not an ICQ contact." + notifiedContact);
        }
        ((ProtocolProviderServiceIcqImpl)this.parentProvider).getAimConnection().getIcbmService().getImConversation(new Screenname(notifiedContact.getAddress())).setTypingState(this.intToTypingState(typingState));
    }

    private class JoustSimTypingListener
    implements IcbmListener,
    TypingListener {
        private JoustSimTypingListener() {
        }

        @Override
        public void gotTypingState(Conversation conversation, TypingInfo typingInfo) {
            Object sourceContact = OperationSetTypingNotificationsIcqImpl.this.opSetPersPresence.findContactByID(conversation.getBuddy().getFormatted());
            if (sourceContact == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Received a typing notification from an unknown buddy=" + conversation.getBuddy()));
                }
                sourceContact = OperationSetTypingNotificationsIcqImpl.this.opSetPersPresence.createVolatileContact(conversation.getBuddy().getFormatted());
            }
            OperationSetTypingNotificationsIcqImpl.this.fireTypingNotificationsEvent((Contact)sourceContact, OperationSetTypingNotificationsIcqImpl.this.typingStateToInt(typingInfo.getTypingState()));
        }

        @Override
        public void buddyInfoUpdated(IcbmService service, Screenname buddy, IcbmBuddyInfo info) {
        }

        @Override
        public void conversationClosed(Conversation conv) {
        }

        @Override
        public void gotMessage(Conversation conv, MessageInfo minfo) {
        }

        @Override
        public void gotOtherEvent(Conversation conversation, ConversationEventInfo event) {
        }

        @Override
        public void sentOtherEvent(Conversation conversation, ConversationEventInfo event) {
        }

        @Override
        public void canSendMessageChanged(Conversation conv, boolean canSend) {
        }

        @Override
        public void conversationOpened(Conversation conv) {
        }

        @Override
        public void newConversation(IcbmService service, Conversation conv) {
        }

        @Override
        public void sentMessage(Conversation conv, MessageInfo minfo) {
        }

        @Override
        public void sendAutomaticallyFailed(IcbmService service, Message message, Set<Conversation> triedConversations) {
        }
    }

    private class JoustSimIcbmListener
    implements IcbmListener {
        private JoustSimIcbmListener() {
        }

        @Override
        public void newConversation(IcbmService service, Conversation conv) {
            conv.addConversationListener(OperationSetTypingNotificationsIcqImpl.this.joustSimTypingListener);
        }

        @Override
        public void buddyInfoUpdated(IcbmService service, Screenname buddy, IcbmBuddyInfo info) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("buddyInfoUpdated for:" + buddy + " info: " + info));
            }
        }

        @Override
        public void sendAutomaticallyFailed(IcbmService service, Message message, Set<Conversation> triedConversations) {
        }
    }

    private class ProviderRegListener
    implements RegistrationStateChangeListener {
        private ProviderRegListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The ICQ provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.FINALIZING_REGISTRATION) {
                ((ProtocolProviderServiceIcqImpl)OperationSetTypingNotificationsIcqImpl.this.parentProvider).getAimConnection().getIcbmService().addIcbmListener(OperationSetTypingNotificationsIcqImpl.this.joustSimIcbmListener);
                OperationSetTypingNotificationsIcqImpl.this.opSetPersPresence = (OperationSetPersistentPresenceIcqImpl)((ProtocolProviderServiceIcqImpl)OperationSetTypingNotificationsIcqImpl.this.parentProvider).getOperationSet(OperationSetPersistentPresence.class);
            }
        }
    }
}

