/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.OscarTools;
import org.jetbrains.annotations.Nullable;

public class MiniUserInfo
implements LiveWritable {
    private final String sn;
    private final int warningLevel;
    private final int totalSize;

    @Nullable
    public static MiniUserInfo readUserInfo(ByteBlock block) {
        DefensiveTools.checkNull(block, "block");
        if (block.getLength() == 0) {
            return null;
        }
        short length = BinaryTools.getUByte(block, 0);
        if (block.getLength() < length + 1) {
            return null;
        }
        String sn = BinaryTools.getAsciiString(block.subBlock(1, length));
        int size = 1 + length;
        int warningLevel = -1;
        if (block.getLength() >= 1 + length + 2) {
            warningLevel = BinaryTools.getUShort(block, 1 + length + 2);
            size += 2;
        }
        return new MiniUserInfo(sn, warningLevel, size);
    }

    protected MiniUserInfo(String sn, int warningLevel, int totalSize) {
        DefensiveTools.checkNull(sn, "sn");
        DefensiveTools.checkRange(warningLevel, "warningLevel", 0);
        DefensiveTools.checkRange(totalSize, "totalSize", -1);
        this.sn = sn;
        this.warningLevel = warningLevel;
        this.totalSize = totalSize;
    }

    public MiniUserInfo(String sn, int warningLevel) {
        this(sn, warningLevel, -1);
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final int getWarningLevel() {
        return this.warningLevel;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public void write(OutputStream out) throws IOException {
        OscarTools.writeScreenname(out, this.sn);
        BinaryTools.writeUShort(out, this.warningLevel);
    }

    public String toString() {
        return "MiniUserInfo: " + this.sn + " (" + this.warningLevel + "%)";
    }
}

