/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import java.io.IOException;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class NodeAVLDisk
extends NodeAVL {
    final RowAVLDisk row;
    private int iLeft = -1;
    private int iRight = -1;
    private int iParent = -1;
    private int iId;
    public static final int SIZE_IN_BYTE = 16;

    public NodeAVLDisk(RowAVLDisk rowAVLDisk, RowInputInterface rowInputInterface, int n) throws IOException {
        this.row = rowAVLDisk;
        this.iId = n;
        this.iBalance = rowInputInterface.readInt();
        this.iLeft = rowInputInterface.readInt();
        this.iRight = rowInputInterface.readInt();
        this.iParent = rowInputInterface.readInt();
        if (this.iLeft <= 0) {
            this.iLeft = -1;
        }
        if (this.iRight <= 0) {
            this.iRight = -1;
        }
        if (this.iParent <= 0) {
            this.iParent = -1;
        }
    }

    public NodeAVLDisk(RowAVLDisk rowAVLDisk, int n) {
        this.row = rowAVLDisk;
        this.iId = n;
    }

    @Override
    public void delete() {
        this.iLeft = -1;
        this.iRight = -1;
        this.iParent = -1;
        this.nLeft = null;
        this.nRight = null;
        this.nParent = null;
        this.iBalance = 0;
        this.row.setNodesChanged();
    }

    @Override
    public boolean isInMemory() {
        return this.row.isInMemory();
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public long getPos() {
        return this.row.getPos();
    }

    @Override
    public RowAVL getRow(PersistentStore persistentStore) {
        if (!this.row.isInMemory()) {
            return (RowAVLDisk)persistentStore.get((CachedObject)this.row, false);
        }
        this.row.updateAccessCount(persistentStore.getAccessCount());
        return this.row;
    }

    @Override
    public Object[] getData(PersistentStore persistentStore) {
        return this.row.getData();
    }

    private NodeAVLDisk findNode(PersistentStore persistentStore, int n) {
        NodeAVLDisk nodeAVLDisk = null;
        RowAVLDisk rowAVLDisk = (RowAVLDisk)persistentStore.get(n, false);
        if (rowAVLDisk != null) {
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        return nodeAVLDisk;
    }

    @Override
    boolean isLeft(NodeAVL nodeAVL) {
        if (nodeAVL == null) {
            return this.iLeft == -1;
        }
        return (long)this.iLeft == nodeAVL.getPos();
    }

    @Override
    boolean isRight(NodeAVL nodeAVL) {
        if (nodeAVL == null) {
            return this.iRight == -1;
        }
        return (long)this.iRight == nodeAVL.getPos();
    }

    @Override
    NodeAVL getLeft(PersistentStore persistentStore) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, false);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (nodeAVLDisk.iLeft == -1) {
            return null;
        }
        if (nodeAVLDisk.nLeft == null || !nodeAVLDisk.nLeft.isInMemory()) {
            nodeAVLDisk.nLeft = this.findNode(persistentStore, nodeAVLDisk.iLeft);
            nodeAVLDisk.nLeft.nParent = nodeAVLDisk;
        }
        return nodeAVLDisk.nLeft;
    }

    @Override
    NodeAVL getRight(PersistentStore persistentStore) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, false);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (nodeAVLDisk.iRight == -1) {
            return null;
        }
        if (nodeAVLDisk.nRight == null || !nodeAVLDisk.nRight.isInMemory()) {
            nodeAVLDisk.nRight = this.findNode(persistentStore, nodeAVLDisk.iRight);
            nodeAVLDisk.nRight.nParent = nodeAVLDisk;
        }
        return nodeAVLDisk.nRight;
    }

    @Override
    NodeAVL getParent(PersistentStore persistentStore) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, false);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (nodeAVLDisk.iParent == -1) {
            return null;
        }
        if (nodeAVLDisk.nParent == null || !nodeAVLDisk.nParent.isInMemory()) {
            nodeAVLDisk.nParent = this.findNode(persistentStore, this.iParent);
        }
        return nodeAVLDisk.nParent;
    }

    @Override
    public int getBalance(PersistentStore persistentStore) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, false);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        return nodeAVLDisk.iBalance;
    }

    @Override
    boolean isRoot(PersistentStore persistentStore) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, false);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        return nodeAVLDisk.iParent == -1;
    }

    @Override
    boolean isFromLeft(PersistentStore persistentStore) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, false);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (nodeAVLDisk.iParent == -1) {
            return true;
        }
        if (nodeAVLDisk.nParent == null || !nodeAVLDisk.nParent.isInMemory()) {
            nodeAVLDisk.nParent = this.findNode(persistentStore, this.iParent);
        }
        return rowAVLDisk.getPos() == (long)((NodeAVLDisk)nodeAVLDisk.nParent).iLeft;
    }

    @Override
    public NodeAVL child(PersistentStore persistentStore, boolean bl) {
        return bl ? this.getLeft(persistentStore) : this.getRight(persistentStore);
    }

    @Override
    NodeAVL setParent(PersistentStore persistentStore, NodeAVL nodeAVL) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, true);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk.keepInMemory(false);
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        rowAVLDisk.setNodesChanged();
        nodeAVLDisk.iParent = nodeAVL == null ? -1 : (int)nodeAVL.getPos();
        nodeAVLDisk.nParent = (NodeAVLDisk)nodeAVL;
        rowAVLDisk.keepInMemory(false);
        return nodeAVLDisk;
    }

    @Override
    public NodeAVL setBalance(PersistentStore persistentStore, int n) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, true);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (!rowAVLDisk.isInMemory()) {
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        rowAVLDisk.setNodesChanged();
        nodeAVLDisk.iBalance = n;
        rowAVLDisk.keepInMemory(false);
        return nodeAVLDisk;
    }

    @Override
    NodeAVL setLeft(PersistentStore persistentStore, NodeAVL nodeAVL) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, true);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (!rowAVLDisk.isInMemory()) {
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        rowAVLDisk.setNodesChanged();
        nodeAVLDisk.iLeft = nodeAVL == null ? -1 : (int)nodeAVL.getPos();
        nodeAVLDisk.nLeft = (NodeAVLDisk)nodeAVL;
        rowAVLDisk.keepInMemory(false);
        return nodeAVLDisk;
    }

    @Override
    NodeAVL setRight(PersistentStore persistentStore, NodeAVL nodeAVL) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get((CachedObject)this.row, true);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (!rowAVLDisk.isInMemory()) {
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        rowAVLDisk.setNodesChanged();
        nodeAVLDisk.iRight = nodeAVL == null ? -1 : (int)nodeAVL.getPos();
        nodeAVLDisk.nRight = (NodeAVLDisk)nodeAVL;
        rowAVLDisk.keepInMemory(false);
        return nodeAVLDisk;
    }

    @Override
    public NodeAVL set(PersistentStore persistentStore, boolean bl, NodeAVL nodeAVL) {
        NodeAVL nodeAVL2 = bl ? this.setLeft(persistentStore, nodeAVL) : this.setRight(persistentStore, nodeAVL);
        if (nodeAVL != null) {
            nodeAVL.setParent(persistentStore, this);
        }
        return nodeAVL2;
    }

    @Override
    public void replace(PersistentStore persistentStore, Index index, NodeAVL nodeAVL) {
        if (this.iParent == -1) {
            if (nodeAVL != null) {
                nodeAVL = nodeAVL.setParent(persistentStore, null);
            }
            persistentStore.setAccessor(index, nodeAVL);
        } else {
            boolean bl = this.isFromLeft(persistentStore);
            this.getParent(persistentStore).set(persistentStore, bl, nodeAVL);
        }
    }

    @Override
    boolean equals(NodeAVL nodeAVL) {
        if (nodeAVL instanceof NodeAVLDisk) {
            return this == nodeAVL || this.getPos() == ((NodeAVLDisk)nodeAVL).getPos();
        }
        return false;
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return 16;
    }

    @Override
    public void setInMemory(boolean bl) {
        if (!bl) {
            if (this.nLeft != null) {
                this.nLeft.nParent = null;
            }
            if (this.nRight != null) {
                this.nRight.nParent = null;
            }
            if (this.nParent != null) {
                if (this.row.getPos() == (long)((NodeAVLDisk)this.nParent).iLeft) {
                    this.nParent.nLeft = null;
                } else {
                    this.nParent.nRight = null;
                }
            }
            this.nParent = null;
            this.nRight = null;
            this.nLeft = null;
        }
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        rowOutputInterface.writeInt(this.iBalance);
        rowOutputInterface.writeInt(this.iLeft == -1 ? 0 : this.iLeft);
        rowOutputInterface.writeInt(this.iRight == -1 ? 0 : this.iRight);
        rowOutputInterface.writeInt(this.iParent == -1 ? 0 : this.iParent);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
        rowOutputInterface.writeInt(this.iBalance);
        rowOutputInterface.writeInt(NodeAVLDisk.getTranslatePointer(this.iLeft, longLookup));
        rowOutputInterface.writeInt(NodeAVLDisk.getTranslatePointer(this.iRight, longLookup));
        rowOutputInterface.writeInt(NodeAVLDisk.getTranslatePointer(this.iParent, longLookup));
    }

    private static int getTranslatePointer(int n, LongLookup longLookup) {
        int n2 = 0;
        if (n != -1) {
            n2 = longLookup == null ? n : (int)longLookup.lookup(n);
        }
        return n2;
    }

    @Override
    public void restore() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void updateAccessCount(int n) {
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public void setStorageSize(int n) {
    }

    @Override
    public int getStorageSize() {
        return 0;
    }

    @Override
    public void setPos(long l) {
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public boolean isKeepInMemory() {
        return false;
    }

    @Override
    public boolean keepInMemory(boolean bl) {
        return false;
    }
}

