/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.muc;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.muc.ChatRoomWrapperImpl;
import net.java.sip.communicator.impl.muc.MUCActivator;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ProtocolIcon;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;

public class ChatRoomProviderWrapperImpl
implements ChatRoomProviderWrapper {
    private static final Logger logger = Logger.getLogger(ChatRoomProviderWrapperImpl.class);
    private final ProtocolProviderService protocolProvider;
    private final ChatRoomWrapper systemRoomWrapper;
    private final List<ChatRoomWrapper> chatRoomsOrderedCopy = new LinkedList<ChatRoomWrapper>();

    public ChatRoomProviderWrapperImpl(ProtocolProviderService protocolProvider) {
        this.protocolProvider = protocolProvider;
        String accountIdService = protocolProvider.getAccountID().getService();
        this.systemRoomWrapper = new ChatRoomWrapperImpl(this, accountIdService, accountIdService);
    }

    @Override
    public String getName() {
        return this.protocolProvider.getProtocolDisplayName();
    }

    @Override
    public byte[] getIcon() {
        return this.protocolProvider.getProtocolIcon().getIcon("IconSize64x64");
    }

    @Override
    public byte[] getImage() {
        byte[] logoImage = null;
        ProtocolIcon protocolIcon = this.protocolProvider.getProtocolIcon();
        if (protocolIcon.isSizeSupported("IconSize64x64")) {
            logoImage = protocolIcon.getIcon("IconSize64x64");
        } else if (protocolIcon.isSizeSupported("IconSize48x48")) {
            logoImage = protocolIcon.getIcon("IconSize48x48");
        }
        return logoImage;
    }

    @Override
    public ChatRoomWrapper getSystemRoomWrapper() {
        return this.systemRoomWrapper;
    }

    @Override
    public void setSystemRoom(ChatRoom systemRoom) {
        this.systemRoomWrapper.setChatRoom(systemRoom);
    }

    @Override
    public ProtocolProviderService getProtocolProvider() {
        return this.protocolProvider;
    }

    @Override
    public void addChatRoom(ChatRoomWrapper chatRoom) {
        this.chatRoomsOrderedCopy.add(chatRoom);
    }

    @Override
    public void removeChatRoom(ChatRoomWrapper chatRoom) {
        this.chatRoomsOrderedCopy.remove(chatRoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsChatRoom(ChatRoomWrapper chatRoom) {
        List<ChatRoomWrapper> list = this.chatRoomsOrderedCopy;
        synchronized (list) {
            return this.chatRoomsOrderedCopy.contains(chatRoom);
        }
    }

    @Override
    public ChatRoomWrapper findChatRoomWrapperForChatRoom(ChatRoom chatRoom) {
        return this.findChatRoomWrapperForChatRoomID(chatRoom.getIdentifier());
    }

    @Override
    public ChatRoomWrapper findChatRoomWrapperForChatRoomID(String chatRoomID) {
        for (ChatRoomWrapper chatRoomWrapper : this.chatRoomsOrderedCopy) {
            if (!chatRoomWrapper.getChatRoomID().equals(chatRoomID)) continue;
            return chatRoomWrapper;
        }
        return null;
    }

    @Override
    public int countChatRooms() {
        return this.chatRoomsOrderedCopy.size();
    }

    @Override
    public ChatRoomWrapper getChatRoom(int index) {
        return this.chatRoomsOrderedCopy.get(index);
    }

    @Override
    public int indexOf(ChatRoomWrapper chatRoomWrapper) {
        return this.chatRoomsOrderedCopy.indexOf(chatRoomWrapper);
    }

    @Override
    public void synchronizeProvider() {
        final OperationSetMultiUserChat groupChatOpSet = (OperationSetMultiUserChat)this.protocolProvider.getOperationSet(OperationSetMultiUserChat.class);
        for (final ChatRoomWrapper chatRoomWrapper : this.chatRoomsOrderedCopy) {
            new Thread(){

                @Override
                public void run() {
                    ChatRoom chatRoom = null;
                    try {
                        chatRoom = groupChatOpSet.findRoom(chatRoomWrapper.getChatRoomName());
                    }
                    catch (OperationFailedException e1) {
                        logger.error((Object)("Failed to find chat room with name:" + chatRoomWrapper.getChatRoomName()), (Throwable)e1);
                    }
                    catch (OperationNotSupportedException e1) {
                        logger.error((Object)("Failed to find chat room with name:" + chatRoomWrapper.getChatRoomName()), (Throwable)e1);
                    }
                    if (chatRoom != null) {
                        chatRoomWrapper.setChatRoom(chatRoom);
                        if (chatRoomWrapper.isAutojoin()) {
                            String nickName = ConfigurationUtils.getChatRoomProperty((ProtocolProviderService)chatRoomWrapper.getParentProvider().getProtocolProvider(), (String)chatRoomWrapper.getChatRoomID(), (String)"userNickName");
                            if (nickName != null) {
                                MUCActivator.getMUCService().joinChatRoom(chatRoom, nickName, null);
                            } else {
                                MUCActivator.getMUCService().joinChatRoom(chatRoomWrapper);
                            }
                        }
                    } else if (chatRoomWrapper.isAutojoin()) {
                        ChatRoomWrapper roomWrapper = MUCActivator.getMUCService().createChatRoom(chatRoomWrapper.getChatRoomName(), chatRoomWrapper.getParentProvider().getProtocolProvider(), new ArrayList<String>(), "", false, false, true);
                        String nickName = ConfigurationUtils.getChatRoomProperty((ProtocolProviderService)chatRoomWrapper.getParentProvider().getProtocolProvider(), (String)chatRoomWrapper.getChatRoomID(), (String)"userNickName");
                        if (nickName != null) {
                            MUCActivator.getMUCService().joinChatRoom(roomWrapper.getChatRoom(), nickName, null);
                        } else {
                            MUCActivator.getMUCService().joinChatRoom(roomWrapper);
                        }
                    }
                }
            }.start();
        }
    }
}

