/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.addrbook.macosx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.java.sip.communicator.plugin.addrbook.macosx.MacOSXAddrBookContactDetail;
import net.java.sip.communicator.plugin.addrbook.macosx.MacOSXAddrBookContactQuery;
import net.java.sip.communicator.plugin.addrbook.macosx.MacOSXAddrBookContactSourceService;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.EditableSourceContact;
import net.java.sip.communicator.service.contactsource.GenericSourceContact;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.util.Logger;

public class MacOSXAddrBookSourceContact
extends GenericSourceContact
implements EditableSourceContact {
    private static final Logger logger = Logger.getLogger(MacOSXAddrBookSourceContact.class);
    private Boolean locked = Boolean.FALSE;

    public MacOSXAddrBookSourceContact(ContactSourceService contactSource, String displayName, List<ContactDetail> contactDetails) {
        super(contactSource, displayName, contactDetails);
        for (ContactDetail cd : contactDetails) {
            if (!(cd instanceof MacOSXAddrBookContactDetail)) continue;
            ((MacOSXAddrBookContactDetail)cd).setSourceContact(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContactDetail(ContactDetail detail) {
        MacOSXAddrBookSourceContact macOSXAddrBookSourceContact = this;
        synchronized (macOSXAddrBookSourceContact) {
            String id = (String)this.getData(SourceContact.DATA_ID);
            if (id == null) {
                logger.warn((Object)("No id or wrong ContactDetail " + detail));
                return;
            }
            String subProperty = null;
            int property = MacOSXAddrBookContactQuery.getProperty(detail.getCategory(), detail.getSubCategories());
            if (MacOSXAddrBookContactDetail.isMultiline(detail.getCategory())) {
                if (detail instanceof MacOSXAddrBookContactDetail) {
                    subProperty = ((MacOSXAddrBookContactDetail)detail).getSubPropertyLabel();
                }
                if (subProperty == null) {
                    if (property == 22) {
                        subProperty = detail.containsSubCategory(ContactDetail.SubCategory.Home) ? MacOSXAddrBookContactQuery.kABAddressHomeLabel() : MacOSXAddrBookContactQuery.kABAddressWorkLabel();
                    } else if (property == 0 || property == 4 || property == 5 || property == 10 || property == 13) {
                        subProperty = MacOSXAddrBookContactQuery.kABAddressWorkLabel();
                    }
                }
                List<String> values = this.getValues(detail, property, subProperty, true);
                MacOSXAddrBookContactQuery.setProperty(id, MacOSXAddrBookContactQuery.ABPERSON_PROPERTIES[property], subProperty, values.toArray(new Object[values.size()]));
            } else {
                MacOSXAddrBookContactQuery.setProperty(id, MacOSXAddrBookContactQuery.ABPERSON_PROPERTIES[property], null, detail.getDetail());
            }
            Collection subCategories = detail.getSubCategories();
            MacOSXAddrBookContactDetail contactDetail = new MacOSXAddrBookContactDetail(property, detail.getDetail(), detail.getCategory(), subCategories.toArray(new ContactDetail.SubCategory[subCategories.size()]), subProperty, id);
            contactDetail.setSourceContact(this);
            boolean added = false;
            int index = 0;
            for (ContactDetail cd : this.contactDetails) {
                if (cd instanceof MacOSXAddrBookContactDetail) {
                    MacOSXAddrBookContactDetail macOSXcd = (MacOSXAddrBookContactDetail)cd;
                    if (!added && contactDetail.getProperty() == macOSXcd.getProperty() && (contactDetail.getSubPropertyLabel() == null || contactDetail.getSubPropertyLabel().equals(macOSXcd.getSubPropertyLabel()))) {
                        added = true;
                    }
                }
                if (added) continue;
                ++index;
            }
            this.contactDetails.add(index, contactDetail);
        }
    }

    private List<String> getValues(ContactDetail detail, int property, String subProperty, boolean addDetail) {
        ArrayList<String> values = new ArrayList<String>();
        List details = this.getContactDetails(detail.getCategory());
        boolean isIM = property == 4 || property == 0 || property == 13 || property == 10 || property == 5;
        boolean isAddress = property == 22;
        boolean isHomeAddress = detail.containsSubCategory(ContactDetail.SubCategory.Home);
        int lastHomeIndex = 0;
        int lastWorkIndex = 0;
        for (ContactDetail cd : details) {
            if (cd.equals(detail)) continue;
            String det = cd.getDetail();
            for (ContactDetail.SubCategory sub : cd.getSubCategories()) {
                String label;
                if (isIM && !detail.getSubCategories().contains(sub) || (label = MacOSXAddrBookContactQuery.getLabel(property, sub, subProperty)) == null) continue;
                values.add(det);
                values.add(label);
                if (!isAddress || !(cd instanceof MacOSXAddrBookContactDetail)) continue;
                String subPropertyLabel = ((MacOSXAddrBookContactDetail)cd).getSubPropertyLabel();
                values.add(subPropertyLabel);
                if (subPropertyLabel.equals(MacOSXAddrBookContactQuery.kABAddressHomeLabel())) {
                    lastHomeIndex = values.size();
                    continue;
                }
                if (!subPropertyLabel.equals(MacOSXAddrBookContactQuery.kABAddressWorkLabel())) continue;
                lastWorkIndex = values.size();
            }
        }
        if (addDetail) {
            for (ContactDetail.SubCategory sub : detail.getSubCategories()) {
                String label = MacOSXAddrBookContactQuery.getLabel(property, sub, subProperty);
                if (label != null) {
                    if (isAddress) {
                        String subPropertyLabel = "";
                        int index = values.size();
                        if (isHomeAddress) {
                            subPropertyLabel = MacOSXAddrBookContactQuery.kABAddressHomeLabel();
                            index = lastHomeIndex;
                            if (lastWorkIndex > lastHomeIndex) {
                                lastWorkIndex += 3;
                            }
                            lastHomeIndex += 3;
                        } else {
                            subPropertyLabel = MacOSXAddrBookContactQuery.kABAddressWorkLabel();
                            index = lastWorkIndex;
                            if (lastHomeIndex > lastWorkIndex) {
                                lastHomeIndex += 3;
                            }
                            lastWorkIndex += 3;
                        }
                        values.add(index, detail.getDetail());
                        values.add(index + 1, label);
                        values.add(index + 2, subPropertyLabel);
                        continue;
                    }
                    values.add(detail.getDetail());
                    values.add(label);
                    continue;
                }
                logger.warn((Object)("Missing label fo prop:" + property + " and sub:" + sub));
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContactDetail(ContactDetail detail) {
        MacOSXAddrBookSourceContact macOSXAddrBookSourceContact = this;
        synchronized (macOSXAddrBookSourceContact) {
            String id = (String)this.getData(SourceContact.DATA_ID);
            if (id != null && detail instanceof MacOSXAddrBookContactDetail) {
                if (MacOSXAddrBookContactDetail.isMultiline(detail.getCategory())) {
                    String subProperty = null;
                    if (detail instanceof MacOSXAddrBookContactDetail) {
                        subProperty = ((MacOSXAddrBookContactDetail)detail).getSubPropertyLabel();
                    }
                    List<String> values = this.getValues(detail, ((MacOSXAddrBookContactDetail)detail).getProperty(), subProperty, false);
                    MacOSXAddrBookContactQuery.setProperty(id, MacOSXAddrBookContactQuery.ABPERSON_PROPERTIES[((MacOSXAddrBookContactDetail)detail).getProperty()], subProperty, values.toArray(new Object[values.size()]));
                } else {
                    MacOSXAddrBookContactQuery.removeProperty(id, MacOSXAddrBookContactQuery.ABPERSON_PROPERTIES[((MacOSXAddrBookContactDetail)detail).getProperty()]);
                }
            } else {
                logger.warn((Object)("No id or wrong ContactDetail " + detail));
            }
            this.contactDetails.remove(detail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetails(List<ContactDetail> details) {
        MacOSXAddrBookSourceContact macOSXAddrBookSourceContact = this;
        synchronized (macOSXAddrBookSourceContact) {
            this.contactDetails.clear();
            this.contactDetails.addAll(details);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated() {
        MacOSXAddrBookSourceContact macOSXAddrBookSourceContact = this;
        synchronized (macOSXAddrBookSourceContact) {
            MacOSXAddrBookContactSourceService macOSXSourceService;
            MacOSXAddrBookContactQuery macOSXContactQuery;
            this.waitUnlock();
            String id = (String)this.getData(SourceContact.DATA_ID);
            ContactSourceService sourceService = this.getContactSource();
            if (id != null && sourceService instanceof MacOSXAddrBookContactSourceService && (macOSXContactQuery = (macOSXSourceService = (MacOSXAddrBookContactSourceService)sourceService).getLatestQuery()) != null) {
                long contactPointer = MacOSXAddrBookContactQuery.getContactPointer(id);
                macOSXContactQuery.updated(contactPointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        MacOSXAddrBookSourceContact macOSXAddrBookSourceContact = this;
        synchronized (macOSXAddrBookSourceContact) {
            this.locked = Boolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        MacOSXAddrBookSourceContact macOSXAddrBookSourceContact = this;
        synchronized (macOSXAddrBookSourceContact) {
            this.locked = Boolean.FALSE;
            ((Object)((Object)this)).notify();
            this.updated();
        }
    }

    private void waitUnlock() {
        boolean continueToWait = this.locked;
        while (continueToWait) {
            try {
                ((Object)((Object)this)).wait();
                continueToWait = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getIndex() {
        return -1;
    }
}

