/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.skinresourcepack;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import net.java.sip.communicator.service.resources.SkinPack;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class SkinResourcePack
implements BundleActivator,
SkinPack {
    private static final Logger logger = Logger.getLogger(SkinResourcePack.class);
    private static final String DEFAULT_RESOURCE_PATH = "info";
    private static final String DEFAULT_IMAGE_RESOURCE_PATH = "images.images";
    private static final String DEFAULT_COLOR_RESOURCE_PATH = "colors.colors";
    private static final String DEFAULT_STYLE_RESOURCE_PATH = "styles.styles";
    private static final String DEFAULT_SETTINGS_RESOURCE_PATH = "settings.settings";
    private static BundleContext bundleContext;
    private static Hashtable<String, Iterator<String>> ressourcesFiles;
    private Map<String, String> imageResources = null;
    private Map<String, String> styleResources = null;
    private Map<String, String> colorResources = null;
    private Map<String, String> sttingsResources = null;

    public void start(BundleContext bc) throws Exception {
        bundleContext = bc;
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("ResourceName", "SkinPack");
        bundleContext.registerService(SkinPack.class.getName(), (Object)this, props);
    }

    public void stop(BundleContext bc) throws Exception {
    }

    public Map<String, String> getImageResources() {
        if (this.imageResources != null) {
            return this.imageResources;
        }
        TreeMap<String, String> resources = new TreeMap<String, String>();
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("images.images");
            this.initResources(resourceBundle, resources);
        }
        catch (MissingResourceException ex) {
            logger.info((Object)"Failed to obtain bundle from image resource path.", (Throwable)ex);
        }
        this.initImagePluginResources(resources);
        this.imageResources = resources;
        return resources;
    }

    public Map<String, String> getStyleResources() {
        if (this.styleResources != null) {
            return this.styleResources;
        }
        TreeMap<String, String> resources = new TreeMap<String, String>();
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("styles.styles");
            this.initResources(resourceBundle, resources);
        }
        catch (MissingResourceException ex) {
            logger.info((Object)"Failed to obtain bundle from style resource path.", (Throwable)ex);
        }
        this.initStylePluginResources(resources);
        this.styleResources = resources;
        return resources;
    }

    public Map<String, String> getColorResources() {
        if (this.colorResources != null) {
            return this.colorResources;
        }
        TreeMap<String, String> resources = new TreeMap<String, String>();
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("colors.colors");
            this.initResources(resourceBundle, resources);
        }
        catch (MissingResourceException ex) {
            logger.info((Object)"Failed to obtain bundle from color resource path.", (Throwable)ex);
        }
        this.initColorPluginResources(resources);
        this.colorResources = resources;
        return resources;
    }

    public Map<String, String> getSettingsResources() {
        if (this.sttingsResources != null) {
            return this.sttingsResources;
        }
        TreeMap<String, String> resources = new TreeMap<String, String>();
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("settings.settings");
            this.initResources(resourceBundle, resources);
        }
        catch (MissingResourceException ex) {
            logger.info((Object)"Failed to obtain bundle from color resource path.", (Throwable)ex);
        }
        this.initSettingsPluginResources(resources);
        this.sttingsResources = resources;
        return resources;
    }

    public Map<String, String> getResources() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("info");
        TreeMap<String, String> resources = new TreeMap<String, String>();
        this.initResources(resourceBundle, resources);
        resources.putAll(this.getImageResources());
        resources.putAll(this.getStyleResources());
        resources.putAll(this.getColorResources());
        return resources;
    }

    public String getName() {
        Map resources = this.getResources();
        String name = (String)resources.get("display_name");
        if (name != null) {
            return name + " Skin Resources";
        }
        return "Skin Resources";
    }

    public String getDescription() {
        Map resources = this.getResources();
        String name = (String)resources.get("display_name");
        if (name != null) {
            return "Provide Jitsi " + name + " skin resource pack.";
        }
        return "Provide Jitsi skin resource pack.";
    }

    private void initResources(ResourceBundle resourceBundle, Map<String, String> resources) {
        Enumeration<String> colorKeys = resourceBundle.getKeys();
        while (colorKeys.hasMoreElements()) {
            String key = colorKeys.nextElement();
            String value = resourceBundle.getString(key);
            resources.put(key, value);
        }
    }

    private void initImagePluginResources(Map<String, String> resources) {
        Iterator pluginProperties = SkinResourcePack.findResourcePaths((String)"images", (String)"images-*.properties");
        while (pluginProperties.hasNext()) {
            String resourceBundleName = (String)pluginProperties.next();
            ResourceBundle resourceBundle = ResourceBundle.getBundle(resourceBundleName.substring(0, resourceBundleName.indexOf(".properties")));
            this.initResources(resourceBundle, resources);
        }
    }

    private void initStylePluginResources(Map<String, String> resources) {
        Iterator pluginProperties = SkinResourcePack.findResourcePaths((String)"styles", (String)"styles-*.properties");
        while (pluginProperties.hasNext()) {
            String resourceBundleName = (String)pluginProperties.next();
            ResourceBundle resourceBundle = ResourceBundle.getBundle(resourceBundleName.substring(0, resourceBundleName.indexOf(".properties")));
            this.initResources(resourceBundle, resources);
        }
    }

    private void initColorPluginResources(Map<String, String> resources) {
        Iterator pluginProperties = SkinResourcePack.findResourcePaths((String)"colors", (String)"colors-*.properties");
        while (pluginProperties.hasNext()) {
            String resourceBundleName = (String)pluginProperties.next();
            ResourceBundle resourceBundle = ResourceBundle.getBundle(resourceBundleName.substring(0, resourceBundleName.indexOf(".properties")));
            this.initResources(resourceBundle, resources);
        }
    }

    private void initSettingsPluginResources(Map<String, String> resources) {
        Iterator pluginProperties = SkinResourcePack.findResourcePaths((String)"settings", (String)"settings-*.properties");
        while (pluginProperties.hasNext()) {
            String resourceBundleName = (String)pluginProperties.next();
            ResourceBundle resourceBundle = ResourceBundle.getBundle(resourceBundleName.substring(0, resourceBundleName.indexOf(".properties")));
            this.initResources(resourceBundle, resources);
        }
    }

    protected static Iterator<String> findResourcePaths(String path, String pattern) {
        Iterator bufferedResult = (Iterator)ressourcesFiles.get(path + "/" + pattern);
        if (bufferedResult != null) {
            return bufferedResult;
        }
        ArrayList<String> propertiesList = new ArrayList<String>();
        Enumeration propertiesUrls = bundleContext.getBundle().findEntries(path, pattern, false);
        if (propertiesUrls != null) {
            while (propertiesUrls.hasMoreElements()) {
                URL propertyUrl = (URL)propertiesUrls.nextElement();
                String propertyFilePath = propertyUrl.getPath().substring(1);
                propertyFilePath = propertyFilePath.replaceAll("/", ".");
                propertiesList.add(propertyFilePath);
            }
        }
        Iterator<String> result = propertiesList.iterator();
        ressourcesFiles.put(path + pattern, result);
        return result;
    }

    static {
        ressourcesFiles = new Hashtable();
    }
}

