/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtp.RawPacketCache;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.util.Logger;
import org.jitsi.util.concurrent.RecurringRunnable;

public class CachingTransformer
extends SinglePacketTransformerAdapter
implements TransformEngine,
RecurringRunnable {
    private static final Logger logger = Logger.getLogger(CachingTransformer.class);
    private static final int PROCESS_INTERVAL_MS = 10000;
    private final RawPacketCache outgoingRawPacketCache;
    private final RawPacketCache incomingRawPacketCache;
    private boolean closed = false;
    private boolean enabled = false;
    private long lastUpdateTime = -1L;

    public CachingTransformer(MediaStreamImpl stream) {
        super(RTPPacketPredicate.INSTANCE);
        this.outgoingRawPacketCache = new RawPacketCache(stream.hashCode());
        this.incomingRawPacketCache = new RawPacketCache(-1);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.outgoingRawPacketCache.close();
        }
        catch (Exception e) {
            logger.error(e);
        }
        try {
            this.incomingRawPacketCache.close();
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        if (this.enabled && !this.closed) {
            this.outgoingRawPacketCache.cachePacket(pkt);
        }
        return pkt;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        if (this.enabled && !this.closed) {
            this.incomingRawPacketCache.cachePacket(pkt);
        }
        return pkt;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    @Override
    public long getTimeUntilNextRun() {
        return this.lastUpdateTime < 0L ? 0L : this.lastUpdateTime + 10000L - System.currentTimeMillis();
    }

    @Override
    public void run() {
        this.lastUpdateTime = System.currentTimeMillis();
        this.outgoingRawPacketCache.clean(this.lastUpdateTime);
        this.incomingRawPacketCache.clean(this.lastUpdateTime);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (logger.isDebugEnabled()) {
            logger.debug((enabled ? "Enabling" : "Disabling") + " CachingTransformer " + this.hashCode());
        }
    }

    public RawPacketCache getOutgoingRawPacketCache() {
        return this.outgoingRawPacketCache;
    }

    public RawPacketCache getIncomingRawPacketCache() {
        return this.incomingRawPacketCache;
    }
}

