/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.UnknownHostException;
import javax.media.Buffer;
import net.sf.fmj.media.rtp.RTPRawSender;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SendSSRCInfo;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.RTPPacket;
import net.sf.fmj.media.rtp.util.UDPPacketSender;

public class RTPTransmitter {
    RTPRawSender sender;
    SSRCCache cache;

    public RTPTransmitter(SSRCCache cache) {
        this.cache = cache;
    }

    public RTPTransmitter(SSRCCache cache, int port, String address) throws UnknownHostException, IOException {
        this(cache, new RTPRawSender(port, address));
    }

    public RTPTransmitter(SSRCCache cache, int port, String address, UDPPacketSender sender) throws UnknownHostException, IOException {
        this(cache, new RTPRawSender(port, address, sender));
    }

    public RTPTransmitter(SSRCCache cache, RTPRawSender sender) {
        this(cache);
        this.setSender(sender);
    }

    public void close() {
        if (this.sender != null) {
            this.sender.closeConsumer();
        }
    }

    public RTPRawSender getSender() {
        return this.sender;
    }

    protected RTPPacket MakeRTPPacket(Buffer b, SendSSRCInfo info) {
        byte[] data = (byte[])b.getData();
        if (data == null) {
            return null;
        }
        Packet p = new Packet();
        p.data = data;
        p.offset = 0;
        p.length = b.getLength();
        p.received = false;
        RTPPacket rtp = new RTPPacket(p);
        rtp.marker = (b.getFlags() & 0x800) != 0 ? 1 : 0;
        info.packetsize += b.getLength();
        rtp.payloadType = info.payloadType;
        rtp.seqnum = (int)info.getSequenceNumber(b);
        rtp.timestamp = info.rtptime;
        rtp.ssrc = info.ssrc;
        rtp.payloadoffset = b.getOffset();
        rtp.payloadlength = b.getLength();
        info.bytesreceived += b.getLength();
        ++info.maxseq;
        info.lasttimestamp = rtp.timestamp;
        Buffer.RTPHeaderExtension headerExtension = b.getHeaderExtension();
        if (headerExtension != null) {
            rtp.headerExtension = headerExtension;
        }
        return rtp;
    }

    public void setSender(RTPRawSender s) {
        this.sender = s;
    }

    protected void transmit(RTPPacket p) {
        try {
            this.sender.sendTo(p);
        }
        catch (IOException e) {
            ++this.cache.sm.transstats.transmit_failed;
        }
    }

    public void TransmitPacket(Buffer b, SendSSRCInfo info) {
        info.rtptime = info.getTimeStamp(b);
        Object header = b.getHeader();
        info.systime = header != null && header instanceof Long ? (Long)header : System.currentTimeMillis();
        RTPPacket p = this.MakeRTPPacket(b, info);
        if (p == null) {
            return;
        }
        this.transmit(p);
        ++info.stats.total_pdu;
        info.stats.total_bytes += b.getLength();
        ++this.cache.sm.transstats.rtp_sent;
        this.cache.sm.transstats.bytes_sent += b.getLength();
    }
}

