/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.util;

import java.util.logging.Level;

public class Logger {
    private Level level;
    private java.util.logging.Logger delegate;
    private Logger levelDelegate;

    public Logger(java.util.logging.Logger delegate, Level level) {
        this.delegate = delegate;
        this.level = level;
    }

    public Logger(java.util.logging.Logger delegate, Logger levelDelegate) {
        this.delegate = delegate;
        this.levelDelegate = levelDelegate;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.levelDelegate != null ? this.levelDelegate.getLevel() : this.level;
    }

    public boolean isLoggable(Level level) {
        Level currentLevel = this.levelDelegate != null ? this.levelDelegate.getLevel() : this.level;
        int levelValue = currentLevel.intValue();
        return level.intValue() >= levelValue && levelValue != Level.OFF.intValue();
    }

    public void log(Level level, String msg) {
        if (this.isLoggable(level)) {
            this.delegate.log(level, msg);
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.delegate.log(level, msg, thrown);
        }
    }

    public void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void config(String msg) {
        this.log(Level.CONFIG, msg);
    }

    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    public void finer(String msg) {
        this.log(Level.FINER, msg);
    }

    public void finest(String msg) {
        this.log(Level.FINEST, msg);
    }

    public void debug(String msg) {
        this.fine(msg);
    }

    public void warn(String msg) {
        this.warning(msg);
    }

    public void error(String msg) {
        this.severe(msg);
    }

    public void trace(String msg) {
        this.finest(msg);
    }
}

