/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.domain.messages.UserActionMsg;
import com.ircclouds.irc.api.domain.messages.UserNotice;
import com.ircclouds.irc.api.domain.messages.UserPrivMsg;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.state.IIRCState;
import net.java.sip.communicator.impl.protocol.irc.AbstractIrcMessageListener;
import net.java.sip.communicator.impl.protocol.irc.ChatRoomIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.Command;
import net.java.sip.communicator.impl.protocol.irc.CommandFactory;
import net.java.sip.communicator.impl.protocol.irc.ContactIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.IdentityManager;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.MessageIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.exception.BadCommandException;
import net.java.sip.communicator.impl.protocol.irc.exception.BadCommandInvocationException;
import net.java.sip.communicator.impl.protocol.irc.exception.UnsupportedCommandException;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.util.Logger;

public class MessageManager {
    private static final Logger LOGGER = Logger.getLogger(MessageManager.class);
    private static final int START_OF_COMMAND_INDEX = 1;
    public static final int SAFETY_NET = 5;
    public static final int IRC_PROTOCOL_MAX_MESSAGE_SIZE = 510;
    private final IrcConnection connection;
    private final IRCApi irc;
    private final IIRCState connectionState;
    private final ProtocolProviderServiceIrcImpl provider;
    private final CommandFactory commandFactory;
    private final IdentityManager identity;

    public MessageManager(IrcConnection connection, IRCApi irc, IIRCState connectionState, ProtocolProviderServiceIrcImpl provider, IdentityManager identity) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        this.connection = connection;
        if (irc == null) {
            throw new IllegalArgumentException("irc cannot be null");
        }
        this.irc = irc;
        if (connectionState == null) {
            throw new IllegalArgumentException("connectionState cannot be null");
        }
        this.connectionState = connectionState;
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.provider = provider;
        if (identity == null) {
            throw new IllegalArgumentException("identity cannot be null");
        }
        this.identity = identity;
        this.irc.addListener((IMessageListener)new MessageManagerListener());
        this.commandFactory = new CommandFactory(this.provider, this.connection);
    }

    public void command(ChatRoomIrcImpl chatroom, String message) throws UnsupportedCommandException, BadCommandException, BadCommandInvocationException {
        if (!this.connectionState.isConnected()) {
            throw new IllegalStateException("Not connected to IRC server.");
        }
        this.command(chatroom.getIdentifier(), message);
    }

    public void command(Contact contact, MessageIrcImpl message) throws UnsupportedCommandException, BadCommandException, BadCommandInvocationException {
        if (!this.connectionState.isConnected()) {
            throw new IllegalStateException("Not connected to IRC server.");
        }
        this.command(contact.getAddress(), message.getContent());
    }

    private void command(String source, String message) throws UnsupportedCommandException, BadCommandException, BadCommandInvocationException {
        String msg = message.toLowerCase();
        int end = msg.indexOf(32);
        String command = end == -1 ? msg.substring(1) : message.substring(1, end);
        Command cmd = this.commandFactory.createCommand(command);
        try {
            cmd.execute(source, msg);
        }
        catch (IllegalArgumentException e) {
            String help = cmd.help();
            throw new BadCommandInvocationException(msg, help, e);
        }
        catch (IllegalStateException e) {
            String help = cmd.help();
            throw new BadCommandInvocationException(msg, help, e);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("Failed to execute command '" + command + "': " + e.getMessage()), (Throwable)e);
        }
    }

    public void message(ChatRoomIrcImpl chatroom, String message) throws OperationFailedException {
        if (!this.connectionState.isConnected()) {
            throw new IllegalStateException("Not connected to an IRC server.");
        }
        String target = chatroom.getIdentifier();
        int maxMsgSize = this.calculateMaximumMessageSize(0, target);
        if (maxMsgSize < message.length()) {
            LOGGER.warn((Object)("Message for " + target + " is too large. At best you can send the message up to: " + message.substring(0, maxMsgSize)));
            throw new OperationFailedException("Message is too large for this IRC server.", 11);
        }
        try {
            this.irc.message(target, message);
            LOGGER.trace((Object)"Message delivered to server successfully.");
        }
        catch (RuntimeException e) {
            LOGGER.trace((Object)("Failed to deliver message: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public void message(Contact contact, Message message) throws OperationFailedException {
        if (!this.connectionState.isConnected()) {
            throw new IllegalStateException("Not connected to an IRC server.");
        }
        String target = contact.getAddress();
        int maxMsgSize = this.calculateMaximumMessageSize(0, target);
        if (maxMsgSize < message.getContent().length()) {
            LOGGER.warn((Object)("Message for " + target + " is too large. At best you can send the message up to: " + message.getContent().substring(0, maxMsgSize)));
            throw new OperationFailedException("Message is too large for this IRC server.", 11);
        }
        try {
            this.irc.message(target, message.getContent());
            LOGGER.trace((Object)"Message delivered to server successfully.");
        }
        catch (RuntimeException e) {
            LOGGER.trace((Object)("Failed to deliver message: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public int calculateMaximumMessageSize(Contact contact) {
        return this.calculateMaximumMessageSize(5, contact.getAddress());
    }

    public int calculateMaximumMessageSize(ChatRoomIrcImpl room) {
        return this.calculateMaximumMessageSize(5, room.getIdentifier());
    }

    private int calculateMaximumMessageSize(int safety, String identifier) {
        StringBuilder builder = new StringBuilder(":");
        builder.append(this.identity.getIdentityString());
        builder.append(" PRIVMSG ");
        builder.append(identifier);
        builder.append(" :");
        return 510 - safety - builder.length();
    }

    private final class MessageManagerListener
    extends AbstractIrcMessageListener {
        private static final int RPL_AWAY = 301;
        private static final int ERR_NO_SUCH_NICK_CHANNEL = 401;

        public MessageManagerListener() {
            super(MessageManager.this.irc, MessageManager.this.connectionState);
        }

        public void onServerNumericMessage(ServerNumericMessage msg) {
            switch (msg.getNumericCode()) {
                case 401: {
                    String msgText;
                    int endOfTargetIndex;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Message did not get delivered: " + msg.asRaw()));
                    }
                    if ((endOfTargetIndex = (msgText = msg.getText()).indexOf(32)) == -1) {
                        LOGGER.trace((Object)"Expected target nick in error message, but it cannot be found. Stop parsing.");
                        break;
                    }
                    String targetNick = msgText.substring(0, endOfTargetIndex);
                    MessageIrcImpl message = new MessageIrcImpl("", "text/html", "UTF-8", null);
                    Contact to = MessageManager.this.provider.getPersistentPresence().findOrCreateContactByID(targetNick);
                    MessageManager.this.provider.getBasicInstantMessaging().fireMessageDeliveryFailed((Message)message, to, 5);
                    break;
                }
                case 301: {
                    String rawAwayText = msg.getText();
                    String awayUserNick = rawAwayText.substring(0, rawAwayText.indexOf(32));
                    String awayText = rawAwayText.substring(rawAwayText.indexOf(32) + 2);
                    MessageIrcImpl awayMessage = MessageIrcImpl.newAwayMessageFromIRC(awayText);
                    Contact awayUser = MessageManager.this.provider.getPersistentPresence().findOrCreateContactByID(awayUserNick);
                    MessageManager.this.provider.getBasicInstantMessaging().fireMessageReceived((Message)awayMessage, awayUser);
                    break;
                }
            }
        }

        public void onUserPrivMessage(UserPrivMsg msg) {
            String user = msg.getSource().getNick();
            MessageIrcImpl message = MessageIrcImpl.newMessageFromIRC(msg.getText());
            Contact from = MessageManager.this.provider.getPersistentPresence().findOrCreateContactByID(user);
            try {
                MessageManager.this.provider.getBasicInstantMessaging().fireMessageReceived((Message)message, from);
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)("Error occurred while delivering private message from user '" + user + "': " + msg.getText()), (Throwable)e);
            }
        }

        public void onUserNotice(UserNotice msg) {
            String user = msg.getSource().getNick();
            Contact from = MessageManager.this.provider.getPersistentPresence().findOrCreateContactByID(user);
            MessageIrcImpl message = MessageIrcImpl.newNoticeFromIRC(from, msg.getText());
            MessageManager.this.provider.getBasicInstantMessaging().fireMessageReceived((Message)message, from);
        }

        public void onUserAction(UserActionMsg msg) {
            String user = msg.getSource().getNick();
            ContactIrcImpl from = MessageManager.this.provider.getPersistentPresence().findContactByID(user);
            MessageIrcImpl message = MessageIrcImpl.newActionFromIRC(msg.getText());
            MessageManager.this.provider.getBasicInstantMessaging().fireMessageReceived((Message)message, (Contact)from);
        }
    }
}

