/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.ldap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.java.sip.communicator.impl.ldap.LdapPendingSearch;
import net.java.sip.communicator.service.ldap.LdapConstants;
import net.java.sip.communicator.service.ldap.LdapDirectory;
import net.java.sip.communicator.service.ldap.LdapDirectorySet;
import net.java.sip.communicator.service.ldap.LdapPersonFound;
import net.java.sip.communicator.service.ldap.LdapQuery;
import net.java.sip.communicator.service.ldap.LdapSearchSettings;
import net.java.sip.communicator.service.ldap.event.DefaultLdapEventManager;
import net.java.sip.communicator.service.ldap.event.LdapEvent;
import net.java.sip.communicator.service.ldap.event.LdapListener;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;

public class LdapDirectorySetImpl
extends DefaultLdapEventManager
implements LdapDirectorySet,
LdapConstants {
    private static Logger logger = Logger.getLogger(LdapDirectorySetImpl.class);
    private SortedMap<String, LdapDirectory> serverMap;
    private ConfigurationService configService;
    private HashMap<LdapQuery, LdapPendingSearch> pendingSearches = new HashMap();

    public LdapDirectorySetImpl() {
        this(null);
    }

    public LdapDirectorySetImpl(ConfigurationService configService) {
        this.serverMap = Collections.synchronizedSortedMap(new TreeMap());
        this.configService = configService;
    }

    @Override
    public LdapDirectory getServerWithName(String name) {
        return (LdapDirectory)this.serverMap.get(name);
    }

    @Override
    public LdapDirectory removeServerWithName(String name) {
        LdapDirectory removed = (LdapDirectory)this.serverMap.remove(name);
        if (this.configService != null) {
            removed.getSettings().persistentRemove();
        }
        return removed;
    }

    @Override
    public boolean addServer(LdapDirectory server) {
        this.serverMap.put(server.getSettings().getName(), server);
        if (this.configService != null) {
            server.getSettings().persistentSave();
        }
        return true;
    }

    @Override
    public boolean containsServerWithName(String name) {
        return this.serverMap.containsKey(name);
    }

    @Override
    public int size() {
        return this.serverMap.size();
    }

    @Override
    public SortedSet<LdapDirectory> getEnabledServers() {
        TreeSet<LdapDirectory> enabledServers = new TreeSet<LdapDirectory>();
        for (LdapDirectory server : this) {
            if (!server.isEnabled()) continue;
            enabledServers.add(server);
        }
        return enabledServers;
    }

    @Override
    public SortedSet<LdapDirectory> getDisabledServers() {
        TreeSet<LdapDirectory> enabledServers = new TreeSet<LdapDirectory>();
        for (LdapDirectory server : this) {
            if (!server.isEnabled()) continue;
            enabledServers.add(server);
        }
        return enabledServers;
    }

    @Override
    public Iterator<LdapDirectory> iterator() {
        return this.serverMap.values().iterator();
    }

    @Override
    public synchronized void searchPerson(Set<LdapDirectory> servers, LdapQuery query, LdapListener caller, LdapSearchSettings searchSettings) {
        if (servers == null) {
            throw new NullPointerException("servers shouldn't be null!");
        }
        if (query == null) {
            throw new NullPointerException("query shouldn't be null!");
        }
        if (caller == null) {
            throw new NullPointerException("caller shouldn't be null!");
        }
        this.pendingSearches.put(query, new LdapPendingSearch(servers, caller));
        for (LdapDirectory server : servers) {
            if (server == null) {
                logger.info((Object)"server is null");
            }
            server.searchPerson(query, this, searchSettings);
        }
    }

    @Override
    public void searchPerson(LdapQuery query, LdapListener caller, LdapSearchSettings searchSettings) {
        this.searchPerson(this.getEnabledServers(), query, caller, searchSettings);
    }

    @Override
    public synchronized void ldapEventReceived(LdapEvent event) {
        switch (event.getCause()) {
            case NEW_SEARCH_RESULT: {
                LdapPersonFound result = (LdapPersonFound)event.getContent();
                LdapQuery query = result.getQuery();
                if (this.pendingSearches.get(query) == null) break;
                this.fireLdapEvent(event, this.pendingSearches.get(query).getCaller());
                logger.trace((Object)("result event for query \"" + result.getQuery().toString() + "\" forwaded"));
                break;
            }
            case SEARCH_ERROR: 
            case SEARCH_CANCELLED: 
            case SEARCH_ACHIEVED: {
                LdapQuery query = (LdapQuery)event.getContent();
                if (this.pendingSearches.get(query) == null) break;
                this.pendingSearches.get(query).getPendingServers().remove(event.getSource());
                logger.trace((Object)("end event for query \"" + query.toString() + "\" on directory \"" + event.getSource() + "\""));
                if (this.pendingSearches.get(query).getPendingServers().size() != 0) break;
                this.fireLdapEvent(event, this.pendingSearches.get(query).getCaller());
                event = new LdapEvent(this, LdapEvent.LdapEventCause.SEARCH_ACHIEVED, query);
                this.pendingSearches.remove(query);
            }
        }
    }
}

