/*
 * Decompiled with CFR 0.152.
 */
package mork;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import mork.Event;
import mork.EventListener;
import mork.EventType;
import mork.ExceptionHandler;
import mork.ExceptionManager;
import mork.Log;

public class MorkParser {
    private Log log = new Log(this);
    private Collection<EventListener> eventListeners = new LinkedList<EventListener>();
    private Event event = new Event();
    private boolean ignoreTransactionFailures = false;

    public void addEventListener(EventListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeEventListener(EventListener listener) {
        this.eventListeners.remove(listener);
    }

    private void fireEvent(EventType eventType, String value) {
        this.event.eventType = eventType;
        this.event.value = value;
        for (EventListener eventListener : this.eventListeners) {
            eventListener.onEvent(this.event);
        }
    }

    private void fireEvent(EventType eventType) {
        this.fireEvent(eventType, null);
    }

    public void parse(String morkContent) {
        this.parse(new StringReader(morkContent));
    }

    public void parse(InputStream inputStream) {
        this.parse(new InputStreamReader(inputStream));
    }

    public void parse(File file) {
        try {
            this.parse(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void parse(Reader reader) {
        try {
            PushbackReader pis = new PushbackReader(reader, 8);
            this.parseMain(pis);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void parseMain(PushbackReader pis) throws IOException {
        block11: while (true) {
            int c = pis.read();
            switch (c) {
                case 60: {
                    this.parseDict(pis);
                    continue block11;
                }
                case 91: {
                    this.parseRow(pis);
                    continue block11;
                }
                case 40: {
                    this.parseCell(pis);
                    continue block11;
                }
                case 123: {
                    this.parseTable(pis);
                    continue block11;
                }
                case 47: {
                    int d = pis.read();
                    if (d == 47) {
                        this.parseComment(pis);
                        continue block11;
                    }
                    throw new RuntimeException("Unexpected character at current position: " + (char)d);
                }
                case 64: {
                    int d = pis.read();
                    if (d == 36) {
                        int e = pis.read();
                        if (e == 36) {
                            int f = pis.read();
                            if (f == 123) {
                                if (this.ignoreTransactionFailures) {
                                    try {
                                        this.parseGroup(pis);
                                    }
                                    catch (RuntimeException exception) {
                                        this.log.warn("Ignoring parsing error within group", exception);
                                    }
                                    continue block11;
                                }
                                this.parseGroup(pis);
                                continue block11;
                            }
                            pis.unread(f);
                        }
                        pis.unread(e);
                    }
                    pis.unread(d);
                    continue block11;
                }
                case -1: {
                    this.fireEvent(EventType.END_OF_FILE);
                    return;
                }
            }
        }
    }

    private void parseGroup(PushbackReader pis) throws IOException {
        String id = this.parseUntil(pis, "{@".toCharArray());
        String content = this.parseUntil(pis, "@$$}".toCharArray());
        String abort = this.parseUntil(pis, (String.valueOf(id) + "}@").toCharArray());
        if ("~abort~".equals(abort)) {
            this.fireEvent(EventType.GROUP_ABORT, id);
        } else {
            this.fireEvent(EventType.GROUP_COMMIT, content);
        }
    }

    private String parseUntil(PushbackReader pis, char[] string) throws IOException {
        StringBuffer buf = new StringBuffer();
        char[] temp = new char[string.length];
        temp[0] = string[0];
        while (true) {
            int c;
            if ((c = pis.read()) == -1) {
                continue;
            }
            if (c == string[0]) {
                int d = pis.read(temp, 1, temp.length - 1);
                if (d == -1) continue;
                if (Arrays.equals(string, temp)) break;
                buf.append(temp, 0, temp.length);
                continue;
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    private void parseTable(PushbackReader pis) throws IOException {
        this.fireEvent(EventType.BEGIN_TABLE);
        StringBuffer buffer = new StringBuffer();
        StringBuffer metaTableBuffer = new StringBuffer();
        boolean inMetaTable = false;
        block4: while (true) {
            int c = pis.read();
            switch (c) {
                case 123: {
                    inMetaTable = true;
                    this.fireEvent(EventType.BEGIN_METATABLE);
                    continue block4;
                }
                case 125: {
                    if (inMetaTable) {
                        this.fireEvent(EventType.END_METATABLE, metaTableBuffer.toString());
                        inMetaTable = false;
                        continue block4;
                    }
                    this.fireEvent(EventType.TABLE, buffer.toString());
                    return;
                }
            }
            if (c == 13 || c == 10 || c == -1) continue;
            if (inMetaTable) {
                metaTableBuffer.append((char)c);
                continue;
            }
            buffer.append((char)c);
        }
    }

    private void parseCell(PushbackReader pis) throws IOException {
        StringBuffer buffer = new StringBuffer();
        while (true) {
            int c = pis.read();
            switch (c) {
                case 92: {
                    int escapedCharacter = pis.read();
                    if (escapedCharacter == -1) {
                        throw new IOException("Escape character must not be last character in file");
                    }
                    buffer.append((char)escapedCharacter);
                    break;
                }
                case 41: {
                    this.fireEvent(EventType.CELL, buffer.toString());
                    return;
                }
            }
            if (c == 13 || c == 10 || c == -1) break;
            buffer.append((char)c);
        }
    }

    private void parseRow(PushbackReader pis) throws IOException {
        StringBuffer buffer = new StringBuffer();
        while (true) {
            int c = pis.read();
            switch (c) {
                case 93: {
                    this.fireEvent(EventType.ROW, buffer.toString());
                    return;
                }
            }
            if (c == -1) break;
            buffer.append((char)c);
        }
    }

    private void parseComment(PushbackReader pis) throws IOException {
        int c;
        StringBuffer buffer = new StringBuffer();
        while ((c = pis.read()) != 13 && c != 10 && c != -1) {
            buffer.append((char)c);
        }
        do {
            if ((c = pis.read()) != -1) continue;
            this.fireEvent(EventType.COMMENT, buffer.toString());
            return;
        } while (c == 13 || c == 10);
        pis.unread(c);
        this.fireEvent(EventType.COMMENT, buffer.toString());
    }

    private void parseDict(PushbackReader pis) throws IOException {
        this.fireEvent(EventType.BEGIN_DICT);
        StringBuffer buffer = new StringBuffer();
        boolean inMetaDict = false;
        boolean isInCell = false;
        block14: while (true) {
            int c = pis.read();
            if (isInCell) {
                switch (c) {
                    case -1: {
                        this.fireEvent(EventType.END_DICT, buffer.toString());
                        return;
                    }
                    case 41: {
                        if (buffer.charAt(buffer.length() - 1) != '\\') {
                            isInCell = false;
                        }
                        buffer.append((char)c);
                        continue block14;
                    }
                    case 36: {
                        if (buffer.charAt(buffer.length() - 1) != '\\') {
                            this.parseEncodedCharacter(pis, buffer);
                            continue block14;
                        }
                        buffer.append((char)c);
                        continue block14;
                    }
                }
                if (c == 13 || c == 10) continue;
                buffer.append((char)c);
                continue;
            }
            switch (c) {
                case -1: {
                    this.fireEvent(EventType.END_DICT, buffer.toString());
                    return;
                }
                case 60: {
                    this.fireEvent(EventType.BEGIN_DICT_METAINFO);
                    inMetaDict = true;
                    buffer.append((char)c);
                    continue block14;
                }
                case 36: {
                    this.parseEncodedCharacter(pis, buffer);
                    continue block14;
                }
                case 62: {
                    if (inMetaDict) {
                        this.fireEvent(EventType.END_DICT_METAINFO);
                        inMetaDict = false;
                        buffer.append((char)c);
                        continue block14;
                    }
                    this.fireEvent(EventType.END_DICT, buffer.toString());
                    return;
                }
                case 40: {
                    if (!isInCell) {
                        isInCell = true;
                    }
                    buffer.append((char)c);
                    continue block14;
                }
                case 41: {
                    if (isInCell) {
                        isInCell = false;
                    }
                    buffer.append((char)c);
                    continue block14;
                }
                case 47: {
                    if (isInCell) {
                        buffer.append((char)c);
                        continue block14;
                    }
                    int d = pis.read();
                    if (d == 47) {
                        this.parseComment(pis);
                        continue block14;
                    }
                    buffer.append((char)c);
                    continue block14;
                }
            }
            if (c == 13 || c == 10) continue;
            buffer.append((char)c);
        }
    }

    private void parseEncodedCharacter(PushbackReader pis, StringBuffer buffer) throws IOException {
        int c1 = pis.read();
        int c2 = pis.read();
        int i1 = Integer.valueOf(new String(new char[]{(char)c1, (char)c2}), 16);
        int dollar = pis.read();
        if (dollar == 36) {
            int c3 = pis.read();
            int c4 = pis.read();
            int i2 = Integer.valueOf(new String(new char[]{(char)c3, (char)c4}), 16);
            buffer.append(new String(new byte[]{(byte)i1, (byte)i2}, "UTF-8"));
        } else {
            buffer.append((char)i1);
            pis.unread(dollar);
        }
    }

    public void setIgnoreTransactionFailures(boolean ignoreTransactionFailures) {
        this.ignoreTransactionFailures = ignoreTransactionFailures;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        ExceptionManager.setExceptionHandler(exceptionHandler);
    }
}

