/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.acct;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.acct.AcctCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class ConfirmAck
extends AcctCommand {
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_UNAVAILABLE = 3;
    public static final int RESULT_ALREADY_CONFIRMED = 30;
    private static final int TYPE_ERROR_URL = 4;
    private final int result;
    private final String errorUrl;

    protected ConfirmAck(SnacPacket packet) {
        super(7);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        this.result = BinaryTools.getUShort(snacData, 0);
        ByteBlock tlvBlock = snacData.subBlock(2);
        ImmutableTlvChain chain = TlvTools.readChain(tlvBlock);
        this.errorUrl = chain.getString(4);
    }

    public ConfirmAck(int result) {
        this(result, null);
    }

    public ConfirmAck(int result, String errorURL) {
        super(7);
        DefensiveTools.checkRange(result, "result", 0);
        this.result = result;
        this.errorUrl = errorURL;
    }

    public final int getResult() {
        return this.result;
    }

    public final String getErrorUrl() {
        return this.errorUrl;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.result);
        if (this.errorUrl != null) {
            Tlv.getStringInstance(4, this.errorUrl).write(out);
        }
    }

    public String toString() {
        return "ConfirmAck with result " + this.result + " (url=" + this.errorUrl + ")";
    }
}

