/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.utils.SMSManager;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.util.Logger;

public class SendSmsDialog
extends SIPCommDialog {
    private Logger logger = Logger.getLogger(SendSmsDialog.class);
    private String title = GuiActivator.getResources().getI18NString("service.gui.SEND_SMS");
    private JLabel phoneNumberLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.ENTER_PHONE_NUMBER"));
    private JTextField phoneNumberBox = new JTextField();
    private JTextArea detailsArea = new JTextArea(GuiActivator.getResources().getI18NString("service.gui.SEND_SMS_DETAILS"));
    private JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
    private JButton sendButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.SEND"));
    private JPanel buttonPanel = new JPanel(new FlowLayout(2));
    private ChatPanel chatPanel;
    private String smsMessage;
    private ChatTransport chatTransport;

    public SendSmsDialog(ChatPanel chatPanel, ChatTransport chatTransport, String message) {
        super(chatPanel.getChatContainer().getFrame());
        this.chatPanel = chatPanel;
        this.chatTransport = chatTransport;
        this.smsMessage = message;
        this.setTitle(this.title);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.mainPanel.add((Component)this.phoneNumberLabel, "West");
        this.mainPanel.add((Component)this.phoneNumberBox, "Center");
        this.mainPanel.add((Component)this.detailsArea, "South");
        String defaultSmsNumber = chatTransport.getParentChatSession().getDefaultSmsNumber();
        this.phoneNumberBox.setText(defaultSmsNumber);
        this.detailsArea.setOpaque(false);
        this.detailsArea.setLineWrap(true);
        this.detailsArea.setWrapStyleWord(true);
        this.detailsArea.setEditable(false);
        this.buttonPanel.add(this.sendButton);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SendSmsDialog.this.sendSmsMessage(SendSmsDialog.this.phoneNumberBox.getText(), SendSmsDialog.this.smsMessage);
            }
        });
    }

    public void sendSmsMessage(String phoneNumber, String message) {
        if (phoneNumber != null) {
            this.chatTransport.getParentChatSession().setDefaultSmsNumber(phoneNumber);
        }
        SMSManager.sendSMS(phoneNumber, message, this.chatTransport, this.chatPanel);
        this.dispose();
    }

    protected void close(boolean isEscaped) {
        this.dispose();
    }
}

