/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.contactlist.AddContactDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.addgroup.CreateGroupDialog;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.skin.Skinnable;

public class CommonRightButtonMenu
extends SIPCommPopupMenu
implements ActionListener,
Skinnable {
    private final JMenuItem addContactItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT") + "...");
    private final JMenuItem createGroupItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.CREATE_GROUP"));
    private MainFrame mainFrame;

    public CommonRightButtonMenu(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        if (!ConfigurationUtils.isAddContactDisabled() && !ConfigurationUtils.isMergeContactDisabled()) {
            this.add(this.addContactItem);
        }
        if (!ConfigurationUtils.isCreateGroupDisabled()) {
            this.add(this.createGroupItem);
        }
        this.addContactItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.ADD_CONTACT"));
        this.createGroupItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CREATE_GROUP"));
        this.addContactItem.addActionListener(this);
        this.createGroupItem.addActionListener(this);
        this.loadSkin();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem item = (JMenuItem)e.getSource();
        if (item.equals(this.createGroupItem)) {
            CreateGroupDialog dialog = new CreateGroupDialog((Frame)((Object)this.mainFrame));
            dialog.setVisible(true);
        } else if (item.equals(this.addContactItem)) {
            AddContactDialog dialog = new AddContactDialog((Frame)((Object)this.mainFrame));
            dialog.setVisible(true);
        }
    }

    public void loadSkin() {
        this.addContactItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.ADD_CONTACT_16x16_ICON)));
        this.createGroupItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.GROUPS_16x16_ICON)));
    }
}

