/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactNode;
import net.java.sip.communicator.impl.gui.main.contactlist.DefaultTreeContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.GroupNode;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.UIGroupImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaUIContact;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.ShowMoreContact;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.SourceUIContact;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.ComponentUtils;
import net.java.sip.communicator.plugin.desktoputil.ExtendedPopupMenu;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTooltip;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.gui.ContactListFilter;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.muc.MUCService;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingServer;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Html2Text;
import net.java.sip.communicator.util.account.AccountUtils;
import net.java.sip.communicator.util.call.MetaContactPhoneUtil;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.util.OSUtils;

public class ContactListTreeCellRenderer
extends JPanel
implements TreeCellRenderer,
Icon,
Skinnable {
    private static final long serialVersionUID = 0L;
    private static final int AVATAR_HEIGHT = 30;
    private static final int AVATAR_WIDTH = 30;
    private static final int EXTENDED_AVATAR_HEIGHT = 45;
    private static final int EXTENDED_AVATAR_WIDTH = 45;
    private static final int BUTTON_WIDTH = 26;
    private static final int BUTTON_HEIGHT = 27;
    private static final int LEFT_BORDER = 5;
    private static final int TOP_BORDER = 2;
    private static final int BOTTOM_BORDER = 2;
    private static final int RIGHT_BORDER = 2;
    private static final int H_GAP = 2;
    private static final int V_GAP = 2;
    private Integer preferredSelectedContactNodeHeight = null;
    private Integer preferredNotSelectedContactNodeHeight = null;
    private Integer preferredGroupNodeHeight = null;
    private static final Image BUTTON_SEPARATOR_IMG = ImageLoader.getImage(ImageLoader.CONTACT_LIST_BUTTON_SEPARATOR);
    private ImageIcon openedGroupIcon;
    private ImageIcon closedGroupIcon;
    private Color groupForegroundColor;
    private Color contactForegroundColor;
    private final JLabel nameLabel = new JLabel();
    private final JLabel displayDetailsLabel = new JLabel();
    private final SIPCommButton callButton = new SIPCommButton();
    private final SIPCommButton callVideoButton = new SIPCommButton();
    private final SIPCommButton desktopSharingButton = new SIPCommButton();
    private final SIPCommButton chatButton = new SIPCommButton();
    private final WebButton webButton = new WebButton();
    private final SIPCommButton addContactButton = new SIPCommButton();
    private final GridBagConstraints constraints = new GridBagConstraints();
    protected final JLabel rightLabel = new JLabel();
    private Image msgReceivedImage;
    private final JLabel statusLabel = new JLabel();
    protected Icon statusIcon = new ImageIcon();
    protected boolean isSelected = false;
    protected int row = 0;
    protected TreeNode treeNode = null;
    private TreeContactList treeContactList;
    private List<JButton> customActionButtons;
    private List<JButton> customActionButtonsUIGroup;
    private SIPCommButton lastAddedButton;

    public ContactListTreeCellRenderer() {
        super(new GridBagLayout());
        this.loadSkin();
        this.setOpaque(true);
        this.nameLabel.setOpaque(false);
        this.displayDetailsLabel.setFont(this.getFont().deriveFont(9.0f));
        this.displayDetailsLabel.setForeground(Color.GRAY);
        this.rightLabel.setHorizontalAlignment(4);
        this.constraints.insets = new Insets(0, 0, 0, 2);
        this.constraints.anchor = 17;
        this.constraints.fill = 0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 1.0;
        this.add((Component)this.statusLabel, this.constraints);
        this.addLabels(1);
        this.callButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ContactListTreeCellRenderer.this.treeNode != null && ContactListTreeCellRenderer.this.treeNode instanceof ContactNode) {
                    ContactListTreeCellRenderer.this.call(ContactListTreeCellRenderer.this.treeNode, (JButton)ContactListTreeCellRenderer.this.callButton, false, false);
                }
            }
        });
        this.callVideoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ContactListTreeCellRenderer.this.treeNode != null && ContactListTreeCellRenderer.this.treeNode instanceof ContactNode) {
                    ContactListTreeCellRenderer.this.call(ContactListTreeCellRenderer.this.treeNode, (JButton)ContactListTreeCellRenderer.this.callVideoButton, true, false);
                }
            }
        });
        this.desktopSharingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ContactListTreeCellRenderer.this.treeNode != null && ContactListTreeCellRenderer.this.treeNode instanceof ContactNode) {
                    ContactListTreeCellRenderer.this.call(ContactListTreeCellRenderer.this.treeNode, (JButton)ContactListTreeCellRenderer.this.desktopSharingButton, true, true);
                }
            }
        });
        this.chatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ContactListTreeCellRenderer.this.treeNode != null && ContactListTreeCellRenderer.this.treeNode instanceof ContactNode) {
                    UIContactImpl contactDescriptor = ((ContactNode)ContactListTreeCellRenderer.this.treeNode).getContactDescriptor();
                    if (contactDescriptor.getDescriptor() instanceof MetaContact) {
                        GuiActivator.getUIService().getChatWindowManager().startChat((MetaContact)contactDescriptor.getDescriptor());
                    } else if (contactDescriptor.getDescriptor() instanceof SourceContact) {
                        SourceContact contact = (SourceContact)contactDescriptor.getDescriptor();
                        List imDetails = contact.getContactDetails(OperationSetBasicInstantMessaging.class);
                        List mucDetails = contact.getContactDetails(OperationSetMultiUserChat.class);
                        if (imDetails != null && imDetails.size() > 0) {
                            ProtocolProviderService pps = ((ContactDetail)imDetails.get(0)).getPreferredProtocolProvider(OperationSetBasicInstantMessaging.class);
                            if (pps != null) {
                                GuiActivator.getUIService().getChatWindowManager().startChat(contact.getContactAddress(), pps);
                            } else {
                                GuiActivator.getUIService().getChatWindowManager().startChat(contact.getContactAddress());
                            }
                        } else if (mucDetails != null && mucDetails.size() > 0) {
                            ChatRoomWrapper room = GuiActivator.getMUCService().findChatRoomWrapperFromSourceContact(contact);
                            if (room == null) {
                                ProtocolProviderService pps = ((ContactDetail)mucDetails.get(0)).getPreferredProtocolProvider(OperationSetMultiUserChat.class);
                                room = GuiActivator.getMUCService().findChatRoomWrapperFromChatRoomID(contact.getContactAddress(), pps);
                                if (room == null) {
                                    GuiActivator.getMUCService().createChatRoom(contact.getContactAddress(), pps, new ArrayList(), "", false, false, false);
                                }
                            }
                            if (room != null) {
                                GuiActivator.getMUCService().openChatRoom(room);
                            }
                        }
                    }
                }
            }
        });
        this.addContactButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIContactImpl contactDescriptor;
                if (ContactListTreeCellRenderer.this.treeNode != null && ContactListTreeCellRenderer.this.treeNode instanceof ContactNode && (contactDescriptor = ((ContactNode)ContactListTreeCellRenderer.this.treeNode).getContactDescriptor()) instanceof SourceUIContact) {
                    ContactListTreeCellRenderer.this.addContact((SourceUIContact)contactDescriptor);
                }
            }
        });
        this.webButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContactListTreeCellRenderer.openURL(ContactListTreeCellRenderer.this.treeContactList, ContactListTreeCellRenderer.this.treeNode, (JButton)((Object)ContactListTreeCellRenderer.this.webButton));
            }
        });
        this.initButtonToolTips();
        this.setToolTipText("");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.treeContactList = (TreeContactList)tree;
        this.row = row;
        this.isSelected = selected;
        this.treeNode = (TreeNode)value;
        this.rightLabel.setIcon(null);
        DefaultTreeContactList contactList = (DefaultTreeContactList)tree;
        this.setBorder();
        this.addLabels(1);
        if (contactList instanceof TreeContactList) {
            ContactListFilter filter = ((TreeContactList)contactList).getCurrentFilter();
            if (filter != null && filter.equals(TreeContactList.historyFilter) && value instanceof ContactNode && row % 2 == 0) {
                this.setBackground(Constants.CALL_HISTORY_EVEN_ROW_COLOR);
            } else {
                this.setBackground(Color.WHITE);
            }
        }
        this.nameLabel.setIcon(null);
        this.nameLabel.setText(value.toString());
        if (value instanceof ContactNode) {
            int avatarHeight;
            int avatarWidth;
            String displayName;
            MUCService mucService;
            UIContactImpl contact = ((ContactNode)value).getContactDescriptor();
            if (contact.getDescriptor() instanceof SourceContact && (mucService = GuiActivator.getMUCService()) != null && mucService.isMUCSourceContact((SourceContact)contact.getDescriptor())) {
                this.setBackground(Constants.CHAT_ROOM_ROW_COLOR);
            }
            if (!((displayName = contact.getDisplayName()) != null && displayName.trim().length() >= 1 || contact instanceof ShowMoreContact)) {
                displayName = GuiActivator.getResources().getI18NString("service.gui.UNKNOWN");
            }
            this.nameLabel.setText(displayName);
            if (this.statusIcon != null && contactList.isContactActive(contact) && this.statusIcon instanceof ImageIcon) {
                ((ImageIcon)this.statusIcon).setImage(this.msgReceivedImage);
            } else {
                this.statusIcon = contact.getStatusIcon();
            }
            this.statusLabel.setIcon(this.statusIcon);
            Font nameLabelFont = this.nameLabel.getFont();
            this.nameLabel.setFont(nameLabelFont.deriveFont(0, Math.max(nameLabelFont.getSize2D(), OSUtils.IS_WINDOWS ? 0.0f : 13.0f)));
            if (this.contactForegroundColor != null) {
                this.nameLabel.setForeground(this.contactForegroundColor);
            }
            this.initDisplayDetails(contact.getDisplayDetails());
            if (contact.getDescriptor() instanceof MetaContact && this.isMobile((MetaContact)contact.getDescriptor())) {
                this.nameLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.CONTACT_LIST_MOBILE_INDICATOR)));
                this.nameLabel.setHorizontalTextPosition(2);
            }
            if (this.treeContactList.isContactButtonsVisible()) {
                this.initButtonsPanel(contact);
            }
            if (this.isSelected && this.treeContactList.isContactButtonsVisible()) {
                avatarWidth = 45;
                avatarHeight = 45;
            } else {
                avatarWidth = 30;
                avatarHeight = 30;
            }
            ImageIcon avatar = contact.getScaledAvatar(this.isSelected, avatarWidth, avatarHeight);
            if (avatar != null) {
                this.rightLabel.setIcon(avatar);
            }
            if (contact instanceof ShowMoreContact) {
                this.rightLabel.setFont(this.rightLabel.getFont().deriveFont(12.0f));
                this.rightLabel.setForeground(Color.GRAY);
                this.rightLabel.setText((String)contact.getDescriptor());
            } else {
                this.rightLabel.setFont(this.rightLabel.getFont().deriveFont(9.0f));
                this.rightLabel.setText("");
            }
            this.setToolTipText(contact.getDescriptor().toString());
            if (this.preferredNotSelectedContactNodeHeight == null) {
                this.preferredNotSelectedContactNodeHeight = ComponentUtils.getStringHeight((Component)this.nameLabel) + 4 + ComponentUtils.getStringHeight((Component)this.displayDetailsLabel);
                this.preferredSelectedContactNodeHeight = this.preferredNotSelectedContactNodeHeight + 4 + 27;
            }
        } else if (value instanceof GroupNode) {
            UIGroupImpl groupItem = ((GroupNode)value).getGroupDescriptor();
            Font nameLabelFont = this.nameLabel.getFont();
            this.nameLabel.setFont(nameLabelFont.deriveFont(1, Math.max(nameLabelFont.getSize2D(), OSUtils.IS_WINDOWS ? 0.0f : 13.0f)));
            this.nameLabel.setText(groupItem.getDisplayName());
            if (this.groupForegroundColor != null) {
                this.nameLabel.setForeground(this.groupForegroundColor);
            }
            this.remove(this.displayDetailsLabel);
            this.remove((Component)this.callButton);
            this.remove((Component)this.callVideoButton);
            this.remove((Component)this.desktopSharingButton);
            this.remove((Component)this.chatButton);
            this.remove((Component)this.addContactButton);
            this.remove((Component)((Object)this.webButton));
            this.clearCustomActionButtons();
            Icon icon = this.statusIcon = expanded ? this.openedGroupIcon : this.closedGroupIcon;
            if (groupItem != this.treeContactList.getRootUIGroup()) {
                this.statusLabel.setIcon(expanded ? this.openedGroupIcon : this.closedGroupIcon);
            } else {
                this.statusLabel.setIcon(null);
            }
            this.rightLabel.setIcon(null);
            this.rightLabel.setText("");
            int groupItemCountChildContacts = groupItem.countChildContacts();
            if (groupItemCountChildContacts >= 0) {
                this.rightLabel.setFont(this.rightLabel.getFont().deriveFont(9.0f));
                this.rightLabel.setForeground(Color.BLACK);
                this.rightLabel.setText(groupItem.countOnlineChildContacts() + "/" + groupItemCountChildContacts);
            }
            this.initDisplayDetails(groupItem.getDisplayDetails());
            this.initButtonsPanel(groupItem);
            Object groupItemDescriptor = groupItem.getDescriptor();
            this.setToolTipText(groupItemDescriptor != null ? groupItemDescriptor.toString() : groupItem.getDisplayName());
            if (this.preferredGroupNodeHeight == null) {
                this.preferredGroupNodeHeight = ComponentUtils.getStringHeight((Component)this.nameLabel);
            }
        }
        return this;
    }

    private boolean isMobile(MetaContact metaContact) {
        boolean hasConnectedStatus = false;
        Iterator iter = metaContact.getContacts();
        while (iter.hasNext()) {
            Contact contact = (Contact)iter.next();
            boolean isConnected = contact.getPresenceStatus().isOnline();
            if (isConnected) {
                hasConnectedStatus = true;
            }
            if (!isConnected || contact.isMobile()) continue;
            return false;
        }
        if (!hasConnectedStatus) {
            return false;
        }
        return metaContact.getContactCount() > 0;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g = g.create();
        if (!(this.treeNode instanceof GroupNode) && !this.isSelected) {
            return;
        }
        AntialiasingManager.activateAntialiasing((Graphics)g);
        Graphics2D g2 = (Graphics2D)g;
        try {
            this.internalPaintComponent(g2);
        }
        finally {
            g.dispose();
        }
    }

    private void internalPaintComponent(Graphics2D g2) {
        Color borderColor = Color.GRAY;
        if (this.isSelected) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, Constants.SELECTED_COLOR, 0.0f, this.getHeight(), Constants.SELECTED_GRADIENT_COLOR));
            borderColor = Constants.SELECTED_COLOR;
        } else if (this.treeNode instanceof GroupNode) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, Constants.CONTACT_LIST_GROUP_BG_GRADIENT_COLOR, 0.0f, this.getHeight(), Constants.CONTACT_LIST_GROUP_BG_COLOR));
            borderColor = Constants.CONTACT_LIST_GROUP_BG_COLOR;
        }
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(borderColor);
        g2.drawLine(0, 0, this.getWidth(), 0);
        g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    @Override
    public int getIconHeight() {
        return this.getPreferredSize().height + 10;
    }

    @Override
    public int getIconWidth() {
        return this.treeContactList.getWidth() + 10;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = new Dimension();
        if (this.treeNode instanceof ContactNode) {
            UIContactImpl contact = ((ContactNode)this.treeNode).getContactDescriptor();
            int preferredHeight = contact.getPreferredHeight();
            preferredSize.height = preferredHeight > 0 ? preferredHeight : (contact instanceof ShowMoreContact ? (this.preferredGroupNodeHeight != null ? this.preferredGroupNodeHeight : 20) : (this.isSelected && this.treeContactList.isContactButtonsVisible() ? (this.preferredSelectedContactNodeHeight != null ? this.preferredSelectedContactNodeHeight : 70) : (this.preferredNotSelectedContactNodeHeight != null ? this.preferredNotSelectedContactNodeHeight : 35)));
        } else if (this.treeNode instanceof GroupNode) {
            UIGroupImpl group = ((GroupNode)this.treeNode).getGroupDescriptor();
            int preferredHeight = group.getPreferredHeight();
            preferredSize.height = this.isSelected && this.customActionButtonsUIGroup != null && !this.customActionButtonsUIGroup.isEmpty() ? (this.preferredGroupNodeHeight != null ? this.preferredGroupNodeHeight + 2 + 27 : 70) : (preferredHeight > 0 ? preferredHeight : (this.preferredGroupNodeHeight != null ? this.preferredGroupNodeHeight : 20));
        }
        return preferredSize;
    }

    private void addLabels(int nameLabelGridWidth) {
        this.remove(this.nameLabel);
        this.remove(this.rightLabel);
        this.remove(this.displayDetailsLabel);
        this.constraints.insets = this.treeNode != null && !(this.treeNode instanceof GroupNode) ? new Insets(0, 0, 2, 2) : new Insets(0, 0, 0, 2);
        this.constraints.anchor = 17;
        this.constraints.fill = 0;
        this.constraints.gridx = 1;
        this.constraints.gridy = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = nameLabelGridWidth;
        this.add((Component)this.nameLabel, this.constraints);
        this.constraints.anchor = 12;
        this.constraints.fill = 3;
        this.constraints.gridx = nameLabelGridWidth + 1;
        this.constraints.gridy = 0;
        this.constraints.gridheight = 3;
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 1.0;
        this.add((Component)this.rightLabel, this.constraints);
        if (this.treeNode != null && this.treeNode instanceof ContactNode) {
            this.constraints.anchor = 17;
            this.constraints.fill = 0;
            this.constraints.gridx = 1;
            this.constraints.gridy = 1;
            this.constraints.weightx = 1.0;
            this.constraints.weighty = 0.0;
            this.constraints.gridwidth = nameLabelGridWidth;
            this.constraints.gridheight = 1;
            this.add((Component)this.displayDetailsLabel, this.constraints);
        }
    }

    private void initDisplayDetails(String displayDetails) {
        this.remove(this.displayDetailsLabel);
        this.displayDetailsLabel.setText("");
        if (displayDetails != null && displayDetails.length() > 0) {
            displayDetails = Html2Text.extractText((String)displayDetails);
            displayDetails = displayDetails.replaceAll("\n|<br>|<br/>", " / ");
            this.displayDetailsLabel.setText(displayDetails);
        }
        this.constraints.anchor = 17;
        this.constraints.fill = 0;
        this.constraints.gridx = 1;
        this.constraints.gridy = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.add((Component)this.displayDetailsLabel, this.constraints);
    }

    private void initButtonsPanel(UIContact uiContact) {
        List<ServerStoredDetails.URLDetail> dets2;
        UIContactDetail desktopContact;
        UIContactDetail videoContact;
        this.remove((Component)this.chatButton);
        this.remove((Component)this.callButton);
        this.remove((Component)this.callVideoButton);
        this.remove((Component)this.desktopSharingButton);
        this.remove((Component)this.addContactButton);
        this.remove((Component)((Object)this.webButton));
        this.clearCustomActionButtons();
        if (!this.isSelected) {
            return;
        }
        UIContactDetail imContact = null;
        if (uiContact.getDescriptor() instanceof MetaContact || uiContact.getDescriptor() instanceof SourceContact) {
            imContact = uiContact.getDefaultContactDetail(OperationSetBasicInstantMessaging.class);
        }
        if (imContact == null) {
            imContact = uiContact.getDefaultContactDetail(OperationSetMultiUserChat.class);
        }
        int x = (this.statusIcon == null ? 0 : this.statusIcon.getIconWidth()) + 5 + 2;
        this.constraints.gridx = 0;
        int gridX = 0;
        if (imContact != null) {
            x += this.addButton(this.chatButton, ++gridX, x, false, true);
        }
        UIContactDetail telephonyContact = uiContact.getDefaultContactDetail(OperationSetBasicTelephony.class);
        MetaContactPhoneUtil contactPhoneUtil = null;
        DetailsListener detailsListener = null;
        if (uiContact.getDescriptor() != null && uiContact.getDescriptor() instanceof MetaContact && telephonyContact == null) {
            contactPhoneUtil = MetaContactPhoneUtil.getPhoneUtil((MetaContact)((MetaContact)uiContact.getDescriptor()));
            detailsListener = new DetailsListener(this.treeNode, (JButton)this.callButton, uiContact);
        }
        List providers = AccountUtils.getOpSetRegisteredProviders(OperationSetBasicTelephony.class, null, null);
        if (telephonyContact != null && telephonyContact.getAddress() != null || contactPhoneUtil != null && contactPhoneUtil.isCallEnabled(detailsListener) && providers.size() > 0) {
            x += this.addButton(this.callButton, ++gridX, x, false, true);
        }
        if ((videoContact = uiContact.getDefaultContactDetail(OperationSetVideoTelephony.class)) != null || contactPhoneUtil != null && contactPhoneUtil.isVideoCallEnabled(detailsListener)) {
            x += this.addButton(this.callVideoButton, ++gridX, x, false, true);
        }
        if ((desktopContact = uiContact.getDefaultContactDetail(OperationSetDesktopSharingServer.class)) != null || contactPhoneUtil != null && contactPhoneUtil.isDesktopSharingEnabled((OperationSetServerStoredContactInfo.DetailsResponseListener)detailsListener)) {
            x += this.addButton(this.desktopSharingButton, ++gridX, x, false, true);
        }
        if (uiContact.getDescriptor() instanceof SourceContact && uiContact.getDefaultContactDetail(OperationSetPersistentPresence.class) != null && AccountUtils.getOpSetRegisteredProviders(OperationSetPersistentPresence.class, null, null).size() > 0 && !ConfigurationUtils.isAddContactDisabled()) {
            x += this.addButton(this.addContactButton, ++gridX, x, false, true);
        }
        if (uiContact.getDescriptor() instanceof MetaContact) {
            WebDetailsListener webDetailsListener = new WebDetailsListener(this.treeNode, (JButton)((Object)this.webButton), uiContact);
            dets2 = ContactListTreeCellRenderer.getURLDetails(uiContact, webDetailsListener, true);
            if (dets2 != null && dets2.size() > 0) {
                x += this.addButton(this.webButton, ++gridX, x, false, true);
                this.webButton.setLinksFromURLDetail(dets2);
            } else {
                this.webButton.clearLinks();
            }
        } else if (uiContact.getDescriptor() instanceof SourceContact) {
            SourceContact srcContact = (SourceContact)uiContact.getDescriptor();
            try {
                dets2 = srcContact.getContactDetails(ContactDetail.Category.Web);
                if (dets2 != null && dets2.size() > 0) {
                    x += this.addButton(this.webButton, ++gridX, x, false, true);
                    this.webButton.setLinksFromContactDetail(dets2);
                } else {
                    this.webButton.clearLinks();
                }
            }
            catch (OperationNotSupportedException dets2) {
                // empty catch block
            }
        }
        Collection contactActions = uiContact.getContactCustomActionButtons();
        int lastGridX = gridX;
        if (contactActions != null && contactActions.size() > 0) {
            lastGridX = this.initContactActionButtons(contactActions, gridX, x);
        } else {
            this.addLabels(gridX);
        }
        if (this.lastAddedButton != null) {
            this.setButtonBg(this.lastAddedButton, lastGridX, true);
        }
        this.setBounds(0, 0, this.treeContactList.getWidth(), this.getPreferredSize().height);
    }

    private void initButtonsPanel(UIGroup uiGroup) {
        if (!this.isSelected) {
            return;
        }
        int x = (this.statusIcon == null ? 0 : this.statusIcon.getIconWidth()) + 5 + 2;
        int gridX = 0;
        Collection contactActions = uiGroup.getCustomActionButtons();
        int lastGridX = gridX;
        if (contactActions != null && contactActions.size() > 0) {
            lastGridX = this.initGroupActionButtons(contactActions, gridX, x);
        } else {
            this.addLabels(gridX);
        }
        if (this.lastAddedButton != null) {
            this.setButtonBg(this.lastAddedButton, lastGridX, true);
        }
        this.setBounds(0, 0, this.treeContactList.getWidth(), this.getPreferredSize().height);
    }

    private void clearCustomActionButtons() {
        Iterator<JButton> buttonsIter;
        if (this.customActionButtons != null && this.customActionButtons.size() > 0) {
            buttonsIter = this.customActionButtons.iterator();
            while (buttonsIter.hasNext()) {
                this.remove(buttonsIter.next());
            }
            this.customActionButtons.clear();
        }
        if (this.customActionButtonsUIGroup != null && this.customActionButtonsUIGroup.size() > 0) {
            buttonsIter = this.customActionButtonsUIGroup.iterator();
            while (buttonsIter.hasNext()) {
                this.remove(buttonsIter.next());
            }
            this.customActionButtonsUIGroup.clear();
        }
    }

    private int initGroupActionButtons(Collection<? extends JButton> contactActionButtons, int gridX, int xBounds) {
        this.addLabels(gridX + contactActionButtons.size());
        for (SIPCommButton sIPCommButton : contactActionButtons) {
            ToolTipManager.sharedInstance().unregisterComponent((JComponent)sIPCommButton);
            if (this.customActionButtonsUIGroup == null) {
                this.customActionButtonsUIGroup = new LinkedList<JButton>();
            }
            this.customActionButtonsUIGroup.add((JButton)sIPCommButton);
            xBounds += this.addButton(sIPCommButton, ++gridX, xBounds, false, false);
        }
        return gridX;
    }

    private int initContactActionButtons(Collection<? extends JButton> contactActionButtons, int gridX, int xBounds) {
        this.addLabels(gridX + contactActionButtons.size());
        for (SIPCommButton sIPCommButton : contactActionButtons) {
            ToolTipManager.sharedInstance().unregisterComponent((JComponent)sIPCommButton);
            if (this.customActionButtons == null) {
                this.customActionButtons = new LinkedList<JButton>();
            }
            this.customActionButtons.add((JButton)sIPCommButton);
            xBounds += this.addButton(sIPCommButton, ++gridX, xBounds, false, true);
        }
        return gridX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g = g.create();
        try {
            Graphics2D g2 = (Graphics2D)g;
            AntialiasingManager.activateAntialiasing((Graphics)g2);
            g2.setColor(Color.WHITE);
            g2.setComposite(AlphaComposite.getInstance(3, 0.8f));
            g2.fillRoundRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1, 10, 10);
            g2.setColor(Color.DARK_GRAY);
            g2.drawRoundRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1, 10, 10);
            g2.translate(x + 5, y + 5);
            super.paint(g2);
            g2.translate(x, y);
        }
        finally {
            g.dispose();
        }
    }

    public JButton getChatButton() {
        return this.chatButton;
    }

    public JButton getCallButton() {
        return this.callButton;
    }

    public JButton getCallVideoButton() {
        return this.callVideoButton;
    }

    public JButton getDesktopSharingButton() {
        return this.desktopSharingButton;
    }

    public JButton getAddContactButton() {
        return this.addContactButton;
    }

    private void call(TreeNode treeNode, JButton button, boolean isVideo, boolean isDesktopSharing) {
        if (!(treeNode instanceof ContactNode)) {
            return;
        }
        UIContactImpl contactDescriptor = ((ContactNode)treeNode).getContactDescriptor();
        Point location = new Point(button.getX(), button.getY() + button.getHeight());
        SwingUtilities.convertPointToScreen(location, this.treeContactList);
        location.y += this.treeContactList.getPathBounds((TreePath)this.treeContactList.getSelectionPath()).y;
        location.x += 8;
        location.y -= 8;
        CallManager.call(contactDescriptor, isVideo, isDesktopSharing, this.treeContactList, location);
    }

    private void addContact(SourceUIContact contact) {
        SourceContact sourceContact = (SourceContact)contact.getDescriptor();
        List details = sourceContact.getContactDetails(OperationSetPersistentPresence.class);
        int detailsCount = details.size();
        if (detailsCount > 1) {
            JMenuItem addContactMenu = TreeContactList.createAddContactMenu((SourceContact)contact.getDescriptor());
            JPopupMenu popupMenu = ((JMenu)addContactMenu).getPopupMenu();
            JLabel infoLabel = new JLabel();
            infoLabel.setText("<html><b>" + GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT") + "</b></html>");
            popupMenu.insert(infoLabel, 0);
            popupMenu.insert(new JPopupMenu.Separator(), 1);
            popupMenu.setFocusable(true);
            popupMenu.setInvoker(this.treeContactList);
            Point location = new Point(this.addContactButton.getX(), this.addContactButton.getY() + this.addContactButton.getHeight());
            SwingUtilities.convertPointToScreen(location, this.treeContactList);
            location.y += this.treeContactList.getPathBounds((TreePath)this.treeContactList.getSelectionPath()).y;
            popupMenu.setLocation(location.x + 8, location.y - 8);
            popupMenu.setVisible(true);
        } else if (details.size() == 1) {
            TreeContactList.showAddContactDialog((ContactDetail)details.get(0), sourceContact.getDisplayName());
        }
    }

    public Icon getDragIcon(JTree tree, Object dragObject, int index) {
        ContactListTreeCellRenderer dragC = (ContactListTreeCellRenderer)this.getTreeCellRendererComponent(tree, dragObject, false, false, true, index, true);
        dragC.setBounds(0, 0, dragC.getIconWidth(), dragC.getIconHeight());
        Icon rightLabelIcon = this.rightLabel.getIcon();
        int imageHeight = 0;
        int imageWidth = 0;
        if (rightLabelIcon != null) {
            imageWidth = rightLabelIcon.getIconWidth();
            imageHeight = rightLabelIcon.getIconHeight();
            dragC.rightLabel.setBounds(tree.getWidth() - imageWidth, 0, imageWidth, imageHeight);
        }
        dragC.statusLabel.setBounds(0, 0, this.statusLabel.getWidth(), this.statusLabel.getHeight());
        dragC.nameLabel.setBounds(this.statusLabel.getWidth(), 0, tree.getWidth() - imageWidth - 5, this.nameLabel.getHeight());
        dragC.displayDetailsLabel.setBounds(this.displayDetailsLabel.getX(), this.nameLabel.getHeight(), this.displayDetailsLabel.getWidth(), this.displayDetailsLabel.getHeight());
        return dragC;
    }

    public void resetRolloverState() {
        this.chatButton.getModel().setRollover(false);
        this.callButton.getModel().setRollover(false);
        this.callVideoButton.getModel().setRollover(false);
        this.desktopSharingButton.getModel().setRollover(false);
        this.addContactButton.getModel().setRollover(false);
        this.webButton.getModel().setRollover(false);
        if (this.customActionButtons != null) {
            for (JButton button : this.customActionButtons) {
                button.getModel().setRollover(false);
            }
        }
        if (this.customActionButtonsUIGroup != null) {
            for (JButton button : this.customActionButtonsUIGroup) {
                button.getModel().setRollover(false);
            }
        }
    }

    public void resetRolloverState(Component excludeComponent) {
        if (!this.chatButton.equals(excludeComponent)) {
            this.chatButton.getModel().setRollover(false);
        }
        if (!this.callButton.equals(excludeComponent)) {
            this.callButton.getModel().setRollover(false);
        }
        if (!this.callVideoButton.equals(excludeComponent)) {
            this.callVideoButton.getModel().setRollover(false);
        }
        if (!this.desktopSharingButton.equals(excludeComponent)) {
            this.desktopSharingButton.getModel().setRollover(false);
        }
        if (!this.addContactButton.equals(excludeComponent)) {
            this.addContactButton.getModel().setRollover(false);
        }
        if (!((Object)((Object)this.webButton)).equals(excludeComponent)) {
            this.webButton.getModel().setRollover(false);
        }
        if (this.customActionButtons != null) {
            for (JButton button : this.customActionButtons) {
                if (button.equals(excludeComponent)) continue;
                button.getModel().setRollover(false);
            }
        }
        if (this.customActionButtonsUIGroup != null) {
            for (JButton button : this.customActionButtonsUIGroup) {
                if (button.equals(excludeComponent)) continue;
                button.getModel().setRollover(false);
            }
        }
    }

    public void loadSkin() {
        int contactForegroundProperty;
        this.openedGroupIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.OPENED_GROUP_ICON));
        this.closedGroupIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.CLOSED_GROUP_ICON));
        this.callButton.setIconImage((Image)ImageLoader.getImage(ImageLoader.CALL_BUTTON_SMALL));
        this.callButton.setRolloverIcon((Image)ImageLoader.getImage(ImageLoader.CALL_BUTTON_SMALL_ROLLOVER));
        this.callButton.setPressedIcon((Image)ImageLoader.getImage(ImageLoader.CALL_BUTTON_SMALL_PRESSED));
        this.chatButton.setIconImage((Image)ImageLoader.getImage(ImageLoader.CHAT_BUTTON_SMALL));
        this.chatButton.setRolloverIcon((Image)ImageLoader.getImage(ImageLoader.CHAT_BUTTON_SMALL_ROLLOVER));
        this.chatButton.setPressedIcon((Image)ImageLoader.getImage(ImageLoader.CHAT_BUTTON_SMALL_PRESSED));
        this.msgReceivedImage = ImageLoader.getImage(ImageLoader.MESSAGE_RECEIVED_ICON);
        int groupForegroundProperty = GuiActivator.getResources().getColor("service.gui.CONTACT_LIST_GROUP_FOREGROUND");
        if (groupForegroundProperty > -1) {
            this.groupForegroundColor = new Color(groupForegroundProperty);
        }
        if ((contactForegroundProperty = GuiActivator.getResources().getColor("service.gui.CONTACT_LIST_CONTACT_FOREGROUND")) > -1) {
            this.contactForegroundColor = new Color(contactForegroundProperty);
        }
        this.callVideoButton.setIconImage((Image)ImageLoader.getImage(ImageLoader.CALL_VIDEO_BUTTON_SMALL));
        this.callVideoButton.setRolloverIcon((Image)ImageLoader.getImage(ImageLoader.CALL_VIDEO_BUTTON_SMALL_ROLLOVER));
        this.callVideoButton.setPressedIcon((Image)ImageLoader.getImage(ImageLoader.CALL_VIDEO_BUTTON_SMALL_PRESSED));
        this.desktopSharingButton.setIconImage((Image)ImageLoader.getImage(ImageLoader.DESKTOP_BUTTON_SMALL));
        this.desktopSharingButton.setRolloverIcon((Image)ImageLoader.getImage(ImageLoader.DESKTOP_BUTTON_SMALL_ROLLOVER));
        this.desktopSharingButton.setPressedIcon((Image)ImageLoader.getImage(ImageLoader.DESKTOP_BUTTON_SMALL_PRESSED));
        this.addContactButton.setIconImage((Image)ImageLoader.getImage(ImageLoader.ADD_CONTACT_BUTTON_SMALL));
        this.addContactButton.setRolloverIcon((Image)ImageLoader.getImage(ImageLoader.ADD_CONTACT_BUTTON_SMALL_ROLLOVER));
        this.addContactButton.setPressedIcon((Image)ImageLoader.getImage(ImageLoader.ADD_CONTACT_BUTTON_SMALL_PRESSED));
        this.webButton.setIconImage(ImageLoader.getImage(ImageLoader.WEB_BUTTON));
        this.webButton.setRolloverIcon(ImageLoader.getImage(ImageLoader.WEB_BUTTON_ROLLOVER));
        this.webButton.setPressedIcon(ImageLoader.getImage(ImageLoader.WEB_BUTTON_PRESSED));
    }

    private static List<ServerStoredDetails.URLDetail> getURLDetails(UIContact uiContact, WebDetailsListener webDetailsListener, boolean returnFirst) {
        Iterator contacts = ((MetaContact)uiContact.getDescriptor()).getContactsForOperationSet(OperationSetServerStoredContactInfo.class).iterator();
        ArrayList<ServerStoredDetails.URLDetail> res = new ArrayList<ServerStoredDetails.URLDetail>();
        boolean foundWebLink = false;
        while (contacts.hasNext()) {
            Contact contact = (Contact)contacts.next();
            OperationSetServerStoredContactInfo opset = (OperationSetServerStoredContactInfo)contact.getProtocolProvider().getOperationSet(OperationSetServerStoredContactInfo.class);
            Iterator iter = null;
            try {
                iter = opset.requestAllDetailsForContact(contact, (OperationSetServerStoredContactInfo.DetailsResponseListener)webDetailsListener);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (iter == null) continue;
            while (iter.hasNext()) {
                ServerStoredDetails.URLDetail webd;
                ServerStoredDetails.GenericDetail d = (ServerStoredDetails.GenericDetail)iter.next();
                if (!(d instanceof ServerStoredDetails.URLDetail) || (webd = (ServerStoredDetails.URLDetail)d).getDetailValue() == null) continue;
                res.add(webd);
                if (!returnFirst) continue;
                foundWebLink = true;
                break;
            }
            if (!returnFirst || !foundWebLink) continue;
            break;
        }
        if (returnFirst && res.isEmpty()) {
            return null;
        }
        return res;
    }

    private static void openURL(TreeContactList treeContactList, TreeNode treeNode, JButton button) {
        if (treeNode != null && treeNode instanceof ContactNode) {
            UIContactImpl contactDescriptor = ((ContactNode)treeNode).getContactDescriptor();
            ArrayList<String> urlDetails = null;
            if (contactDescriptor instanceof MetaUIContact) {
                List<ServerStoredDetails.URLDetail> details = ContactListTreeCellRenderer.getURLDetails(contactDescriptor, null, false);
                if (details == null) {
                    return;
                }
                urlDetails = new ArrayList<String>();
                for (ServerStoredDetails.URLDetail uRLDetail : details) {
                    urlDetails.add(uRLDetail.getDetailValue().toString());
                }
            } else if (contactDescriptor.getDescriptor() instanceof SourceContact) {
                SourceContact src = (SourceContact)contactDescriptor.getDescriptor();
                try {
                    List cDetails = src.getContactDetails(ContactDetail.Category.Web);
                    if (cDetails == null) {
                        return;
                    }
                    urlDetails = new ArrayList();
                    for (ContactDetail det : cDetails) {
                        urlDetails.add(det.getDetail());
                    }
                }
                catch (OperationNotSupportedException cDetails) {
                    // empty catch block
                }
            }
            if (urlDetails == null) {
                return;
            }
            if (urlDetails.size() == 1) {
                GuiActivator.getBrowserLauncher().openURL((String)urlDetails.get(0));
            } else {
                Point location = new Point(button.getX(), button.getY() + button.getHeight());
                SwingUtilities.convertPointToScreen(location, treeContactList);
                location.y += treeContactList.getPathBounds((TreePath)treeContactList.getSelectionPath()).y;
                location.x += 8;
                location.y -= 8;
                ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
                for (String url : urlDetails) {
                    String displayStr = url;
                    if (displayStr.length() > 60) {
                        displayStr = displayStr.substring(0, 60);
                        displayStr = displayStr + "...";
                    }
                    final JMenuItem menuItem = new JMenuItem(displayStr);
                    menuItem.setName(url);
                    menuItem.setToolTipText(url);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            GuiActivator.getBrowserLauncher().openURL(menuItem.getName());
                        }
                    });
                    items.add(menuItem);
                }
                new ExtendedPopupMenu((Component)treeContactList, null, items).showPopupMenu(location.x, location.y);
            }
        }
    }

    private int addButton(SIPCommButton button, int gridX, int xBounds, boolean isLast, boolean isContact) {
        this.lastAddedButton = button;
        this.constraints.insets = new Insets(0, 0, 2, 0);
        this.constraints.anchor = 17;
        this.constraints.fill = 0;
        this.constraints.gridx = gridX;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 0.0;
        this.add((Component)button, this.constraints);
        int yBounds = ComponentUtils.getStringSize((Component)this.nameLabel, (String)this.nameLabel.getText()).height;
        if (isContact) {
            yBounds += 8 + ComponentUtils.getStringSize((Component)this.displayDetailsLabel, (String)this.displayDetailsLabel.getText()).height;
        }
        button.setBounds(xBounds, yBounds, 26, 27);
        button.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setButtonBg(button, gridX, isLast);
        return button.getWidth();
    }

    private void setButtonBg(SIPCommButton button, int gridX, boolean isLast) {
        if (!isLast) {
            if (gridX == 1) {
                button.setBackgroundImage((Image)ImageLoader.getImage(ImageLoader.CONTACT_LIST_BUTTON_BG_LEFT));
            } else if (gridX > 1) {
                button.setBackgroundImage((Image)ImageLoader.getImage(ImageLoader.CONTACT_LIST_BUTTON_BG_MIDDLE));
            }
        } else if (gridX == 1) {
            button.setBackgroundImage((Image)ImageLoader.getImage(ImageLoader.CONTACT_LIST_ONE_BUTTON_BG));
        } else {
            button.setBackgroundImage((Image)ImageLoader.getImage(ImageLoader.CONTACT_LIST_BUTTON_BG_RIGHT));
        }
    }

    private void setBorder() {
        if (this.treeNode instanceof ContactNode && !(((ContactNode)this.treeNode).getContactDescriptor() instanceof ShowMoreContact)) {
            this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 2));
        }
    }

    private void initButtonToolTips() {
        this.callButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.CALL_CONTACT"));
        this.callVideoButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.VIDEO_CALL"));
        this.desktopSharingButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.SHARE_DESKTOP"));
        this.chatButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.SEND_MESSAGE"));
        this.addContactButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT"));
        this.webButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.WEBPAGE"));
        ToolTipManager ttManager = ToolTipManager.sharedInstance();
        ttManager.unregisterComponent((JComponent)this.callButton);
        ttManager.unregisterComponent((JComponent)this.callVideoButton);
        ttManager.unregisterComponent((JComponent)this.desktopSharingButton);
        ttManager.unregisterComponent((JComponent)this.chatButton);
        ttManager.unregisterComponent((JComponent)this.addContactButton);
        ttManager.unregisterComponent((JComponent)((Object)this.webButton));
    }

    private class WebButton
    extends SIPCommButton {
        private List<String> links;

        private WebButton() {
        }

        private void setLinksFromURLDetail(List<ServerStoredDetails.URLDetail> links) {
            this.links = new ArrayList<String>();
            for (ServerStoredDetails.URLDetail l : links) {
                this.links.add(l.getDetailValue().toString());
            }
        }

        private void setLinksFromContactDetail(List<ContactDetail> links) {
            this.links = new ArrayList<String>();
            for (ContactDetail l : links) {
                this.links.add(l.getDetail());
            }
        }

        private void clearLinks() {
            this.links = null;
        }

        public ExtendedTooltip getTooltip() {
            if (this.links == null) {
                return null;
            }
            ExtendedTooltip tip = new ExtendedTooltip(true);
            tip.setTitle(ContactListTreeCellRenderer.this.webButton.getToolTipText());
            for (String displayStr : this.links) {
                if (displayStr.length() > 60) {
                    displayStr = displayStr.substring(0, 60);
                    displayStr = displayStr + "...";
                }
                tip.addLine(null, displayStr);
            }
            return tip;
        }
    }

    private class DetailsListener
    implements OperationSetServerStoredContactInfo.DetailsResponseListener {
        private Object source;
        private JButton callButton;
        private UIContact uiContact;

        DetailsListener(Object source, JButton callButton, UIContact uiContact) {
            this.source = source;
            this.callButton = callButton;
            this.uiContact = uiContact;
        }

        public void detailsRetrieved(Iterator<ServerStoredDetails.GenericDetail> details) {
            if (!this.source.equals(ContactListTreeCellRenderer.this.treeNode)) {
                return;
            }
            while (details.hasNext()) {
                ServerStoredDetails.PhoneNumberDetail pnd;
                ServerStoredDetails.GenericDetail d = details.next();
                if (!(d instanceof ServerStoredDetails.PhoneNumberDetail) || d instanceof ServerStoredDetails.PagerDetail || d instanceof ServerStoredDetails.FaxDetail || (pnd = (ServerStoredDetails.PhoneNumberDetail)d).getNumber() == null || pnd.getNumber().length() <= 0) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DetailsListener.this.callButton.setEnabled(true);
                        if (pnd instanceof ServerStoredDetails.VideoDetail) {
                            ContactListTreeCellRenderer.this.callVideoButton.setEnabled(true);
                            ContactListTreeCellRenderer.this.desktopSharingButton.setEnabled(true);
                        }
                        ContactListTreeCellRenderer.this.treeContactList.refreshContact(DetailsListener.this.uiContact);
                    }
                });
                return;
            }
        }
    }

    private class WebDetailsListener
    implements OperationSetServerStoredContactInfo.DetailsResponseListener {
        private Object source;
        private JButton webButton;
        private UIContact uiContact;

        WebDetailsListener(Object source, JButton webButton, UIContact uiContact) {
            this.source = source;
            this.webButton = webButton;
            this.uiContact = uiContact;
        }

        public void detailsRetrieved(Iterator<ServerStoredDetails.GenericDetail> details) {
            if (!this.source.equals(ContactListTreeCellRenderer.this.treeNode)) {
                return;
            }
            while (details.hasNext()) {
                ServerStoredDetails.URLDetail webd;
                ServerStoredDetails.GenericDetail d = details.next();
                if (!(d instanceof ServerStoredDetails.URLDetail) || (webd = (ServerStoredDetails.URLDetail)d).getDetailValue() == null) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WebDetailsListener.this.webButton.setEnabled(true);
                        ContactListTreeCellRenderer.this.treeContactList.refreshContact(WebDetailsListener.this.uiContact);
                    }
                });
                return;
            }
        }
    }
}

