/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.translator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.media.Format;
import javax.media.format.UnsupportedFormatException;
import javax.media.protocol.DataSource;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.GlobalTransmissionStats;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionListener;
import javax.media.rtp.event.ReceiveStreamEvent;
import net.sf.fmj.media.rtp.RTPSessionMgr;
import net.sf.fmj.media.rtp.SSRCCache;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.rtp.translator.OutputDataStreamImpl;
import org.jitsi.impl.neomedia.rtp.translator.Payload;
import org.jitsi.impl.neomedia.rtp.translator.PushSourceStreamDesc;
import org.jitsi.impl.neomedia.rtp.translator.RTCPFeedbackMessageSender;
import org.jitsi.impl.neomedia.rtp.translator.RTPConnectorDesc;
import org.jitsi.impl.neomedia.rtp.translator.RTPConnectorImpl;
import org.jitsi.impl.neomedia.rtp.translator.SendStreamDesc;
import org.jitsi.impl.neomedia.rtp.translator.SendStreamImpl;
import org.jitsi.impl.neomedia.rtp.translator.StreamRTPManagerDesc;
import org.jitsi.service.neomedia.AbstractRTPTranslator;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.SSRCFactory;
import org.jitsi.util.Logger;

public class RTPTranslatorImpl
extends AbstractRTPTranslator
implements ReceiveStreamListener {
    private static final Logger LOGGER = Logger.getLogger(RTPTranslatorImpl.class);
    private RTPConnectorImpl connector;
    private long localSSRC = -1L;
    private final ReadWriteLock _lock = new ReentrantReadWriteLock();
    private final RTPManager manager = RTPManager.newInstance();
    private final RTCPFeedbackMessageSender rtcpFeedbackMessageSender = new RTCPFeedbackMessageSender(this);
    private final List<SendStreamDesc> sendStreams = new LinkedList<SendStreamDesc>();
    private final List<StreamRTPManagerDesc> streamRTPManagers = new ArrayList<StreamRTPManagerDesc>();

    public static long getPayloadLengthAndOffsetIfRTP(byte[] buf, int off, int len) {
        int padding;
        long PAYLOAD_LENGTH_AND_OFFSET_IF_NOT_RTP = -1L;
        if (len < 12) {
            return -1L;
        }
        byte b0 = buf[off];
        if ((b0 & 0xC0) >>> 6 != 2) {
            return -1L;
        }
        int cc = b0 & 0xF;
        int payloadLen = len - 12;
        int payloadOff = off + 12;
        if (cc < 0) {
            return -1L;
        }
        if ((payloadLen -= (cc *= 4)) < 0) {
            return -1L;
        }
        payloadOff += cc;
        if ((b0 & 0x20) != 0 && (payloadLen -= (padding = 0xFF & buf[off + len - 1])) < 0) {
            return -1L;
        }
        if ((b0 & 0x10) != 0) {
            if (payloadLen < 4) {
                return -1L;
            }
            int extensionLen = RTPTranslatorImpl.readUnsignedShort(buf, payloadOff + 2);
            if ((payloadLen -= (extensionLen = (extensionLen + 1) * 4)) < 0) {
                return -1L;
            }
            payloadOff += extensionLen;
        }
        long r = payloadLen;
        r <<= 32;
        return r |= (long)payloadOff;
    }

    static void logRTCP(Object obj, String methodName, byte[] buf, int off, int len) {
        int rtcpLength;
        byte b1;
        int pt;
        byte b0;
        int v;
        if (len >= 8 && (v = ((b0 = buf[off]) & 0xC0) >>> 6) == 2 && (pt = (b1 = buf[off + 1]) & 0xFF) == 203 && (rtcpLength = (RTPTranslatorImpl.readUnsignedShort(buf, off + 2) + 1) * 4) <= len) {
            int sc = b0 & 0x1F;
            int o = off + 4;
            int i = 0;
            int end = off + len;
            while (i < sc && o + 4 <= end) {
                int ssrc = RTPTranslatorImpl.readInt(buf, o);
                LOGGER.trace(obj.getClass().getName() + '.' + methodName + ": RTCP BYE SSRC/CSRC " + Long.toString((long)ssrc & 0xFFFFFFFFL));
                ++i;
                o += 4;
            }
        }
    }

    public static int readInt(byte[] buf, int off) {
        return (buf[off++] & 0xFF) << 24 | (buf[off++] & 0xFF) << 16 | (buf[off++] & 0xFF) << 8 | buf[off] & 0xFF;
    }

    public static int readUnsignedShort(byte[] buf, int off) {
        return (buf[off++] & 0xFF) << 8 | buf[off] & 0xFF;
    }

    public RTPTranslatorImpl() {
        this.manager.addReceiveStreamListener((ReceiveStreamListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFormat(StreamRTPManager streamRTPManager, Format format, int payloadType) {
        StreamRTPManagerDesc desc;
        Lock lock = this._lock.writeLock();
        lock.lock();
        try {
            this.manager.addFormat(format, payloadType);
            desc = this.getStreamRTPManagerDesc(streamRTPManager, true);
        }
        finally {
            lock.unlock();
        }
        desc.addFormat(format, payloadType);
    }

    public void addReceiveStreamListener(StreamRTPManager streamRTPManager, ReceiveStreamListener listener) {
        this.getStreamRTPManagerDesc(streamRTPManager, true).addReceiveStreamListener(listener);
    }

    public void addRemoteListener(StreamRTPManager streamRTPManager, RemoteListener listener) {
        this.manager.addRemoteListener(listener);
    }

    public void addSendStreamListener(StreamRTPManager streamRTPManager, SendStreamListener listener) {
    }

    public void addSessionListener(StreamRTPManager streamRTPManager, SessionListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeSendStream(SendStreamDesc sendStreamDesc) {
        block5: {
            Lock lock = this._lock.writeLock();
            lock.lock();
            try {
                if (!this.sendStreams.contains(sendStreamDesc) || sendStreamDesc.getSendStreamCount() >= 1) break block5;
                SendStream sendStream = sendStreamDesc.sendStream;
                try {
                    sendStream.close();
                }
                catch (NullPointerException npe) {
                    LOGGER.error("Failed to close send stream", npe);
                }
                this.sendStreams.remove(sendStreamDesc);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendStream createSendStream(StreamRTPManager streamRTPManager, DataSource dataSource, int streamIndex) throws IOException, UnsupportedFormatException {
        SendStreamImpl ret;
        Lock lock = this._lock.writeLock();
        lock.lock();
        try {
            SendStream sendStream;
            SendStreamDesc sendStreamDesc = null;
            for (SendStreamDesc s : this.sendStreams) {
                if (s.dataSource != dataSource || s.streamIndex != streamIndex) continue;
                sendStreamDesc = s;
                break;
            }
            if (sendStreamDesc == null && (sendStream = this.manager.createSendStream(dataSource, streamIndex)) != null) {
                sendStreamDesc = new SendStreamDesc(this, dataSource, streamIndex, sendStream);
                this.sendStreams.add(sendStreamDesc);
            }
            ret = sendStreamDesc == null ? null : sendStreamDesc.getSendStream(streamRTPManager, true);
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int didRead(PushSourceStreamDesc streamDesc, byte[] buf, int off, int len, int flags) throws IOException {
        Lock lock = this._lock.readLock();
        lock.lock();
        try {
            OutputDataStreamImpl outputStream;
            boolean data = streamDesc.data;
            StreamRTPManagerDesc streamRTPManager = streamDesc.connectorDesc.streamRTPManagerDesc;
            Format format = null;
            if (data) {
                if (!streamRTPManager.streamRTPManager.getMediaStream().getDirection().allowsReceiving()) {
                    int n = len;
                    return n;
                }
                if ((flags & 4) == 4) {
                    int n = len;
                    return n;
                }
                if (len >= 12 && (buf[off] & 0xC0) >>> 6 == 2) {
                    int ssrc = RTPTranslatorImpl.readInt(buf, off + 8);
                    if (!streamRTPManager.containsReceiveSSRC(ssrc)) {
                        if (this.findStreamRTPManagerDescByReceiveSSRC(ssrc, streamRTPManager) == null) {
                            streamRTPManager.addReceiveSSRC(ssrc);
                        } else {
                            int n = 0;
                            return n;
                        }
                    }
                    int pt = buf[off + 1] & 0x7F;
                    format = streamRTPManager.getFormat(pt);
                    this.rtcpFeedbackMessageSender.maybeStopRequesting(streamRTPManager, ssrc, buf, off, len);
                }
            } else if (LOGGER.isTraceEnabled()) {
                RTPTranslatorImpl.logRTCP(this, "read", buf, off, len);
            }
            OutputDataStreamImpl outputDataStreamImpl = outputStream = data ? this.connector.getDataOutputStream() : this.connector.getControlOutputStream();
            if (outputStream != null) {
                outputStream.write(buf, off, len, format, streamRTPManager);
            }
        }
        finally {
            lock.unlock();
        }
        return len;
    }

    @Override
    public void dispose() {
        Lock lock = this._lock.writeLock();
        lock.lock();
        try {
            this.rtcpFeedbackMessageSender.dispose();
            this.manager.removeReceiveStreamListener((ReceiveStreamListener)this);
            try {
                this.manager.dispose();
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                LOGGER.error("Failed to dispose of RTPManager", t);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(StreamRTPManager streamRTPManager) {
        Lock lock = this._lock.writeLock();
        lock.lock();
        try {
            Iterator<StreamRTPManagerDesc> streamRTPManagerIter = this.streamRTPManagers.iterator();
            while (streamRTPManagerIter.hasNext()) {
                StreamRTPManagerDesc streamRTPManagerDesc = streamRTPManagerIter.next();
                if (streamRTPManagerDesc.streamRTPManager != streamRTPManager) continue;
                RTPConnectorDesc connectorDesc = streamRTPManagerDesc.connectorDesc;
                if (connectorDesc != null) {
                    if (this.connector != null) {
                        this.connector.removeConnector(connectorDesc);
                    }
                    connectorDesc.connector.close();
                    streamRTPManagerDesc.connectorDesc = null;
                }
                streamRTPManagerIter.remove();
                break;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public StreamRTPManager findStreamRTPManagerByReceiveSSRC(int receiveSSRC) {
        StreamRTPManagerDesc desc = this.findStreamRTPManagerDescByReceiveSSRC(receiveSSRC, null);
        return desc == null ? null : desc.streamRTPManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamRTPManagerDesc findStreamRTPManagerDescByReceiveSSRC(int receiveSSRC, StreamRTPManagerDesc exclusion) {
        Lock lock = this._lock.readLock();
        StreamRTPManagerDesc ret = null;
        lock.lock();
        try {
            int count = this.streamRTPManagers.size();
            for (int i = 0; i < count; ++i) {
                StreamRTPManagerDesc s = this.streamRTPManagers.get(i);
                if (s == exclusion || !s.containsReceiveSSRC(receiveSSRC)) continue;
                ret = s;
                break;
            }
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public Object getControl(StreamRTPManager streamRTPManager, String controlType) {
        return this.manager.getControl(controlType);
    }

    public GlobalReceptionStats getGlobalReceptionStats(StreamRTPManager streamRTPManager) {
        return this.manager.getGlobalReceptionStats();
    }

    public GlobalTransmissionStats getGlobalTransmissionStats(StreamRTPManager streamRTPManager) {
        return this.manager.getGlobalTransmissionStats();
    }

    public long getLocalSSRC(StreamRTPManager streamRTPManager) {
        return this.localSSRC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ReceiveStream> getReceiveStreams(StreamRTPManager streamRTPManager) {
        Lock lock = this._lock.readLock();
        Vector<ReceiveStream> receiveStreams = null;
        lock.lock();
        try {
            Vector managerReceiveStreams;
            StreamRTPManagerDesc streamRTPManagerDesc = this.getStreamRTPManagerDesc(streamRTPManager, false);
            if (streamRTPManagerDesc != null && (managerReceiveStreams = this.manager.getReceiveStreams()) != null) {
                receiveStreams = new Vector<ReceiveStream>(managerReceiveStreams.size());
                for (Object s : managerReceiveStreams) {
                    ReceiveStream receiveStream = (ReceiveStream)s;
                    int receiveSSRC = (int)receiveStream.getSSRC();
                    if (!streamRTPManagerDesc.containsReceiveSSRC(receiveSSRC)) continue;
                    receiveStreams.add(receiveStream);
                }
            }
        }
        finally {
            lock.unlock();
        }
        return receiveStreams;
    }

    public RTCPFeedbackMessageSender getRtcpFeedbackMessageSender() {
        return this.rtcpFeedbackMessageSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<SendStream> getSendStreams(StreamRTPManager streamRTPManager) {
        Lock lock = this._lock.readLock();
        Vector<SendStreamImpl> sendStreams = null;
        lock.lock();
        try {
            Vector managerSendStreams = this.manager.getSendStreams();
            if (managerSendStreams != null) {
                sendStreams = new Vector<SendStreamImpl>(managerSendStreams.size());
                for (SendStreamDesc sendStreamDesc : this.sendStreams) {
                    SendStreamImpl sendStream;
                    if (!managerSendStreams.contains(sendStreamDesc.sendStream) || (sendStream = sendStreamDesc.getSendStream(streamRTPManager, false)) == null) continue;
                    sendStreams.add(sendStream);
                }
            }
        }
        finally {
            lock.unlock();
        }
        return sendStreams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamRTPManagerDesc getStreamRTPManagerDesc(StreamRTPManager streamRTPManager, boolean create) {
        Lock lock = create ? this._lock.writeLock() : this._lock.readLock();
        StreamRTPManagerDesc ret = null;
        lock.lock();
        try {
            for (StreamRTPManagerDesc s : this.streamRTPManagers) {
                if (s.streamRTPManager != streamRTPManager) continue;
                ret = s;
                break;
            }
            if (ret == null && create) {
                ret = new StreamRTPManagerDesc(streamRTPManager);
                this.streamRTPManagers.add(ret);
            }
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    @Override
    public List<StreamRTPManager> getStreamRTPManagers() {
        ArrayList<StreamRTPManager> ret = new ArrayList<StreamRTPManager>(this.streamRTPManagers.size());
        for (StreamRTPManagerDesc streamRTPManagerDesc : this.streamRTPManagers) {
            ret.add(streamRTPManagerDesc.streamRTPManager);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(StreamRTPManager streamRTPManager, RTPConnector connector) {
        Lock w = this._lock.writeLock();
        Lock r = this._lock.readLock();
        w.lock();
        Lock lock = w;
        try {
            if (this.connector == null) {
                this.connector = new RTPConnectorImpl(this);
                this.manager.initialize((RTPConnector)this.connector);
            }
            StreamRTPManagerDesc streamRTPManagerDesc = this.getStreamRTPManagerDesc(streamRTPManager, true);
            r.lock();
            w.unlock();
            lock = r;
            StreamRTPManagerDesc streamRTPManagerDesc2 = streamRTPManagerDesc;
            synchronized (streamRTPManagerDesc2) {
                RTPConnectorDesc connectorDesc = streamRTPManagerDesc.connectorDesc;
                if (connectorDesc == null || connectorDesc.connector != connector) {
                    if (connectorDesc != null) {
                        this.connector.removeConnector(connectorDesc);
                    }
                    connectorDesc = connector == null ? null : new RTPConnectorDesc(streamRTPManagerDesc, connector);
                    streamRTPManagerDesc.connectorDesc = connectorDesc;
                }
                if (connectorDesc != null) {
                    this.connector.addConnector(connectorDesc);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void removeReceiveStreamListener(StreamRTPManager streamRTPManager, ReceiveStreamListener listener) {
        StreamRTPManagerDesc desc = this.getStreamRTPManagerDesc(streamRTPManager, false);
        if (desc != null) {
            desc.removeReceiveStreamListener(listener);
        }
    }

    public void removeRemoteListener(StreamRTPManager streamRTPManager, RemoteListener listener) {
        this.manager.removeRemoteListener(listener);
    }

    public void removeSendStreamListener(StreamRTPManager streamRTPManager, SendStreamListener listener) {
    }

    public void removeSessionListener(StreamRTPManager streamRTPManager, SessionListener listener) {
    }

    public void setLocalSSRC(long localSSRC) {
        this.localSSRC = localSSRC;
    }

    public void setSSRCFactory(SSRCFactory ssrcFactory) {
        RTPManager manager = this.manager;
        if (manager instanceof org.jitsi.impl.neomedia.jmfext.media.rtp.RTPSessionMgr) {
            ((org.jitsi.impl.neomedia.jmfext.media.rtp.RTPSessionMgr)manager).setSSRCFactory(ssrcFactory);
        }
    }

    public void update(ReceiveStreamEvent event) {
        int receiveSSRC;
        StreamRTPManagerDesc streamRTPManagerDesc;
        ReceiveStream receiveStream;
        if (event != null && (receiveStream = event.getReceiveStream()) != null && (streamRTPManagerDesc = this.findStreamRTPManagerDescByReceiveSSRC(receiveSSRC = (int)receiveStream.getSSRC(), null)) != null) {
            for (ReceiveStreamListener listener : streamRTPManagerDesc.getReceiveStreamListeners()) {
                listener.update(event);
            }
        }
    }

    boolean willWrite(StreamRTPManagerDesc source, byte[] buffer, int offset, int length, StreamRTPManagerDesc destination, boolean data) {
        MediaStream src = source == null ? null : source.streamRTPManager.getMediaStream();
        MediaStream dst = destination.streamRTPManager.getMediaStream();
        return this.willWrite(src, buffer, offset, length, dst, data);
    }

    public boolean writeControlPayload(Payload controlPayload, MediaStream destination) {
        RTPConnectorImpl connector = this.connector;
        return connector == null ? false : connector.writeControlPayload(controlPayload, destination);
    }

    @Override
    public SSRCCache getSSRCCache() {
        return ((RTPSessionMgr)this.manager).getSSRCCache();
    }
}

