/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.presence.avatar;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.fileaccess.FileCategory;

public class AvatarStackManager {
    private static final Logger logger = Logger.getLogger(AvatarStackManager.class);
    private static final String STORE_DIR = "avatarcache" + File.separator + "userimages" + File.separator;

    public static void deleteImage(int index) {
        String fileName = STORE_DIR + index + ".png";
        try {
            File imageFile = DesktopUtilActivator.getFileAccessService().getPrivatePersistentFile(fileName, FileCategory.CACHE);
            if (imageFile.exists() && !imageFile.delete()) {
                logger.error((Object)("Failed to delete stored image at index " + index));
            }
        }
        catch (Exception e) {
            logger.info((Object)("Failed to access file: " + fileName), (Throwable)e);
        }
    }

    public static BufferedImage loadImage(int index) {
        File imageFile;
        try {
            String imagePath = STORE_DIR + index + ".png";
            imageFile = DesktopUtilActivator.getFileAccessService().getPrivatePersistentFile(imagePath, FileCategory.CACHE);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to access stored image at index " + index), (Throwable)e);
            return null;
        }
        if (!imageFile.exists()) {
            return null;
        }
        try {
            return ImageIO.read(imageFile);
        }
        catch (IOException ioe) {
            logger.error((Object)("Failed to read file " + imageFile), (Throwable)ioe);
            return null;
        }
    }

    private static void moveImage(int oldIndex, int newIndex) {
        String oldImagePath = STORE_DIR + oldIndex + ".png";
        String newImagePath = STORE_DIR + newIndex + ".png";
        try {
            FileAccessService fas = DesktopUtilActivator.getFileAccessService();
            File oldFile = fas.getPrivatePersistentFile(oldImagePath, FileCategory.CACHE);
            if (oldFile.exists()) {
                File newFile = fas.getPrivatePersistentFile(newImagePath, FileCategory.CACHE);
                oldFile.renameTo(newFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void popFirstImage(int nbImages) {
        for (int i = nbImages - 1; i > 0; --i) {
            AvatarStackManager.moveImage(i, i - 1);
        }
    }

    public static void storeImage(BufferedImage image, int index) {
        String imagePath = STORE_DIR + index + ".png";
        try {
            FileAccessService fas = DesktopUtilActivator.getFileAccessService();
            File storeDir = fas.getPrivatePersistentDirectory(STORE_DIR, FileCategory.CACHE);
            storeDir.mkdirs();
            File file = fas.getPrivatePersistentFile(imagePath, FileCategory.CACHE);
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to store image at index " + index), (Throwable)e);
        }
    }
}

