/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import org.jivesoftware.smack.proxy.ProxyException;
import org.jivesoftware.smack.proxy.ProxyInfo;

public class Socks4ProxySocketFactory
extends SocketFactory {
    private ProxyInfo proxy;

    public Socks4ProxySocketFactory(ProxyInfo proxy) {
        this.proxy = proxy;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.socks4ProxifiedSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.socks4ProxifiedSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.socks4ProxifiedSocket(host.getHostAddress(), port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.socks4ProxifiedSocket(address.getHostAddress(), port);
    }

    private Socket socks4ProxifiedSocket(String host, int port) throws IOException {
        Socket socket = null;
        InputStream in = null;
        OutputStream out = null;
        String proxy_host = this.proxy.getProxyAddress();
        int proxy_port = this.proxy.getProxyPort();
        String user = this.proxy.getProxyUsername();
        String passwd = this.proxy.getProxyPassword();
        try {
            int i;
            socket = new Socket(proxy_host, proxy_port);
            in = socket.getInputStream();
            out = socket.getOutputStream();
            socket.setTcpNoDelay(true);
            byte[] buf = new byte[1024];
            int index = 0;
            index = 0;
            buf[index++] = 4;
            buf[index++] = 1;
            buf[index++] = (byte)(port >>> 8);
            buf[index++] = (byte)(port & 0xFF);
            try {
                InetAddress addr = InetAddress.getByName(host);
                byte[] byteAddress = addr.getAddress();
                for (i = 0; i < byteAddress.length; ++i) {
                    buf[index++] = byteAddress[i];
                }
            }
            catch (UnknownHostException uhe) {
                throw new ProxyException(ProxyInfo.ProxyType.SOCKS4, uhe.toString(), uhe);
            }
            if (user != null) {
                System.arraycopy(user.getBytes(), 0, buf, index, user.length());
                index += user.length();
            }
            buf[index++] = 0;
            out.write(buf, 0, index);
            int len = 6;
            for (int s = 0; s < len; s += i) {
                i = in.read(buf, s, len - s);
                if (i > 0) continue;
                throw new ProxyException(ProxyInfo.ProxyType.SOCKS4, "stream is closed");
            }
            if (buf[0] != 0) {
                throw new ProxyException(ProxyInfo.ProxyType.SOCKS4, "server returns VN " + buf[0]);
            }
            if (buf[1] != 90) {
                try {
                    socket.close();
                }
                catch (Exception i2) {
                    // empty catch block
                }
                String message = "ProxySOCKS4: server returns CD " + buf[1];
                throw new ProxyException(ProxyInfo.ProxyType.SOCKS4, message);
            }
            byte[] temp = new byte[2];
            in.read(temp, 0, 2);
            return socket;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProxyException(ProxyInfo.ProxyType.SOCKS4, e.toString());
        }
    }
}

