/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.replacement.hulu;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import net.java.sip.communicator.service.replacement.ReplacementService;
import net.java.sip.communicator.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class ReplacementServiceHuluImpl
implements ReplacementService {
    private static final Logger logger = Logger.getLogger(ReplacementServiceHuluImpl.class);
    public static final String HULU_PATTERN = "(https?\\:\\/\\/(www\\.)*?hulu\\.com\\/watch\\/([a-zA-Z0-9_\\-]+))(\\/([^\\\"\\<]*)*)";
    public static final String HULU_CONFIG_LABEL = "Hulu";
    public static final String SOURCE_NAME = "HULU";

    public ReplacementServiceHuluImpl() {
        logger.trace((Object)"Creating a Hulu Source.");
    }

    public String getReplacement(String sourceString) {
        try {
            String inputLine;
            String url = "http://api.embed.ly/1/oembed?url=" + sourceString + "&key=cff57b37766440a6a8aa45df88097efe";
            URL sourceURL = new URL(url);
            URLConnection conn = sourceURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String holder = "";
            while ((inputLine = in.readLine()) != null) {
                holder = inputLine;
            }
            in.close();
            JSONObject wrapper = (JSONObject)JSONValue.parseWithException((String)holder);
            String thumbUrl = (String)wrapper.get((Object)"thumbnail_url");
            if (thumbUrl != null) {
                return thumbUrl;
            }
        }
        catch (Throwable e) {
            logger.error((Object)"Error parsing", e);
        }
        return sourceString;
    }

    public String getSourceName() {
        return SOURCE_NAME;
    }

    public String getPattern() {
        return HULU_PATTERN;
    }
}

