/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.lookandfeel;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.util.skin.Skinnable;

public class SIPCommToggleButtonUI
extends BasicToggleButtonUI
implements Skinnable {
    private static BufferedImage buttonBG = ImageLoader.getImage(ImageLoader.BUTTON);
    private static BufferedImage buttonPressedBG = ImageLoader.getImage(ImageLoader.TOGGLE_BUTTON_PRESSED);
    private boolean bufferIsPressed = false;
    private BufferedImage paintBuffer = null;
    private Component bufferedComponent = null;

    public static ComponentUI createUI(JComponent c) {
        return new SIPCommToggleButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setOpaque(false);
        b.setBorderPainted(false);
        b.setFocusPainted(true);
    }

    @Override
    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setBorderPainted(true);
        b.setFocusPainted(false);
        b.setOpaque(true);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean isShownPressed;
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        boolean bl = isShownPressed = model.isArmed() && model.isPressed() || model.isSelected();
        if (this.paintBuffer == null || c != this.bufferedComponent || this.bufferIsPressed != isShownPressed) {
            BufferedImage rightImg;
            BufferedImage middleImg;
            BufferedImage leftImg;
            this.paintBuffer = ((Graphics2D)g).getDeviceConfiguration().createCompatibleImage(c.getWidth(), c.getHeight(), 3);
            this.bufferedComponent = c;
            this.bufferIsPressed = isShownPressed;
            int indentWidth = 10;
            if (isShownPressed) {
                int imgWidth = buttonPressedBG.getWidth();
                int imgHeight = buttonPressedBG.getHeight();
                leftImg = buttonPressedBG.getSubimage(0, 0, 10, imgHeight);
                middleImg = buttonPressedBG.getSubimage(10, 0, imgWidth - 20, imgHeight);
                rightImg = buttonPressedBG.getSubimage(imgWidth - 10, 0, 10, imgHeight);
            } else {
                int imgWidth = buttonBG.getWidth();
                int imgHeight = buttonBG.getHeight();
                leftImg = buttonBG.getSubimage(0, 0, 10, imgHeight);
                middleImg = buttonBG.getSubimage(10, 0, imgWidth - 20, imgHeight);
                rightImg = buttonBG.getSubimage(imgWidth - 10, 0, 10, imgHeight);
            }
            Graphics2D g2 = this.paintBuffer.createGraphics();
            AntialiasingManager.activateAntialiasing((Graphics)g2);
            g2.drawImage(leftImg, 0, 0, indentWidth, c.getHeight(), null);
            g2.drawImage(middleImg, indentWidth, 0, c.getWidth() - 2 * indentWidth, c.getHeight(), null);
            g2.drawImage(rightImg, c.getWidth() - indentWidth, 0, indentWidth, c.getHeight(), null);
        }
        AntialiasingManager.activateAntialiasing((Graphics)g);
        g.drawImage(this.paintBuffer, 0, 0, c.getWidth(), c.getHeight(), 0, 0, c.getWidth(), c.getHeight(), null);
        super.paint(g, c);
    }

    public void loadSkin() {
        buttonBG = ImageLoader.getImage(ImageLoader.BUTTON);
        buttonPressedBG = ImageLoader.getImage(ImageLoader.TOGGLE_BUTTON_PRESSED);
    }
}

