/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.shutdowntimeout;

import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.launchutils.DeleteOnHaltHook;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ShutdownTimeout
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(ShutdownTimeout.class);
    private static final String SHUTDOWN_TIMEOUT_PNAME = "org.jitsi.shutdown.SHUTDOWN_TIMEOUT";
    private static final long SHUTDOWN_TIMEOUT_DEFAULT = 5000L;
    private static final int SYSTEM_EXIT_CODE = 500;

    private static void runInShutdownTimeoutThread() {
        long shutdownTimeout = 5000L;
        try {
            long l;
            String s = System.getProperty(SHUTDOWN_TIMEOUT_PNAME);
            if (s != null && s.length() > 0 && (l = Long.valueOf(s).longValue()) > 0L) {
                shutdownTimeout = l;
            }
        }
        catch (Throwable s) {
            // empty catch block
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Starting shutdown countdown of " + shutdownTimeout + "ms."));
        }
        try {
            Thread.sleep(shutdownTimeout);
        }
        catch (InterruptedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Interrupted shutdown timer.");
            }
            return;
        }
        try {
            DeleteOnHaltHook.runHooks();
        }
        catch (Throwable t) {
            logger.warn((Object)"Failed to delete files on halt.", t);
        }
        logger.error((Object)"Failed to gently shutdown. Forcing exit.");
        Runtime.getRuntime().halt(500);
    }

    public void start(BundleContext context) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting the ShutdownTimeout service.");
        }
    }

    public void stop(BundleContext context) throws Exception {
        Thread shutdownTimeoutThread = new Thread(){

            @Override
            public void run() {
                ShutdownTimeout.runInShutdownTimeoutThread();
            }
        };
        shutdownTimeoutThread.setDaemon(true);
        shutdownTimeoutThread.setName(ShutdownTimeout.class.getName());
        shutdownTimeoutThread.start();
    }
}

