/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.globalshortcut;

import java.awt.AWTKeyStroke;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.globalshortcut.GlobalShortcutActivator;
import net.java.sip.communicator.service.globalshortcut.GlobalShortcutEvent;
import net.java.sip.communicator.service.globalshortcut.GlobalShortcutListener;
import net.java.sip.communicator.service.keybindings.GlobalKeybindingSet;
import net.java.sip.communicator.service.keybindings.KeybindingsService;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallListener;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.util.Logger;

public class CallShortcut
implements GlobalShortcutListener,
CallListener {
    private static final Logger logger = Logger.getLogger(CallShortcut.class);
    private final KeybindingsService keybindingsService = GlobalShortcutActivator.getKeybindingsService();
    private final List<Call> incomingCalls = new ArrayList<Call>();
    private final List<Call> answeredCalls = new ArrayList<Call>();
    private boolean mute = true;
    private boolean ptt_pressed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shortcutReceived(GlobalShortcutEvent evt) {
        AWTKeyStroke keystroke = evt.getKeyStroke();
        GlobalKeybindingSet set = this.keybindingsService.getGlobalBindings();
        for (Map.Entry entry : set.getBindings().entrySet()) {
            for (AWTKeyStroke ks : (List)entry.getValue()) {
                if (ks == null) continue;
                String entryKey = (String)entry.getKey();
                if (entryKey.equals("answer") && keystroke.getKeyCode() == ks.getKeyCode() && keystroke.getModifiers() == ks.getModifiers()) {
                    this.manageNextIncomingCall(CallAction.ANSWER);
                    continue;
                }
                if (entryKey.equals("hangup") && keystroke.getKeyCode() == ks.getKeyCode() && keystroke.getModifiers() == ks.getModifiers()) {
                    if (this.manageNextIncomingCall(CallAction.HANGUP) || this.closeAnsweredCalls(true)) continue;
                    this.closeAnsweredCalls(false);
                    continue;
                }
                if (entryKey.equals("answer_hangup") && keystroke.getKeyCode() == ks.getKeyCode() && keystroke.getModifiers() == ks.getModifiers()) {
                    if (this.manageNextIncomingCall(CallAction.ANSWER) || this.closeAnsweredCalls(true)) continue;
                    this.closeAnsweredCalls(false);
                    continue;
                }
                if (entryKey.equals("mute") && keystroke.getKeyCode() == ks.getKeyCode() && keystroke.getModifiers() == ks.getModifiers()) {
                    try {
                        this.handleAllCallsMute(this.mute);
                        this.mute = !this.mute;
                    }
                    catch (Throwable throwable) {
                        this.mute = !this.mute;
                        throw throwable;
                    }
                    continue;
                }
                if (!entryKey.equals("push_to_talk") || keystroke.getKeyCode() != ks.getKeyCode() || keystroke.getModifiers() != ks.getModifiers() || evt.isReleased() != this.ptt_pressed) continue;
                try {
                    this.handleAllCallsMute(this.ptt_pressed);
                    this.ptt_pressed = !this.ptt_pressed;
                }
                catch (Throwable throwable) {
                    this.ptt_pressed = !this.ptt_pressed;
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAllCallsMute(boolean mute) {
        List<Call> list = this.incomingCalls;
        synchronized (list) {
            for (Call c : this.incomingCalls) {
                this.handleMute(c, mute);
            }
        }
        list = this.answeredCalls;
        synchronized (list) {
            for (Call c : this.answeredCalls) {
                this.handleMute(c, mute);
            }
        }
    }

    public void incomingCallReceived(CallEvent event) {
        CallShortcut.addCall(event.getSourceCall(), this.incomingCalls);
    }

    public void outgoingCallCreated(CallEvent event) {
        CallShortcut.addCall(event.getSourceCall(), this.answeredCalls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCall(Call call, List<Call> calls) {
        List<Call> list = calls;
        synchronized (list) {
            if (!calls.contains(call)) {
                calls.add(call);
            }
        }
    }

    public void callEnded(CallEvent event) {
        Call sourceCall = event.getSourceCall();
        CallShortcut.removeCall(sourceCall, this.incomingCalls);
        CallShortcut.removeCall(sourceCall, this.answeredCalls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeCall(Call call, List<Call> calls) {
        List<Call> list = calls;
        synchronized (list) {
            if (calls.contains(call)) {
                calls.remove(call);
            }
        }
    }

    private void handleMute(Call call, boolean mute) {
        if (call.getCallState() != CallState.CALL_IN_PROGRESS) {
            return;
        }
        if (((CallPeer)call.getCallPeers().next()).getState() != CallPeerState.CONNECTED) {
            return;
        }
        OperationSetBasicTelephony basicTelephony = (OperationSetBasicTelephony)call.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
        if (basicTelephony != null && mute != ((MediaAwareCall)call).isMute()) {
            basicTelephony.setMute(call, mute);
        }
    }

    private static void doCallAction(final Call call, final CallAction callAction) {
        new Thread(){

            @Override
            public void run() {
                try {
                    for (Call aCall : CallConference.getCalls((Call)call)) {
                        Iterator callPeers = aCall.getCallPeers();
                        OperationSetBasicTelephony basicTelephony = (OperationSetBasicTelephony)aCall.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
                        while (callPeers.hasNext()) {
                            CallPeer callPeer = (CallPeer)callPeers.next();
                            switch (callAction) {
                                case ANSWER: {
                                    if (callPeer.getState() != CallPeerState.INCOMING_CALL) break;
                                    basicTelephony.answerCallPeer(callPeer);
                                    break;
                                }
                                case HANGUP: {
                                    basicTelephony.hangupCallPeer(callPeer);
                                }
                            }
                        }
                    }
                }
                catch (OperationFailedException ofe) {
                    logger.error((Object)"Failed to answer/hangup call via global shortcut", (Throwable)ofe);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean manageNextIncomingCall(CallAction callAction) {
        List<Call> list = this.incomingCalls;
        synchronized (list) {
            int i = this.incomingCalls.size();
            while (i != 0) {
                Call call = this.incomingCalls.get(--i);
                this.answeredCalls.add(call);
                this.incomingCalls.remove(i);
                if (call.getCallState() != CallState.CALL_INITIALIZATION) continue;
                CallShortcut.doCallAction(call, callAction);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeAnsweredCalls(boolean closeOnlyActiveCalls) {
        boolean isAtLeastOneCallClosed = false;
        List<Call> list = this.answeredCalls;
        synchronized (list) {
            int i = this.answeredCalls.size();
            while (i != 0) {
                Call call = this.answeredCalls.get(--i);
                if (closeOnlyActiveCalls && !CallShortcut.isActiveCall(call)) continue;
                CallShortcut.doCallAction(call, CallAction.HANGUP);
                this.answeredCalls.remove(i);
                isAtLeastOneCallClosed = true;
            }
        }
        return isAtLeastOneCallClosed;
    }

    private static boolean isActiveCall(Call call) {
        for (Call conferenceCall : CallConference.getCalls((Call)call)) {
            if (!CallShortcut.isAtLeastOneActiveCallPeer(conferenceCall.getCallPeers())) continue;
            return true;
        }
        return false;
    }

    private static boolean isAtLeastOneActiveCallPeer(Iterator<? extends CallPeer> callPeers) {
        while (callPeers.hasNext()) {
            CallPeer callPeer = callPeers.next();
            if (CallPeerState.isOnHold((CallPeerState)callPeer.getState())) continue;
            return true;
        }
        return false;
    }

    private static enum CallAction {
        ANSWER,
        HANGUP;

    }
}

