/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import javajs.util.PT;

public class ScriptTokenizer {
    private String str;
    private int pt = -1;
    private int len;
    private boolean isCmd;
    private boolean doCheck = true;

    public ScriptTokenizer(String str, boolean isCmd) {
        this.str = str;
        this.len = str.length();
        this.isCmd = isCmd;
    }

    static String nextStringToken(ScriptTokenizer eachParam, boolean removeQuotes) {
        String s = eachParam.nextToken();
        return removeQuotes && s.charAt(0) == '\"' && s.endsWith("\"") && s.length() > 1 ? PT.trimQuotes((String)s) : s;
    }

    public String nextToken() {
        boolean inQuote;
        if (this.doCheck) {
            this.hasMoreTokens();
        }
        int pt0 = this.pt;
        boolean bl = inQuote = this.str.charAt(this.pt) == '\"';
        block5: while (++this.pt < this.len) {
            switch (this.str.charAt(this.pt)) {
                case '\"': {
                    if (inQuote) {
                        if (this.isCmd) {
                            inQuote = false;
                            continue block5;
                        }
                        ++this.pt;
                        break block5;
                    }
                    if (!this.isCmd) continue block5;
                    inQuote = true;
                    continue block5;
                }
                case ' ': {
                    if (this.isCmd || inQuote) continue block5;
                    break block5;
                }
                case '\n': 
                case ';': {
                    if (!this.isCmd || inQuote) continue block5;
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
        }
        this.doCheck = true;
        return this.str.substring(pt0, this.pt);
    }

    public boolean hasMoreTokens() {
        block3: while (++this.pt < this.len) {
            switch (this.str.charAt(this.pt)) {
                case '\n': 
                case ' ': 
                case ';': {
                    continue block3;
                }
            }
        }
        this.doCheck = false;
        return this.pt < this.len;
    }

    public String getRemainingScript() {
        return this.str.substring(this.pt);
    }
}

