/*
 * Decompiled with CFR 0.152.
 */
package jspecview.tree;

import javajs.util.Lst;
import jspecview.api.JSVPanel;
import jspecview.api.JSVTree;
import jspecview.api.JSVTreeNode;
import jspecview.api.JSVTreePath;
import jspecview.api.ScriptInterface;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelNode;
import jspecview.source.JDXSource;
import jspecview.tree.SimpleTreeModel;
import jspecview.tree.SimpleTreeNode;
import jspecview.tree.SimpleTreePath;

public class SimpleTree
implements JSVTree {
    protected ScriptInterface si;
    private JSVTreeNode rootNode;
    private SimpleTreeModel spectraTreeModel;
    protected JSViewer vwr;
    private SimpleTreePath selectedPath;

    @Override
    public JSVTreeNode getRootNode() {
        return this.rootNode;
    }

    public SimpleTree(JSViewer viewer) {
        this.vwr = viewer;
        this.rootNode = new SimpleTreeNode("Spectra", null);
        this.spectraTreeModel = new SimpleTreeModel(this.rootNode);
    }

    public void valueChanged() {
        this.vwr.selectedTreeNode(this.getLastSelectedPathComponent());
    }

    private JSVTreeNode getLastSelectedPathComponent() {
        return (JSVTreeNode)(this.selectedPath == null ? null : this.selectedPath.getLastPathComponent());
    }

    @Override
    public void setSelectedPanel(ScriptInterface si, JSVPanel jsvp) {
        if (jsvp != null) {
            JSVTreeNode treeNode = PanelNode.findNode((JSVPanel)jsvp, this.vwr.panelNodes).treeNode;
            this.setSelectionPath(this.vwr.spectraTree.newTreePath(treeNode.getPath()));
        }
    }

    private void setSelectionPath(JSVTreePath newTreePath) {
        this.selectedPath = (SimpleTreePath)newTreePath;
        this.valueChanged();
    }

    @Override
    public JSVTreeNode createTree(int fileCount, JDXSource source, JSVPanel[] panels) {
        SimpleTree tree = (SimpleTree)this.vwr.spectraTree;
        JSVTreeNode rootNode = tree.getRootNode();
        Lst<PanelNode> panelNodes = this.vwr.panelNodes;
        String fileName = JSVFileManager.getTagName(source.getFilePath());
        PanelNode panelNode = new PanelNode(null, fileName, source, null);
        SimpleTreeNode fileNode = new SimpleTreeNode(fileName, panelNode);
        panelNode.setTreeNode(fileNode);
        tree.spectraTreeModel.insertNodeInto(fileNode, rootNode, rootNode.getChildCount());
        for (int i = 0; i < panels.length; ++i) {
            JSVPanel jsvp = panels[i];
            String id = fileCount + "." + (i + 1);
            panelNode = new PanelNode(id, fileName, source, jsvp);
            SimpleTreeNode treeNode = new SimpleTreeNode(panelNode.toString(), panelNode);
            panelNode.setTreeNode(treeNode);
            panelNodes.addLast((Object)panelNode);
            tree.spectraTreeModel.insertNodeInto(treeNode, fileNode, fileNode.getChildCount());
        }
        this.vwr.selectFrameNode(panels[0]);
        return fileNode;
    }

    @Override
    public void setPath(JSVTreePath path) {
        this.setSelectionPath(path);
    }

    @Override
    public JSVTreePath newTreePath(Object[] path) {
        return new SimpleTreePath(path);
    }

    @Override
    public void deleteNodes(Lst<JSVTreeNode> toDelete) {
        for (int i = 0; i < toDelete.size(); ++i) {
            this.spectraTreeModel.removeNodeFromParent((JSVTreeNode)toDelete.get(i));
        }
    }
}

