/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.doublealgo;

import cern.colt.Timer;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.ObjectFactory2D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.doublealgo.Statistic;
import cern.colt.matrix.impl.AbstractFormatter;
import cern.colt.matrix.impl.AbstractMatrix1D;
import cern.colt.matrix.impl.AbstractMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.Former;
import cern.colt.matrix.impl.FormerFactory;
import hep.aida.bin.BinFunction1D;
import hep.aida.bin.BinFunctions1D;

public class Formatter
extends AbstractFormatter {
    public Formatter() {
        this("%G");
    }

    public Formatter(String format) {
        this.setFormat(format);
        this.setAlignment("decimal");
    }

    public static void demo1() {
        int i;
        double[][] values = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] formats = new String[]{"%G", "%1.10G", "%f", "%1.2f", "%0.2e", null};
        int size = formats.length;
        DoubleMatrix2D matrix = DoubleFactory2D.dense.make(values);
        String[] strings = new String[size];
        String[] sourceCodes = new String[size];
        String[] htmlStrings = new String[size];
        String[] htmlSourceCodes = new String[size];
        for (i = 0; i < size; ++i) {
            String format = formats[i];
            strings[i] = new Formatter(format).toString(matrix);
            sourceCodes[i] = new Formatter(format).toSourceCode(matrix);
        }
        System.out.println("original:\n" + new Formatter().toString(matrix));
        for (i = 0; i < size; ++i) {
        }
        for (i = 0; i < size; ++i) {
            System.out.println("\nstring(" + formats[i] + "):\n" + strings[i]);
            System.out.println("\nsourceCode(" + formats[i] + "):\n" + sourceCodes[i]);
        }
    }

    public static void demo2() {
        int i;
        double[] values = new double[]{5.0, 0.0, -0.0, Double.NaN, Double.NaN, Double.NaN, Double.MIN_VALUE, Double.MAX_VALUE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        String[] formats = new String[]{"%G", "%1.19G"};
        int size = formats.length;
        DenseDoubleMatrix1D matrix = new DenseDoubleMatrix1D(values);
        String[] strings = new String[size];
        for (i = 0; i < size; ++i) {
            String format = formats[i];
            strings[i] = new Formatter(format).toString(matrix);
            for (int j = 0; j < matrix.size(); ++j) {
                System.out.println(String.valueOf(matrix.get(j)));
            }
        }
        System.out.println("original:\n" + new Formatter().toString(matrix));
        for (i = 0; i < size; ++i) {
            System.out.println("\nstring(" + formats[i] + "):\n" + strings[i]);
        }
    }

    public static void demo3(int size, double value) {
        Timer timer = new Timer();
        DoubleMatrix2D matrix = DoubleFactory2D.dense.make(size, size, value);
        timer.reset().start();
        StringBuffer buf = new StringBuffer();
        int i = size;
        while (--i >= 0) {
            int j = size;
            while (--j >= 0) {
                buf.append(matrix.getQuick(i, j));
            }
        }
        buf = null;
        timer.stop().display();
        timer.reset().start();
        Former format = new FormerFactory().create("%G");
        buf = new StringBuffer();
        int i2 = size;
        while (--i2 >= 0) {
            int j = size;
            while (--j >= 0) {
                buf.append(format.form(matrix.getQuick(i2, j)));
            }
        }
        buf = null;
        timer.stop().display();
        timer.reset().start();
        String s = new Formatter(null).toString(matrix);
        s = null;
        timer.stop().display();
        timer.reset().start();
        s = new Formatter("%G").toString(matrix);
        s = null;
        timer.stop().display();
    }

    public static void demo4() {
        double[][] values = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] columnNames = new String[]{"0.1", "0.3", "0.5", "0.7"};
        String[] rowNames = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        DoubleMatrix2D matrix = DoubleFactory2D.dense.make(values);
        System.out.println("\n\n" + new Formatter("%G").toTitleString(matrix, rowNames, columnNames, "rowAxis", "colAxis", "VM Performance: Provider vs. matrix density"));
    }

    public static void demo5() {
        double[][] values = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] columnNames = new String[]{"0.1", "0.3", "0.5", "0.7"};
        String[] rowNames = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        System.out.println(DoubleFactory2D.dense.make(values));
        System.out.println(new Formatter("%G").toTitleString(DoubleFactory2D.dense.make(values), rowNames, columnNames, "vendor", "density", "title"));
    }

    public static void demo6() {
        double[][] values = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] columnNames = new String[]{"W", "X", "Y", "Z"};
        String[] rowNames = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        System.out.println(new Formatter().toString(DoubleFactory2D.dense.make(values)));
        System.out.println(new Formatter().toTitleString(DoubleFactory2D.dense.make(values), rowNames, columnNames, "vendor", "density", "title"));
    }

    public static void demo7() {
        double[][] values = new double[][]{{5.0, 10.0, 20.0, 40.0}, {7.0, 8.0, 6.0, 7.0}, {12.0, 10.0, 20.0, 19.0}, {3.0, 1.0, 5.0, 6.0}};
        String[] columnNames = new String[]{"1996", "1997", "1998", "1999"};
        String[] rowNames = new String[]{"PowerBar", "Benzol", "Mercedes", "Sparcling"};
        String rowAxisName = "CPU";
        String columnAxisName = "Year";
        String title = "CPU performance over time [nops/sec]";
        BinFunctions1D F = BinFunctions1D.functions;
        BinFunction1D[] binFunction1DArray = new BinFunction1D[8];
        binFunction1DArray[0] = BinFunctions1D.mean;
        binFunction1DArray[1] = BinFunctions1D.rms;
        binFunction1DArray[2] = BinFunctions1D.quantile(0.25);
        binFunction1DArray[3] = BinFunctions1D.median;
        binFunction1DArray[4] = BinFunctions1D.quantile(0.75);
        binFunction1DArray[5] = BinFunctions1D.stdDev;
        binFunction1DArray[6] = BinFunctions1D.min;
        binFunction1DArray[7] = BinFunctions1D.max;
        BinFunction1D[] aggr = binFunction1DArray;
        String format = "%1.2G";
        System.out.println(new Formatter(format).toTitleString(DoubleFactory2D.dense.make(values), rowNames, columnNames, rowAxisName, columnAxisName, title, aggr));
    }

    protected String form(DoubleMatrix1D matrix, int index, Former formatter) {
        return formatter.form(matrix.get(index));
    }

    @Override
    protected String form(AbstractMatrix1D matrix, int index, Former formatter) {
        return this.form((DoubleMatrix1D)matrix, index, formatter);
    }

    public String[][] format(DoubleMatrix2D matrix) {
        String[][] strings = new String[matrix.rows()][matrix.columns()];
        int row = matrix.rows();
        while (--row >= 0) {
            strings[row] = this.formatRow(matrix.viewRow(row));
        }
        return strings;
    }

    @Override
    protected String[][] format(AbstractMatrix2D matrix) {
        return this.format((DoubleMatrix2D)matrix);
    }

    protected int indexOfDecimalPoint(String s) {
        int i = s.lastIndexOf(46);
        if (i < 0) {
            i = s.lastIndexOf(101);
        }
        if (i < 0) {
            i = s.lastIndexOf(69);
        }
        if (i < 0) {
            i = s.length();
        }
        return i;
    }

    @Override
    protected int lead(String s) {
        if (this.alignment.equals("decimal")) {
            return this.indexOfDecimalPoint(s);
        }
        return super.lead(s);
    }

    public String toSourceCode(DoubleMatrix1D matrix) {
        Formatter copy = (Formatter)this.clone();
        copy.setPrintShape(false);
        copy.setColumnSeparator(", ");
        String lead = "{";
        String trail = "};";
        return lead + copy.toString(matrix) + trail;
    }

    public String toSourceCode(DoubleMatrix2D matrix) {
        Formatter copy = (Formatter)this.clone();
        String b3 = this.blanks(3);
        copy.setPrintShape(false);
        copy.setColumnSeparator(", ");
        copy.setRowSeparator("},\n" + b3 + "{");
        String lead = "{\n" + b3 + "{";
        String trail = "}\n};";
        return lead + copy.toString(matrix) + trail;
    }

    public String toSourceCode(DoubleMatrix3D matrix) {
        Formatter copy = (Formatter)this.clone();
        String b3 = this.blanks(3);
        String b6 = this.blanks(6);
        copy.setPrintShape(false);
        copy.setColumnSeparator(", ");
        copy.setRowSeparator("},\n" + b6 + "{");
        copy.setSliceSeparator("}\n" + b3 + "},\n" + b3 + "{\n" + b6 + "{");
        String lead = "{\n" + b3 + "{\n" + b6 + "{";
        String trail = "}\n" + b3 + "}\n}";
        return lead + copy.toString(matrix) + trail;
    }

    public String toString(DoubleMatrix1D matrix) {
        DoubleMatrix2D easy = matrix.like2D(1, matrix.size());
        easy.viewRow(0).assign(matrix);
        return this.toString(easy);
    }

    public String toString(DoubleMatrix2D matrix) {
        return super.toString(matrix);
    }

    public String toString(DoubleMatrix3D matrix) {
        StringBuffer buf = new StringBuffer();
        boolean oldPrintShape = this.printShape;
        this.printShape = false;
        for (int slice = 0; slice < matrix.slices(); ++slice) {
            if (slice != 0) {
                buf.append(this.sliceSeparator);
            }
            buf.append(this.toString(matrix.viewSlice(slice)));
        }
        this.printShape = oldPrintShape;
        if (this.printShape) {
            buf.insert(0, Formatter.shape(matrix) + "\n");
        }
        return buf.toString();
    }

    @Override
    protected String toString(AbstractMatrix2D matrix) {
        return this.toString((DoubleMatrix2D)matrix);
    }

    protected String toTitleString(DoubleMatrix2D matrix, String[] rowNames, String[] columnNames, String rowAxisName, String columnAxisName, String title) {
        if (matrix.size() == 0) {
            return "Empty matrix";
        }
        Object[][] s = this.format(matrix);
        this.align((String[][])s);
        return new cern.colt.matrix.objectalgo.Formatter().toTitleString(ObjectFactory2D.dense.make(s), rowNames, columnNames, rowAxisName, columnAxisName, title);
    }

    public String toTitleString(DoubleMatrix2D matrix, String[] rowNames, String[] columnNames, String rowAxisName, String columnAxisName, String title, BinFunction1D[] aggr) {
        int last;
        int i;
        ObjectArrayList list;
        if (matrix.size() == 0) {
            return "Empty matrix";
        }
        if (aggr == null || aggr.length == 0) {
            return this.toTitleString(matrix, rowNames, columnNames, rowAxisName, columnAxisName, title);
        }
        DoubleMatrix2D rowStats = matrix.like(matrix.rows(), aggr.length);
        DoubleMatrix2D colStats = matrix.like(aggr.length, matrix.columns());
        Statistic.aggregate(matrix, aggr, colStats);
        Statistic.aggregate(matrix.viewDice(), aggr, rowStats.viewDice());
        DoubleMatrix2D tmp = matrix.like(matrix.rows() + aggr.length, matrix.columns());
        tmp.viewPart(0, 0, matrix.rows(), matrix.columns()).assign(matrix);
        tmp.viewPart(matrix.rows(), 0, aggr.length, matrix.columns()).assign(colStats);
        colStats = null;
        Object[][] s1 = this.format(tmp);
        this.align((String[][])s1);
        tmp = null;
        Object[][] s2 = this.format(rowStats);
        this.align((String[][])s2);
        rowStats = null;
        ObjectMatrix2D allStats = ObjectFactory2D.dense.make(matrix.rows() + aggr.length, matrix.columns() + aggr.length + 1);
        allStats.viewPart(0, 0, matrix.rows() + aggr.length, matrix.columns()).assign(s1);
        allStats.viewColumn(matrix.columns()).assign("|");
        allStats.viewPart(0, matrix.columns() + 1, matrix.rows(), aggr.length).assign(s2);
        s1 = null;
        s2 = null;
        if (columnNames != null) {
            list = new ObjectArrayList(columnNames);
            list.add("|");
            for (i = 0; i < aggr.length; ++i) {
                list.add(aggr[i].name());
            }
            columnNames = new String[list.size()];
            list.toArray(columnNames);
        }
        if (rowNames != null) {
            list = new ObjectArrayList(rowNames);
            for (i = 0; i < aggr.length; ++i) {
                list.add(aggr[i].name());
            }
            rowNames = new String[list.size()];
            list.toArray(rowNames);
        }
        String s = new cern.colt.matrix.objectalgo.Formatter().toTitleString(allStats, rowNames, columnNames, rowAxisName, columnAxisName, title);
        int secondLast = last = s.length() + 1;
        int v = Math.max(0, rowAxisName == null ? 0 : rowAxisName.length() - matrix.rows() - aggr.length);
        for (int k = 0; k < aggr.length + 1 + v; ++k) {
            secondLast = last;
            last = s.lastIndexOf(this.rowSeparator, last - 1);
        }
        StringBuffer buf = new StringBuffer(s);
        buf.insert(secondLast, this.rowSeparator + this.repeat('-', secondLast - last - 1));
        return buf.toString();
    }

    public String toTitleString(DoubleMatrix3D matrix, String[] sliceNames, String[] rowNames, String[] columnNames, String sliceAxisName, String rowAxisName, String columnAxisName, String title, BinFunction1D[] aggr) {
        if (matrix.size() == 0) {
            return "Empty matrix";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < matrix.slices(); ++i) {
            if (i != 0) {
                buf.append(this.sliceSeparator);
            }
            buf.append(this.toTitleString(matrix.viewSlice(i), rowNames, columnNames, rowAxisName, columnAxisName, title + "\n" + sliceAxisName + "=" + sliceNames[i], aggr));
        }
        return buf.toString();
    }

    private String xtoTitleString(DoubleMatrix3D matrix, String[] sliceNames, String[] rowNames, String[] columnNames, String sliceAxisName, String rowAxisName, String columnAxisName, String title) {
        if (matrix.size() == 0) {
            return "Empty matrix";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < matrix.slices(); ++i) {
            if (i != 0) {
                buf.append(this.sliceSeparator);
            }
            buf.append(this.toTitleString(matrix.viewSlice(i), rowNames, columnNames, rowAxisName, columnAxisName, title + "\n" + sliceAxisName + "=" + sliceNames[i]));
        }
        return buf.toString();
    }
}

