/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import edu.uci.ics.jung.algorithms.scoring.VertexScorer;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraDistance;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.shortestpath.UnweightedShortestPath;
import edu.uci.ics.jung.graph.Hypergraph;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.Transformer;

public class DistanceCentralityScorer<V, E>
implements VertexScorer<V, Double> {
    protected Hypergraph<V, E> graph;
    protected Distance<V> distance;
    protected Map<V, Double> output;
    protected boolean averaging;
    protected boolean ignore_missing;
    protected boolean ignore_self_distances;

    public DistanceCentralityScorer(Hypergraph<V, E> graph, Distance<V> distance, boolean averaging, boolean ignore_missing, boolean ignore_self_distances) {
        this.graph = graph;
        this.distance = distance;
        this.averaging = averaging;
        this.ignore_missing = ignore_missing;
        this.ignore_self_distances = ignore_self_distances;
        this.output = new HashMap<V, Double>();
    }

    public DistanceCentralityScorer(Hypergraph<V, E> graph, Distance<V> distance, boolean averaging) {
        this(graph, distance, averaging, true, true);
    }

    public DistanceCentralityScorer(Hypergraph<V, E> graph, Transformer<E, ? extends Number> edge_weights, boolean averaging, boolean ignore_missing, boolean ignore_self_distances) {
        this(graph, new DijkstraDistance<V, E>(graph, edge_weights), averaging, ignore_missing, ignore_self_distances);
    }

    public DistanceCentralityScorer(Hypergraph<V, E> graph, Transformer<E, ? extends Number> edge_weights, boolean averaging) {
        this(graph, new DijkstraDistance<V, E>(graph, edge_weights), averaging, true, true);
    }

    public DistanceCentralityScorer(Hypergraph<V, E> graph, boolean averaging, boolean ignore_missing, boolean ignore_self_distances) {
        this(graph, new UnweightedShortestPath<V, E>(graph), averaging, ignore_missing, ignore_self_distances);
    }

    public DistanceCentralityScorer(Hypergraph<V, E> graph, boolean averaging) {
        this(graph, new UnweightedShortestPath<V, E>(graph), averaging, true, true);
    }

    @Override
    public Double getVertexScore(V v) {
        Double value = this.output.get(v);
        if (value != null) {
            if (value < 0.0) {
                return null;
            }
            return value;
        }
        HashMap<V, Number> v_distances = new HashMap<V, Number>(this.distance.getDistanceMap(v));
        if (this.ignore_self_distances) {
            v_distances.remove(v);
        }
        if (!this.ignore_missing) {
            int num_dests = this.graph.getVertexCount() - (this.ignore_self_distances ? 1 : 0);
            if (v_distances.size() != num_dests) {
                this.output.put((Double)v, -1.0);
                return null;
            }
        }
        Double sum = 0.0;
        for (V w : this.graph.getVertices()) {
            if (w.equals(v) && this.ignore_self_distances) continue;
            Number w_distance = (Number)v_distances.get(w);
            if (w_distance == null) {
                if (this.ignore_missing) continue;
                this.output.put((Double)v, -1.0);
                return null;
            }
            sum = sum + w_distance.doubleValue();
        }
        value = sum;
        if (this.averaging) {
            value = value / (double)v_distances.size();
        }
        double score = value == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / value;
        this.output.put((Double)v, score);
        return score;
    }
}

