/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import edu.uci.ics.jung.algorithms.scoring.AbstractIterativeScorerWithPriors;
import edu.uci.ics.jung.algorithms.scoring.HITS;
import edu.uci.ics.jung.graph.Hypergraph;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class HITSWithPriors<V, E>
extends AbstractIterativeScorerWithPriors<V, E, HITS.Scores> {
    protected HITS.Scores disappearing_potential = new HITS.Scores(0.0, 0.0);

    public HITSWithPriors(Hypergraph<V, E> g, Transformer<E, ? extends Number> edge_weights, Transformer<V, HITS.Scores> vertex_priors, double alpha) {
        super(g, edge_weights, vertex_priors, alpha);
    }

    public HITSWithPriors(Hypergraph<V, E> g, Transformer<V, HITS.Scores> vertex_priors, double alpha) {
        super(g, new ConstantTransformer<Double>(1.0), vertex_priors, alpha);
    }

    @Override
    protected double update(V v) {
        this.collectDisappearingPotential(v);
        double v_auth = 0.0;
        for (Object e : this.graph.getInEdges(v)) {
            int incident_count = this.getAdjustedIncidentCount(e);
            for (Object w : this.graph.getIncidentVertices(e)) {
                if (w.equals(v) && !this.hyperedges_are_self_loops) continue;
                v_auth += ((HITS.Scores)this.getCurrentValue(w)).hub * this.getEdgeWeight(w, e).doubleValue() / (double)incident_count;
            }
        }
        double v_hub = 0.0;
        for (Object e : this.graph.getOutEdges(v)) {
            int incident_count = this.getAdjustedIncidentCount(e);
            for (Object w : this.graph.getIncidentVertices(e)) {
                if (w.equals(v) && !this.hyperedges_are_self_loops) continue;
                v_hub += ((HITS.Scores)this.getCurrentValue(w)).authority * this.getEdgeWeight(w, e).doubleValue() / (double)incident_count;
            }
        }
        if (this.alpha > 0.0) {
            v_auth = v_auth * (1.0 - this.alpha) + ((HITS.Scores)this.getVertexPrior(v)).authority * this.alpha;
            v_hub = v_hub * (1.0 - this.alpha) + ((HITS.Scores)this.getVertexPrior(v)).hub * this.alpha;
        }
        this.setOutputValue(v, new HITS.Scores(v_hub, v_auth));
        return Math.max(Math.abs(((HITS.Scores)this.getCurrentValue(v)).hub - v_hub), Math.abs(((HITS.Scores)this.getCurrentValue(v)).authority - v_auth));
    }

    @Override
    protected void afterStep() {
        if (this.disappearing_potential.hub > 0.0 || this.disappearing_potential.authority > 0.0) {
            for (Object v : this.graph.getVertices()) {
                double new_hub = ((HITS.Scores)this.getOutputValue(v)).hub + (1.0 - this.alpha) * (this.disappearing_potential.hub * ((HITS.Scores)this.getVertexPrior(v)).hub);
                double new_auth = ((HITS.Scores)this.getOutputValue(v)).authority + (1.0 - this.alpha) * (this.disappearing_potential.authority * ((HITS.Scores)this.getVertexPrior(v)).authority);
                this.setOutputValue(v, new HITS.Scores(new_hub, new_auth));
            }
            this.disappearing_potential.hub = 0.0;
            this.disappearing_potential.authority = 0.0;
        }
        this.normalizeScores();
        super.afterStep();
    }

    protected void normalizeScores() {
        double hub_ssum = 0.0;
        double auth_ssum = 0.0;
        for (Object v : this.graph.getVertices()) {
            double hub_val = ((HITS.Scores)this.getOutputValue(v)).hub;
            double auth_val = ((HITS.Scores)this.getOutputValue(v)).authority;
            hub_ssum += hub_val * hub_val;
            auth_ssum += auth_val * auth_val;
        }
        hub_ssum = Math.sqrt(hub_ssum);
        auth_ssum = Math.sqrt(auth_ssum);
        for (Object v : this.graph.getVertices()) {
            HITS.Scores values = (HITS.Scores)this.getOutputValue(v);
            this.setOutputValue(v, new HITS.Scores(values.hub / hub_ssum, values.authority / auth_ssum));
        }
    }

    @Override
    protected void collectDisappearingPotential(V v) {
        if (this.graph.outDegree(v) == 0) {
            if (this.isDisconnectedGraphOK()) {
                this.disappearing_potential.hub += ((HITS.Scores)this.getCurrentValue(v)).authority;
            } else {
                throw new IllegalArgumentException("Outdegree of " + v + " must be > 0");
            }
        }
        if (this.graph.inDegree(v) == 0) {
            if (this.isDisconnectedGraphOK()) {
                this.disappearing_potential.authority += ((HITS.Scores)this.getCurrentValue(v)).hub;
            } else {
                throw new IllegalArgumentException("Indegree of " + v + " must be > 0");
            }
        }
    }
}

