/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.util;

import org.apache.commons.collections15.Transformer;

public class LabelWrapper
implements Transformer<String, String> {
    int lineLength;
    public static final String breaker = "<p>";

    public LabelWrapper() {
        this(10);
    }

    public LabelWrapper(int lineLength) {
        this.lineLength = lineLength;
    }

    @Override
    public String transform(String str) {
        if (str != null) {
            return this.wrap(str);
        }
        return null;
    }

    private String wrap(String str) {
        StringBuilder buf = new StringBuilder(str);
        int len = this.lineLength;
        while (len < buf.length()) {
            int idx = buf.lastIndexOf(" ", len);
            if (idx != -1) {
                buf.replace(idx, idx + 1, breaker);
                len = idx + breaker.length() + this.lineLength;
                continue;
            }
            buf.insert(len, breaker);
            len += breaker.length() + this.lineLength;
        }
        buf.insert(0, "<html>");
        return buf.toString();
    }

    public static void main(String[] args) {
        String[] lines = new String[]{"This is a line with many short words that I will break into shorter lines.", "thisisalinewithnobreakssowhoknowswhereitwillwrap", "short line"};
        LabelWrapper w = new LabelWrapper(10);
        for (int i = 0; i < lines.length; ++i) {
            System.err.println("from " + lines[i] + " to " + w.wrap(lines[i]));
        }
    }
}

