/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization3d;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization3d.RenderContext;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class PluggableRenderContext<V, E>
implements RenderContext<V, E> {
    protected Transformer<E, Appearance> edgeAppearanceTransformer;
    protected Transformer<Context<Graph<V, E>, E>, Node> edgeShapeTransformer;
    protected PickedState<E> pickedEdgeState;
    protected PickedState<V> pickedVertexState;
    protected Transformer<V, Appearance> vertexAppearanceTransformer;
    protected Transformer<V, String> vertexStringer = new ConstantTransformer<Object>(null);
    protected Transformer<V, Node> vertexShapeTransformer;

    public PluggableRenderContext() {
        Color3f lightGray = new Color3f(0.7f, 0.7f, 0.7f);
        Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f gray = new Color3f(0.2f, 0.2f, 0.2f);
        Color3f red = new Color3f(1.0f, 0.0f, 0.0f);
        Color3f yellow = new Color3f(0.0f, 1.0f, 1.0f);
        Material lightGrayMaterial = new Material(lightGray, black, lightGray, white, 100.0f);
        Material blackMaterial = new Material(lightGray, black, black, lightGray, 10.0f);
        Material whiteMaterial = new Material(white, white, white, white, 100.0f);
        Material grayMaterial = new Material(gray, black, gray, gray, 100.0f);
        Material redMaterial = new Material(red, black, red, red, 100.0f);
        Material yellowMaterial = new Material(yellow, black, yellow, yellow, 100.0f);
        Appearance lightGrayLook = new Appearance();
        lightGrayLook.setMaterial(lightGrayMaterial);
        Appearance blackLook = new Appearance();
        blackLook.setMaterial(blackMaterial);
        Appearance whiteLook = new Appearance();
        whiteLook.setMaterial(whiteMaterial);
        Appearance grayLook = new Appearance();
        grayLook.setMaterial(grayMaterial);
        final Appearance redLook = new Appearance();
        redLook.setMaterial(redMaterial);
        Appearance yellowLook = new Appearance();
        yellowLook.setMaterial(yellowMaterial);
        Cylinder cylinder = new Cylinder(1.0f, 1.0f, 33, 26, 26, lightGrayLook);
        Sphere sphere = new Sphere(10.0f, 33, redLook);
        Box box = new Box(10.0f, 10.0f, 10.0f, 33, redLook);
        this.edgeAppearanceTransformer = new ConstantTransformer<Appearance>(lightGrayLook);
        this.edgeShapeTransformer = new Transformer<Context<Graph<V, E>, E>, Node>(){

            @Override
            public Node transform(Context<Graph<V, E>, E> ec) {
                LineArray lineArray = new LineArray(2, 5);
                lineArray.setCoordinates(0, new Point3f[]{new Point3f(0.0f, -0.5f, 0.0f), new Point3f(0.0f, 0.5f, 0.0f)});
                lineArray.setColor(0, new Color3f(1.0f, 1.0f, 1.0f));
                lineArray.setColor(1, new Color3f(1.0f, 1.0f, 1.0f));
                Shape3D shape = new Shape3D();
                shape.setGeometry((Geometry)lineArray);
                return shape;
            }
        };
        this.vertexAppearanceTransformer = new ConstantTransformer<Appearance>(redLook);
        this.vertexShapeTransformer = new Transformer<V, Node>(){

            @Override
            public Node transform(V arg0) {
                return new Sphere(10.0f, 97, redLook);
            }
        };
    }

    @Override
    public Transformer<E, Appearance> getEdgeAppearanceTransformer() {
        return this.edgeAppearanceTransformer;
    }

    @Override
    public Transformer<Context<Graph<V, E>, E>, Node> getEdgeShapeTransformer() {
        return this.edgeShapeTransformer;
    }

    @Override
    public PickedState<E> getPickedEdgeState() {
        return this.pickedEdgeState;
    }

    @Override
    public PickedState<V> getPickedVertexState() {
        return this.pickedVertexState;
    }

    @Override
    public Transformer<V, Appearance> getVertexAppearanceTransformer() {
        return this.vertexAppearanceTransformer;
    }

    @Override
    public Transformer<V, Node> getVertexShapeTransformer() {
        return this.vertexShapeTransformer;
    }

    @Override
    public Transformer<V, String> getVertexStringer() {
        return this.vertexStringer;
    }

    @Override
    public void setEdgeAppearanceTransformer(Transformer<E, Appearance> edgeAppearanceTransformer) {
        this.edgeAppearanceTransformer = edgeAppearanceTransformer;
    }

    @Override
    public void setEdgeShapeTransformer(Transformer<Context<Graph<V, E>, E>, Node> edgeShapeTransformer) {
        this.edgeShapeTransformer = edgeShapeTransformer;
    }

    @Override
    public void setPickedEdgeState(PickedState<E> pickedEdgeState) {
        this.pickedEdgeState = pickedEdgeState;
    }

    @Override
    public void setPickedVertexState(PickedState<V> pickedVertexState) {
        this.pickedVertexState = pickedVertexState;
    }

    @Override
    public void setVertexAppearanceTransformer(Transformer<V, Appearance> vertexAppearanceTransformer) {
        this.vertexAppearanceTransformer = vertexAppearanceTransformer;
    }

    @Override
    public void setVertexShapeTransformer(Transformer<V, Node> vertexShapeTransformer) {
        this.vertexShapeTransformer = vertexShapeTransformer;
    }

    @Override
    public void setVertexStringer(Transformer<V, String> vertexStringer) {
        this.vertexStringer = vertexStringer;
    }
}

