/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.util.LinkedHashSet;
import java.util.Set;
import lcmc.data.Cluster;
import lcmc.data.Host;

public final class Hosts {
    private static final long serialVersionUID = 1L;
    private final Set<Host> hosts = new LinkedHashSet<Host>();

    void addHost(Host host) {
        this.hosts.add(host);
    }

    int size() {
        return this.hosts.size();
    }

    void removeHost(Host host) {
        this.hosts.remove(host);
    }

    boolean existsHost(Host host) {
        return this.hosts.contains(host);
    }

    Set<Host> getHostSet() {
        return this.hosts;
    }

    public Host[] getHostsArray() {
        return this.hosts.toArray(new Host[this.hosts.size()]);
    }

    void disconnectAllHosts() {
        for (Host host : this.hosts) {
            host.disconnect();
        }
    }

    public void removeHostsFromCluster(Cluster cluster) {
        for (Host host : this.hosts) {
            if (host.getCluster() != cluster) continue;
            host.setCluster(null);
        }
    }
}

