/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lcmc.utilities.Tools;

public final class PtestData {
    private static final long serialVersionUID = 1L;
    private static final Pattern PTEST_ACTIONS_PATTERN = Pattern.compile(".*LogActions:\\s+(\\S+)\\s*(?:resource)?\\s+(\\S+)\\s+\\(([^)]*)\\).*");
    private static final Pattern PTEST_ERROR_PATTERN = Pattern.compile("(?i).*ERROR: print_elem:\\s+\\[Action.*?: Pending \\(id: (\\S+)_(\\S+)_.*?, loc: ([^,]+).*");
    private static final Pattern PTEST_CLONE_PATTERN = Pattern.compile("(.*):\\d+");
    private final String toolTip;
    private final String shadowCib;
    private final Map<String, List<String>> runningOnNodes = new LinkedHashMap<String, List<String>>();
    private final Map<String, List<String>> slaveOnNodes = new LinkedHashMap<String, List<String>>();
    private final Map<String, List<String>> masterOnNodes = new LinkedHashMap<String, List<String>>();
    private final Map<String, Boolean> managedHash = new LinkedHashMap<String, Boolean>();

    public PtestData(String raw) {
        if (raw == null) {
            this.toolTip = null;
            this.shadowCib = null;
            return;
        }
        StringBuilder sb = new StringBuilder(300);
        sb.append("<html><b>");
        sb.append(Tools.getString("PtestData.ToolTip"));
        sb.append("</b><br>");
        String[] queries = raw.split("--- PTEST END ---");
        if (queries.length != 2) {
            this.shadowCib = null;
            this.toolTip = null;
            return;
        }
        boolean isToolTip = false;
        for (String line : queries[0].split("\\r?\\n")) {
            List<String> masterNodes;
            List<String> slaveNodes;
            List<String> nodes;
            Matcher m = PTEST_ACTIONS_PATTERN.matcher(line);
            Matcher mError = PTEST_ERROR_PATTERN.matcher(line);
            if (m.matches()) {
                String[] parts;
                String action = m.group(1);
                String res = m.group(2);
                boolean clone = false;
                Matcher cm = PTEST_CLONE_PATTERN.matcher(res);
                if (cm.matches()) {
                    res = cm.group(1);
                    clone = true;
                }
                String state = m.group(3);
                nodes = this.runningOnNodes.get(res);
                if (nodes == null) {
                    nodes = new ArrayList<String>();
                }
                slaveNodes = null;
                if (clone && (slaveNodes = this.slaveOnNodes.get(res)) == null) {
                    slaveNodes = new ArrayList<String>();
                }
                masterNodes = null;
                if (clone && (masterNodes = this.masterOnNodes.get(res)) == null) {
                    masterNodes = new ArrayList<String>();
                }
                if ("Start".equals(action)) {
                    nodes.add(state);
                    if (clone) {
                        slaveNodes.add(state);
                    }
                } else if ("Leave".equals(action)) {
                    if (state.indexOf(32) >= 0 && (parts = state.split(" ")).length == 2) {
                        String what = parts[0];
                        String node = parts[1];
                        if ("unmanaged".equals(node)) {
                            this.managedHash.put(res, false);
                            continue;
                        }
                        if ("Started".equals(what)) {
                            nodes.add(node);
                        } else if ("Slave".equals(what)) {
                            nodes.add(node);
                            if (clone) {
                                slaveNodes.add(node);
                            }
                        } else if ("Master".equals(what)) {
                            nodes.add(node);
                            if (clone) {
                                masterNodes.add(node);
                            }
                        }
                    }
                } else if ("Stop".equals(action)) {
                    nodes.remove(state);
                    if (clone) {
                        slaveNodes.remove(state);
                        masterNodes.remove(state);
                    }
                } else if ("Move".equals(action)) {
                    if (state.indexOf(" -> ") >= 0) {
                        parts = state.split(" -> ");
                        nodes.remove(parts[0]);
                        nodes.add(parts[parts.length - 1]);
                    }
                } else if ("Promote".equals(action)) {
                    if (state.indexOf(" -> Master ") >= 0 && (parts = state.split(" -> Master ")).length > 0) {
                        nodes.add(parts[parts.length - 1]);
                        if (clone) {
                            slaveNodes.remove(parts[parts.length - 1]);
                            masterNodes.add(parts[parts.length - 1]);
                        }
                    }
                } else {
                    if (!"Demote".equals(action)) continue;
                    if (state.indexOf(" -> Slave ") >= 0 && (parts = state.split(" -> Slave ")).length > 0 && clone) {
                        masterNodes.remove(parts[parts.length - 1]);
                        slaveNodes.add(parts[parts.length - 1]);
                    }
                }
                this.runningOnNodes.put(res, nodes);
                if (clone) {
                    this.slaveOnNodes.put(res, slaveNodes);
                    this.masterOnNodes.put(res, masterNodes);
                }
                if ("Leave".equals(action)) {
                    continue;
                }
            } else {
                if (!mError.matches()) continue;
                String res = mError.group(1);
                String action = mError.group(2);
                String node = mError.group(3);
                boolean clone = false;
                Matcher cm = PTEST_CLONE_PATTERN.matcher(res);
                if (cm.matches()) {
                    res = cm.group(1);
                    clone = true;
                }
                if ((nodes = this.runningOnNodes.get(res)) == null) {
                    nodes = new ArrayList<String>();
                }
                slaveNodes = null;
                if (clone && (slaveNodes = this.slaveOnNodes.get(res)) == null) {
                    slaveNodes = new ArrayList<String>();
                }
                masterNodes = null;
                if (clone && (masterNodes = this.masterOnNodes.get(res)) == null) {
                    masterNodes = new ArrayList<String>();
                }
                if ("stop".equals(action)) {
                    nodes.add(node);
                    if (clone) {
                        slaveNodes.add(node);
                    }
                } else if ("start".equals(action)) {
                    nodes.remove(node);
                    if (clone) {
                        slaveNodes.remove(node);
                        masterNodes.remove(node);
                    }
                } else if ("promote".equals(action)) {
                    if (clone) {
                        masterNodes.remove(node);
                        slaveNodes.add(node);
                    }
                } else if ("demote".equals(action) && clone) {
                    slaveNodes.remove(node);
                    masterNodes.add(node);
                }
                this.runningOnNodes.put(res, nodes);
                if (clone) {
                    this.slaveOnNodes.put(res, slaveNodes);
                    this.masterOnNodes.put(res, masterNodes);
                }
            }
            String[] prefixes = new String[]{"LogActions: ", "ERROR: print_elem: "};
            if (line.indexOf("_post_notify_") >= 0 || line.indexOf("_pre_notify_") >= 0 || line.indexOf("_monitor_") >= 0) continue;
            for (String prefix : prefixes) {
                int index = line.indexOf(prefix);
                if (index < 0) continue;
                sb.append(line.substring(index + prefix.length()));
                sb.append("<br>");
                isToolTip = true;
            }
        }
        if (!isToolTip) {
            sb.append(Tools.getString("PtestData.NoToolTip"));
        }
        sb.append("</html>");
        this.toolTip = sb.toString();
        this.shadowCib = queries[1];
    }

    public String getToolTip() {
        return this.toolTip;
    }

    String getShadowCib() {
        return this.shadowCib;
    }

    List<String> getRunningOnNodes(String pmId) {
        return this.runningOnNodes.get(pmId);
    }

    List<String> getMasterOnNodes(String pmId) {
        return this.masterOnNodes.get(pmId);
    }

    List<String> getSlaveOnNodes(String pmId) {
        return this.slaveOnNodes.get(pmId);
    }

    boolean isManaged(String pmId) {
        Boolean m = this.managedHash.get(pmId);
        if (m == null) {
            return true;
        }
        return m;
    }
}

