/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import lcmc.Exceptions;
import lcmc.data.Cluster;
import lcmc.data.Clusters;
import lcmc.gui.Browser;
import lcmc.gui.ClusterTab;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

public final class ClustersPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabbedPane;
    private static final ImageIcon CLUSTER_ICON = Tools.createImageIcon(Tools.getDefault("ClustersPanel.ClusterIcon"));
    private static final ImageIcon CLUSTERS_ICON = Tools.createImageIcon(Tools.getDefault("ClustersPanel.ClustersIcon"));
    private static final String CLUSTERS_LABEL = Tools.getString("ClustersPanel.ClustersTab");
    private final ClusterTab newClusterTab;
    private ClusterTab prevSelected = null;
    private static final int TAB_BORDER_WIDTH = 3;
    private String upgradeCheck;
    private final Lock mUpgradeLock = new ReentrantLock();
    private final List<JEditorPane> upgradeTextFields = new ArrayList<JEditorPane>();

    ClustersPanel() {
        super(new GridLayout(1, 1));
        Tools.getGUIData().setClustersPanel(this);
        this.upgradeCheck = Tools.getConfigData().isUpgradeCheckEnabled() ? Tools.getString("MainPanel.UpgradeCheck") : Tools.getString("MainPanel.UpgradeCheckDisabled");
        this.newClusterTab = new ClusterTab(null);
        if (Tools.getConfigData().isUpgradeCheckEnabled()) {
            this.startUpgradeCheck();
        }
        this.setBackground(Tools.getDefaultColor("ClustersPanel.Background"));
        this.showGUI();
    }

    private void showGUI() {
        UIManager.put("TabbedPane.selected", Tools.getDefaultColor("ViewPanel.Status.Background"));
        UIManager.put("TabbedPane.foreground", Color.WHITE);
        UIManager.put("TabbedPane.background", Tools.getDefaultColor("ViewPanel.Background"));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabPlacement(1);
        MyTabbedPaneUI mtpui = new MyTabbedPaneUI();
        this.tabbedPane.setUI(mtpui);
        this.addClustersTab(CLUSTERS_LABEL);
        this.add(this.tabbedPane);
        this.setBorder(BorderFactory.createLineBorder(Tools.getDefaultColor("ClustersPanel.Background"), 3));
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ClusterTab source = ClustersPanel.this.prevSelected;
                JTabbedPane prevSource = (JTabbedPane)evt.getSource();
                ClustersPanel.this.prevSelected = (ClusterTab)prevSource.getSelectedComponent();
                String sourceName = null;
                if (source != null) {
                    sourceName = source.getName();
                }
                if (sourceName == null) {
                    return;
                }
                ClusterTab clusterTab = ClustersPanel.this.getClusterTab();
                if (clusterTab != null) {
                    Cluster cluster = clusterTab.getCluster();
                    int danglingHostsCount = Tools.getConfigData().danglingHostsCount();
                    if (cluster != null) {
                        ClustersPanel.this.refresh();
                    }
                }
            }
        });
    }

    void addTab(final Cluster cluster) {
        Tools.debug(this, "cluster add tab " + cluster.getName(), 2);
        ClusterTab ct = new ClusterTab(cluster);
        cluster.setClusterTab(ct);
        if (this.tabbedPane.getTabCount() == 1) {
            this.removeAllTabs();
        }
        String title = Tools.join(" ", cluster.getHostNames());
        this.tabbedPane.addTab(cluster.getName(), CLUSTER_ICON, ct, title);
        ActionListener disconnectAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Tools.stopCluster(cluster);
                        Tools.getGUIData().getEmptyBrowser().setDisconnected(cluster);
                    }
                });
                t.start();
            }
        };
        this.addTabComponent(this.tabbedPane, cluster.getName(), CLUSTER_ICON, ct, disconnectAction);
        this.tabbedPane.setSelectedComponent(ct);
        this.refresh();
    }

    private void addTabComponent(JTabbedPane tabPane, String title, ImageIcon icon, ClusterTab ct, ActionListener actionListener) {
        int index = tabPane.indexOfComponent(ct);
        JPanel tabPanel = new JPanel(new GridBagLayout());
        tabPanel.setOpaque(false);
        JLabel iconLabel = new JLabel(icon);
        JLabel lblTitle = new JLabel(title);
        MyButton clusterButton = new MyButton("X");
        clusterButton.setBackgroundColor(Browser.STATUS_BACKGROUND);
        clusterButton.setMargin(new Insets(0, 0, 0, 0));
        clusterButton.setIconTextGap(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        tabPanel.add((Component)iconLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        tabPanel.add((Component)lblTitle, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        tabPanel.add((Component)clusterButton, gbc);
        tabPane.setTabComponentAt(index, tabPanel);
        clusterButton.addActionListener(actionListener);
    }

    void addClustersTab(String label) {
        this.tabbedPane.addTab(label, CLUSTERS_ICON, this.newClusterTab, Tools.getString("ClustersPanel.ClustersTabTip"));
    }

    void removeTab() {
        ClusterTab selected = this.getClusterTab();
        selected.getCluster().setClusterTab(null);
        int index = this.tabbedPane.getSelectedIndex() - 1;
        if (index < 1) {
            index = 1;
        }
        if (selected != null) {
            this.tabbedPane.remove(selected);
        }
        if (this.tabbedPane.getTabCount() == 1) {
            this.tabbedPane.removeAll();
            this.addClustersTab(CLUSTERS_LABEL);
        }
    }

    public void removeTab(Cluster cluster) {
        this.tabbedPane.remove(cluster.getClusterTab());
        cluster.setClusterTab(null);
        if (this.tabbedPane.getTabCount() == 1) {
            this.tabbedPane.removeAll();
            this.addClustersTab(CLUSTERS_LABEL);
        }
    }

    public void removeAllTabs() {
        this.tabbedPane.removeAll();
        this.addClustersTab("");
    }

    void renameSelectedTab(String newName) {
        this.tabbedPane.setTitleAt(this.tabbedPane.getSelectedIndex(), newName);
        this.refresh();
    }

    private void addAllTabs() {
        Clusters clusters = Tools.getConfigData().getClusters();
        this.addClustersTab(CLUSTERS_LABEL);
        if (clusters != null) {
            for (Cluster cluster : clusters.getClusterSet()) {
                this.addTab(cluster);
            }
        }
    }

    void refresh() {
        this.tabbedPane.invalidate();
        this.tabbedPane.validate();
        this.tabbedPane.repaint();
    }

    void repaintTabs() {
        this.tabbedPane.removeAll();
        this.addAllTabs();
    }

    ClusterTab getClusterTab() {
        Component sp = this.tabbedPane.getSelectedComponent();
        if (sp == null) {
            return null;
        }
        return (ClusterTab)sp;
    }

    private void startUpgradeCheck() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String latestVersion = Tools.getLatestVersion();
                ClustersPanel.this.mUpgradeLock.lock();
                if (latestVersion == null) {
                    ClustersPanel.this.upgradeCheck = "";
                } else {
                    String release = Tools.getRelease();
                    try {
                        if (Tools.compareVersions(release, latestVersion) < 0) {
                            ClustersPanel.this.upgradeCheck = Tools.getString("MainPanel.UpgradeAvailable").replaceAll("@LATEST@", latestVersion);
                        } else {
                            ClustersPanel.this.upgradeCheck = Tools.getString("MainPanel.NoUpgradeAvailable");
                        }
                    }
                    catch (Exceptions.IllegalVersionException e) {
                        ClustersPanel.this.upgradeCheck = Tools.getString("MainPanel.UpgradeCheckFailed");
                    }
                }
                final String text = ClustersPanel.this.upgradeCheck;
                ClustersPanel.this.mUpgradeLock.unlock();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (JEditorPane field : ClustersPanel.this.upgradeTextFields) {
                            field.setText(text);
                            field.setVisible(!"".equals(text));
                        }
                    }
                });
            }
        });
        thread.start();
    }

    JEditorPane registerUpgradeTextField() {
        JEditorPane upgradeField = new JEditorPane("text/html", "");
        LineBorder border = new LineBorder(Color.RED);
        upgradeField.setBorder(border);
        Tools.setEditorFont(upgradeField);
        upgradeField.setEditable(false);
        upgradeField.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Tools.openBrowser(e.getURL().toString());
                }
            }
        });
        upgradeField.setBackground(Color.WHITE);
        this.mUpgradeLock.lock();
        this.upgradeTextFields.add(upgradeField);
        String text = this.upgradeCheck;
        this.mUpgradeLock.unlock();
        upgradeField.setText(text);
        upgradeField.setVisible(!"".equals(text));
        return upgradeField;
    }

    void unregisterUpgradeTextField(JEditorPane field) {
        this.mUpgradeLock.lock();
        this.upgradeTextFields.remove(field);
        this.mUpgradeLock.unlock();
    }

    static class MyTabbedPaneUI
    extends BasicTabbedPaneUI {
        MyTabbedPaneUI() {
        }

        @Override
        protected final Insets getContentBorderInsets(int tabPlacement) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        }
    }
}

