/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import lcmc.data.Cluster;
import lcmc.data.Host;
import lcmc.gui.Browser;
import lcmc.gui.EmptyViewPanel;
import lcmc.gui.HostBrowser;
import lcmc.gui.resources.AllHostsInfo;
import lcmc.gui.resources.Info;
import lcmc.utilities.Tools;

public final class EmptyBrowser
extends Browser {
    private DefaultMutableTreeNode allHostsNode;
    private EmptyViewPanel emptyViewPanel = null;
    private final AllHostsInfo allHostsInfo = new AllHostsInfo(this);

    EmptyBrowser() {
        String saveFile = Tools.getConfigData().getSaveFile();
        String xml = Tools.loadFile(saveFile, false);
        if (xml == null) {
            String saveFileOld = Tools.getConfigData().getSaveFileOld();
            xml = Tools.loadFile(saveFileOld, false);
        }
        if (xml != null) {
            Tools.loadXML(xml);
        }
        this.setTreeTop();
    }

    public void addClusterBox(Cluster cluster) {
        this.allHostsInfo.addClusterBox(cluster);
        this.allHostsInfo.setConnected(cluster);
        this.allHostsInfo.addCheckboxListener(cluster);
    }

    public void setDisconnected(Cluster cluster) {
        this.allHostsInfo.setDisconnected(cluster);
    }

    void setEmptyViewPanel(EmptyViewPanel emptyViewPanel) {
        this.emptyViewPanel = emptyViewPanel;
    }

    EmptyViewPanel getEmptyViewPanel() {
        return this.emptyViewPanel;
    }

    void setRightComponentInView(Info i) {
        this.emptyViewPanel.setRightComponentInView(this, i);
    }

    void initHosts() {
        this.allHostsNode = new DefaultMutableTreeNode(this.allHostsInfo);
        this.setNode(this.allHostsNode);
        this.topAdd(this.allHostsNode);
    }

    void updateHosts() {
        final Host[] allHosts = Tools.getConfigData().getHosts().getHostsArray();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EmptyBrowser.this.allHostsNode.removeAllChildren();
                for (Host host : allHosts) {
                    HostBrowser hostBrowser = host.getBrowser();
                    DefaultMutableTreeNode resource = new DefaultMutableTreeNode(hostBrowser.getHostInfo());
                    EmptyBrowser.this.allHostsNode.add(resource);
                }
            }
        });
        this.reload(this.allHostsNode, false);
        this.selectPath(new Object[]{this.getTreeTop(), this.allHostsNode});
    }
}

