/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import lcmc.data.AccessMode;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.ClusterTab;
import lcmc.gui.ClustersPanel;
import lcmc.gui.EmptyBrowser;
import lcmc.gui.MainMenu;
import lcmc.gui.ProgressIndicatorPanel;
import lcmc.gui.ResourceGraph;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.ServicesInfo;
import lcmc.utilities.AllHostsUpdatable;
import lcmc.utilities.Tools;

public final class GUIData {
    private Container mainFrame;
    private JPanel mainPanel;
    private JSplitPane terminalSplitPane;
    private ClustersPanel clustersPanel;
    private ProgressIndicatorPanel mainGlassPane;
    private MainMenu mainMenu;
    private EmptyBrowser emptyBrowser;
    private final ReadWriteLock mAddClusterButtonListLock = new ReentrantReadWriteLock();
    private final Lock mAddClusterButtonListReadLock = this.mAddClusterButtonListLock.readLock();
    private final Lock mAddClusterButtonListWriteLock = this.mAddClusterButtonListLock.writeLock();
    private final List<JComponent> addClusterButtonList = new ArrayList<JComponent>();
    private final ReadWriteLock mAddHostButtonListLock = new ReentrantReadWriteLock();
    private final Lock mAddHostButtonListReadLock = this.mAddHostButtonListLock.readLock();
    private final Lock mAddHostButtonListWriteLock = this.mAddHostButtonListLock.writeLock();
    private final List<JComponent> addHostButtonList = new ArrayList<JComponent>();
    private final Map<JComponent, AccessMode> visibleInAccessType = new HashMap<JComponent, AccessMode>();
    private final Map<JComponent, AccessMode> enabledInAccessType = new HashMap<JComponent, AccessMode>();
    private final List<AllHostsUpdatable> allHostsUpdateList = new ArrayList<AllHostsUpdatable>();
    private List<Info> selectedComponents = null;

    public void setMainFrame(Container mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void setMainPanel(JPanel mainPanel) {
        this.mainPanel = mainPanel;
    }

    public Container getMainFrame() {
        return this.mainFrame;
    }

    public Container getMainFrameContentPane() {
        if (this.mainFrame instanceof JApplet) {
            return ((JApplet)this.mainFrame).getContentPane();
        }
        return ((JFrame)this.mainFrame).getContentPane();
    }

    public JRootPane getMainFrameRootPane() {
        if (this.mainFrame instanceof JFrame) {
            return ((JFrame)this.mainFrame).getRootPane();
        }
        if (this.mainFrame instanceof JApplet) {
            return ((JApplet)this.mainFrame).getRootPane();
        }
        return null;
    }

    public void setMainMenu(MainMenu mainMenu) {
        this.mainMenu = mainMenu;
    }

    public MainMenu getMainMenu() {
        return this.mainMenu;
    }

    void setEmptyBrowser(EmptyBrowser emptyBrowser) {
        this.emptyBrowser = emptyBrowser;
    }

    public EmptyBrowser getEmptyBrowser() {
        return this.emptyBrowser;
    }

    public ProgressIndicatorPanel getMainGlassPane() {
        return this.mainGlassPane;
    }

    public void setMainGlassPane(ProgressIndicatorPanel mainGlassPane) {
        this.mainGlassPane = mainGlassPane;
    }

    void setTerminalSplitPane(JSplitPane terminalSplitPane) {
        this.terminalSplitPane = terminalSplitPane;
    }

    public void setTerminalPanel(final Component terminalPanel) {
        if (terminalPanel == null) {
            return;
        }
        Component oldTerminalPanel = this.terminalSplitPane.getBottomComponent();
        if (!terminalPanel.equals(oldTerminalPanel)) {
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int loc = GUIData.this.terminalSplitPane.getDividerLocation();
                    GUIData.this.terminalSplitPane.setBottomComponent(terminalPanel);
                    if (loc > Tools.getDefaultInt("DrbdMC.height") - 100) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GUIData.this.expandTerminalSplitPane(1);
                            }
                        });
                    }
                }
            });
        }
    }

    int getTerminalPanelPos() {
        if (this.terminalSplitPane.getBottomComponent() == null) {
            return 0;
        }
        return this.mainPanel.getY() + this.terminalSplitPane.getBottomComponent().getY();
    }

    public boolean isTerminalPanelExpanded() {
        return this.terminalSplitPane.getBottomComponent().getSize().getHeight() != 0.0;
    }

    public void expandTerminalSplitPane(final int buttonNo) {
        if (this.terminalSplitPane == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int height = (int)GUIData.this.terminalSplitPane.getBottomComponent().getSize().getHeight();
                if (buttonNo == 0 && height == 0 || buttonNo == 1 && height > 0) {
                    Tools.debug(this, "expand terminal split pane", 1);
                    BasicSplitPaneUI ui = (BasicSplitPaneUI)GUIData.this.terminalSplitPane.getUI();
                    BasicSplitPaneDivider divider = ui.getDivider();
                    JButton button = (JButton)divider.getComponent(buttonNo);
                    button.doClick();
                }
            }
        });
    }

    public ClustersPanel getClustersPanel() {
        return this.clustersPanel;
    }

    void setClustersPanel(ClustersPanel clustersPanel) {
        this.clustersPanel = clustersPanel;
    }

    void repaintWithNewData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIData.this.clustersPanel.repaintTabs();
            }
        });
    }

    public void addClusterTab(final Cluster cluster) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIData.this.clustersPanel.addTab(cluster);
            }
        });
    }

    public void renameSelectedClusterTab(final String newName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIData.this.clustersPanel.renameSelectedTab(newName);
            }
        });
    }

    public void removeSelectedClusterTab() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIData.this.clustersPanel.removeTab();
            }
        });
    }

    public void refreshClustersPanel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIData.this.clustersPanel.refresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerAddClusterButton(JComponent addClusterButton) {
        this.mAddClusterButtonListWriteLock.lock();
        try {
            if (!this.addClusterButtonList.contains(addClusterButton)) {
                this.addClusterButtonList.add(addClusterButton);
                addClusterButton.setEnabled(Tools.getConfigData().danglingHostsCount() >= 1);
            }
        }
        finally {
            this.mAddClusterButtonListWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAddHostButton(JComponent addHostButton) {
        this.mAddHostButtonListWriteLock.lock();
        try {
            if (!this.addHostButtonList.contains(addHostButton)) {
                this.addHostButtonList.add(addHostButton);
            }
        }
        finally {
            this.mAddHostButtonListWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterAddClusterButton(JComponent addClusterButton) {
        this.mAddClusterButtonListWriteLock.lock();
        try {
            this.addClusterButtonList.remove(addClusterButton);
        }
        finally {
            this.mAddClusterButtonListWriteLock.unlock();
        }
    }

    public void checkAddClusterButtons() {
        final boolean enabled = Tools.getConfigData().danglingHostsCount() >= 1;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GUIData.this.mAddClusterButtonListReadLock.lock();
                try {
                    for (JComponent addClusterButton : GUIData.this.addClusterButtonList) {
                        addClusterButton.setEnabled(enabled);
                    }
                }
                finally {
                    GUIData.this.mAddClusterButtonListReadLock.unlock();
                }
            }
        });
    }

    public void enableAddClusterButtons(final boolean enable) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GUIData.this.mAddClusterButtonListReadLock.lock();
                try {
                    for (JComponent addClusterButton : GUIData.this.addClusterButtonList) {
                        addClusterButton.setEnabled(enable);
                    }
                }
                finally {
                    GUIData.this.mAddClusterButtonListReadLock.unlock();
                }
            }
        });
    }

    public void enableAddHostButtons(final boolean enable) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GUIData.this.mAddHostButtonListReadLock.lock();
                try {
                    for (JComponent addHostButton : GUIData.this.addHostButtonList) {
                        addHostButton.setEnabled(enable);
                    }
                }
                finally {
                    GUIData.this.mAddHostButtonListReadLock.unlock();
                }
            }
        });
    }

    void addToVisibleInAccessType(JComponent c, AccessMode accessMode) {
        c.setVisible(Tools.getConfigData().isAccessible(accessMode));
        this.visibleInAccessType.put(c, accessMode);
    }

    void addToEnabledInAccessType(JComponent c, AccessMode accessMode) {
        c.setEnabled(Tools.getConfigData().isAccessible(accessMode));
        this.enabledInAccessType.put(c, accessMode);
    }

    void godModeChanged(boolean godMode) {
        Tools.startProgressIndicator("OH MY GOD!!! Hi Rasto!");
        Tools.stopProgressIndicator("OH MY GOD!!! Hi Rasto!");
        for (Cluster cluster : Tools.getConfigData().getClusters().getClusterSet()) {
            ClusterBrowser cb = cluster.getBrowser();
            if (cb == null) continue;
            cb.getClusterViewPanel().resetOperatingModes(godMode);
        }
        this.updateGlobalItems();
    }

    void setOperatingModeGlobally(Cluster fromCluster, String opMode) {
        for (Cluster cluster : Tools.getConfigData().getClusters().getClusterSet()) {
            ClusterBrowser cb;
            if (cluster == fromCluster || (cb = cluster.getBrowser()) == null) continue;
            cb.getClusterViewPanel().setOperatingMode(opMode);
        }
    }

    void setAdvancedModeGlobally(Cluster fromCluster, boolean advancedMode) {
        for (Cluster cluster : Tools.getConfigData().getClusters().getClusterSet()) {
            ClusterBrowser cb;
            if (cluster == fromCluster || (cb = cluster.getBrowser()) == null) continue;
            cb.getClusterViewPanel().setAdvancedMode(advancedMode);
        }
    }

    void updateGlobalItems() {
        for (JComponent c : this.visibleInAccessType.keySet()) {
            c.setVisible(Tools.getConfigData().isAccessible(this.visibleInAccessType.get(c)));
        }
        for (JComponent c : this.enabledInAccessType.keySet()) {
            c.setEnabled(Tools.getConfigData().isAccessible(this.enabledInAccessType.get(c)));
        }
    }

    void registerAllHostsUpdate(AllHostsUpdatable component) {
        if (!this.allHostsUpdateList.contains(component)) {
            this.allHostsUpdateList.add(component);
        }
    }

    void unregisterAllHostsUpdate(AllHostsUpdatable component) {
        this.allHostsUpdateList.remove(component);
    }

    public void allHostsUpdate() {
        for (AllHostsUpdatable component : this.allHostsUpdateList) {
            component.allHostsUpdate();
        }
        this.checkAddClusterButtons();
    }

    public void setAccessible(JComponent c, ConfigData.AccessType required) {
        c.setEnabled(Tools.getConfigData().getAccessType().compareTo(required) >= 0);
    }

    private ServicesInfo getSelectedServicesInfo() {
        ClustersPanel csp = this.clustersPanel;
        if (csp == null) {
            return null;
        }
        ClusterTab selected = csp.getClusterTab();
        if (selected == null) {
            return null;
        }
        Cluster c = selected.getCluster();
        if (c == null) {
            return null;
        }
        return c.getBrowser().getServicesInfo();
    }

    private ResourceGraph getSelectedGraph() {
        ClustersPanel csp = this.clustersPanel;
        if (csp == null) {
            return null;
        }
        ClusterTab selected = csp.getClusterTab();
        if (selected == null) {
            return null;
        }
        Cluster c = selected.getCluster();
        if (c == null) {
            return null;
        }
        return c.getBrowser().getCRMGraph();
    }

    public void copy() {
        ResourceGraph g = this.getSelectedGraph();
        if (g == null) {
            return;
        }
        this.selectedComponents = g.getSelectedComponents();
    }

    public void paste() {
        final List<Info> scs = this.selectedComponents;
        if (scs == null) {
            return;
        }
        final ServicesInfo ssi = this.getSelectedServicesInfo();
        if (ssi == null) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ssi.pasteServices(scs);
            }
        });
        t.start();
    }

    public boolean isApplet() {
        return this.mainFrame instanceof JApplet;
    }
}

