/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import lcmc.data.Host;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.RoboTest;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public final class TerminalPanel
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private final Host host;
    private final JTextPane terminalArea;
    private final MutableAttributeSet commandColor;
    private final MutableAttributeSet errorColor;
    private final MutableAttributeSet outputColor;
    private final MutableAttributeSet promptColor;
    private int commandOffset = 0;
    private boolean userCommand = false;
    private boolean editEnabled = false;
    private int prevLine = 0;
    private int pos = 0;
    private final Lock mPosLock = new ReentrantLock();
    private int maxPos = 0;
    private final Map<String, Color> terminalColor = new HashMap<String, Color>();
    private final Color defaultOutputColor;
    private static final String CHEAT_LIST = "cheatlist";
    private static final String GOD_OFF = "nogodmode";
    private static final String GOD_ON = "godmode";
    private static final String RUN_GC = "rungc";
    private static final String ALLOCATE_10 = "allocate10";
    private static final String CLICKTEST_SHORT = "lclicksh";
    private static final String CLICKTEST_LONG = "lclicklo";
    private static final String CLICKTEST_LAZY_SHORT = "lclicklazysh";
    private static final String CLICKTEST_LAZY_LONG = "lclicklazylo";
    private static final String RIGHT_CLICKTEST_SHORT = "rclicksh";
    private static final String RIGHT_CLICKTEST_LONG = "rclicklo";
    private static final String RIGHT_CLICKTEST_LAZY_SHORT = "rclicklazysh";
    private static final String RIGHT_CLICKTEST_LAZY_LONG = "rclicklazylo";
    private static final String MOVETEST_SHORT = "movetestsh";
    private static final String MOVETEST_LONG = "movetestlo";
    private static final String MOVETEST_LAZY_SHORT = "movetestlazysh";
    private static final String MOVETEST_LAZY_LONG = "movetestlazylo";
    private static final String DEBUG_INC = "debuginc";
    private static final String DEBUG_DEC = "debugdec";
    private static final Map<String, String> TESTS = new HashMap<String, String>();
    private static final String REGISTER_MOVEMENT = "registermovement";
    private static final Map<String, Integer> CHEATS_MAP;

    public TerminalPanel(Host host) {
        this.host = host;
        host.setTerminalPanel(this);
        this.terminalColor.put("0", Tools.getDefaultColor("TerminalPanel.TerminalWhite"));
        this.terminalColor.put("30", Tools.getDefaultColor("TerminalPanel.TerminalBlack"));
        this.terminalColor.put("31", Tools.getDefaultColor("TerminalPanel.TerminalRed"));
        this.terminalColor.put("32", Tools.getDefaultColor("TerminalPanel.TerminalGreen"));
        this.terminalColor.put("33", Tools.getDefaultColor("TerminalPanel.TerminalYellow"));
        this.terminalColor.put("34", Tools.getDefaultColor("TerminalPanel.TerminalBlue"));
        this.terminalColor.put("35", Tools.getDefaultColor("TerminalPanel.TerminalPurple"));
        this.terminalColor.put("36", Tools.getDefaultColor("TerminalPanel.TerminalCyan"));
        Font f = new Font("Monospaced", 0, Tools.getConfigData().scaled(14));
        this.terminalArea = new JTextPane();
        this.terminalArea.setStyledDocument(new MyDocument());
        DefaultCaret caret = new DefaultCaret(){
            private static final long serialVersionUID = 1L;

            @Override
            protected synchronized void damage(Rectangle r) {
                if (r != null) {
                    this.x = r.x;
                    this.y = r.y;
                    this.width = 8;
                    this.height = r.height;
                    this.repaint();
                }
            }

            @Override
            public void paint(Graphics g) {
                try {
                    TextUI mapper = this.getComponent().getUI();
                    Rectangle r = mapper.modelToView(this.getComponent(), this.getDot(), this.getDotBias());
                    if (r == null) {
                        return;
                    }
                    g.setColor(this.getComponent().getCaretColor());
                    if (this.isVisible() && TerminalPanel.this.editEnabled) {
                        g.fillRect(r.x, r.y, 8, r.height);
                    } else {
                        g.drawRect(r.x, r.y, 8, r.height);
                    }
                }
                catch (BadLocationException e) {
                    Tools.appError("Drawing of cursor failed", e);
                }
            }
        };
        this.terminalArea.setCaret(caret);
        this.terminalArea.addCaretListener(new CaretListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void caretUpdate(CaretEvent e) {
                TerminalPanel.this.mPosLock.lock();
                try {
                    if (e != null && e.getDot() < TerminalPanel.this.commandOffset && e.getDot() == e.getMark()) {
                        TerminalPanel.this.terminalArea.setCaretPosition(TerminalPanel.this.commandOffset);
                    }
                }
                finally {
                    TerminalPanel.this.mPosLock.unlock();
                }
            }
        });
        this.terminalArea.setFont(f);
        this.terminalArea.setBackground(Tools.getDefaultColor("TerminalPanel.Background"));
        this.commandColor = new SimpleAttributeSet();
        StyleConstants.setForeground(this.commandColor, Tools.getDefaultColor("TerminalPanel.Command"));
        this.errorColor = new SimpleAttributeSet();
        StyleConstants.setForeground(this.errorColor, Tools.getDefaultColor("TerminalPanel.Error"));
        this.outputColor = new SimpleAttributeSet();
        this.defaultOutputColor = Tools.getDefaultColor("TerminalPanel.Output");
        StyleConstants.setForeground(this.outputColor, this.defaultOutputColor);
        this.promptColor = new SimpleAttributeSet();
        StyleConstants.setForeground(this.promptColor, host.getPmColors()[0]);
        this.append(this.prompt(), this.promptColor);
        this.terminalArea.setEditable(true);
        this.getViewport().add((Component)this.terminalArea, "Last");
        this.setPreferredSize(new Dimension(Short.MAX_VALUE, Tools.getDefaultInt("MainPanel.TerminalPanelHeight")));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
    }

    private Color getColorFromString(String s) {
        if ("[".equals(s)) {
            return null;
        }
        Pattern p1 = Pattern.compile("^\\[\\d+;(\\d+)$");
        Matcher m1 = p1.matcher(s);
        if (m1.matches()) {
            String c = m1.group(1);
            return this.terminalColor.get(c);
        }
        Pattern p2 = Pattern.compile("^\\[\\d+;\\d+;(\\d+)$");
        Matcher m2 = p2.matcher(s);
        if (m2.matches()) {
            String c = m2.group(1);
            return this.terminalColor.get(c);
        }
        return null;
    }

    private int getCharCount(String s) {
        Pattern p1 = Pattern.compile("^\\[(\\d+)$");
        Matcher m1 = p1.matcher(s);
        if (m1.matches()) {
            return Integer.parseInt(m1.group(1));
        }
        return 0;
    }

    private void append(String text, MutableAttributeSet colorAS) {
        this.userCommand = false;
        MyDocument doc = (MyDocument)this.terminalArea.getStyledDocument();
        this.mPosLock.lock();
        int end = this.terminalArea.getDocument().getLength();
        this.pos = end + this.pos - this.maxPos;
        this.maxPos = end;
        char[] chars = text.toCharArray();
        StringBuilder colorString = new StringBuilder(10);
        boolean inside = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            String s = Character.toString(c);
            boolean printit = true;
            if (c == '\b') {
                printit = false;
                --this.pos;
            } else if (i < chars.length - 1 && c == '\r' && chars[i + 1] == '\n') {
                this.prevLine = this.maxPos + 2;
                this.pos = this.maxPos;
            } else if (c == '\r') {
                this.pos = this.prevLine;
                printit = false;
            } else if (c == '\u001b') {
                inside = true;
                printit = false;
                colorString = new StringBuilder(10);
            }
            if (inside) {
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                    inside = false;
                    if (c == 'm') {
                        Color newColor = this.getColorFromString(colorString.toString());
                        if (newColor == null) {
                            newColor = this.defaultOutputColor;
                        }
                        StyleConstants.setForeground(colorAS, newColor);
                        colorString = new StringBuilder(10);
                    } else if (c == 'G') {
                        int g = this.getCharCount(colorString.toString());
                        this.pos = this.prevLine + g;
                        while (this.pos > this.maxPos) {
                            try {
                                doc.insertString(this.maxPos, " ", colorAS);
                                ++this.maxPos;
                            }
                            catch (BadLocationException e1) {
                                Tools.appError("TerminalPanel pos: " + this.pos, e1);
                            }
                        }
                    }
                } else if (printit) {
                    colorString.append(s);
                }
                printit = false;
            }
            if (!printit) continue;
            if (this.pos < this.maxPos) {
                try {
                    this.commandOffset = this.pos - 1;
                    doc.removeForced(this.pos, 1);
                }
                catch (BadLocationException e) {
                    Tools.appError("TerminalPanel pos: " + this.pos, e);
                }
            }
            try {
                doc.insertString(this.pos, s, colorAS);
            }
            catch (BadLocationException e1) {
                Tools.appError("TerminalPanel pos: " + this.pos, e1);
            }
            ++this.pos;
            if (this.maxPos >= this.pos) continue;
            this.maxPos = this.pos;
        }
        this.commandOffset = this.terminalArea.getDocument().getLength();
        this.terminalArea.setCaretPosition(this.terminalArea.getDocument().getLength());
        this.mPosLock.unlock();
        this.userCommand = true;
    }

    void setEditable(boolean editable) {
        this.terminalArea.setEditable(editable);
    }

    void execCommand(final String command) {
        final String hostName = this.host.getName();
        if (!this.host.isConnected()) {
            return;
        }
        if (!"".equals(command)) {
            Tools.startProgressIndicator(hostName, "Executing command");
        }
        this.host.execCommandRaw(command, new ExecCallback(){

            @Override
            public void done(String ans) {
                if (!"".equals(command)) {
                    Tools.stopProgressIndicator(hostName, "Executing command");
                }
            }

            @Override
            public void doneError(String ans, int exitCode) {
                if (!"".equals(command)) {
                    Tools.stopProgressIndicator(hostName, "Executing command");
                }
            }
        }, true, false, SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    public void resetPromptColor() {
        StyleConstants.setForeground(this.promptColor, this.host.getPmColors()[0]);
        this.addCommand("");
        this.nextCommand();
    }

    private String prompt() {
        if (this.host.isConnected()) {
            return "[" + this.host.getUserAtHost() + ":~#] ";
        }
        return "# ";
    }

    public void nextCommand() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TerminalPanel.this.append(TerminalPanel.this.prompt(), TerminalPanel.this.promptColor);
            }
        });
    }

    public void addCommand(String command) {
        final String[] lines = command.split("\\r?\\n");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TerminalPanel.this.append(lines[0], TerminalPanel.this.commandColor);
                for (int i = 1; i < lines.length; ++i) {
                    TerminalPanel.this.append(" \\\n> " + lines[i], TerminalPanel.this.commandColor);
                }
                TerminalPanel.this.append("\n", TerminalPanel.this.commandColor);
            }
        });
    }

    public void addCommandOutput(final String output) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TerminalPanel.this.append(output, TerminalPanel.this.outputColor);
            }
        });
    }

    void addCommandOutput(final String[] output) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < output.length; ++i) {
                    if (output[i] == null) continue;
                    String newLine = "";
                    if (i != output.length - 1) {
                        newLine = "\n";
                    }
                    TerminalPanel.this.append(output[i] + newLine, TerminalPanel.this.outputColor);
                }
            }
        });
    }

    public void addContent(final String c) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TerminalPanel.this.append(c, TerminalPanel.this.outputColor);
            }
        });
    }

    public void addContentErr(final String c) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TerminalPanel.this.append(c, TerminalPanel.this.errorColor);
            }
        });
    }

    private void startCheat(String cheat) {
        if (!this.editEnabled) {
            this.addCommand(cheat);
        }
        if (!this.editEnabled && GOD_ON.equals(cheat)) {
            this.editEnabled = true;
            Tools.getGUIData().godModeChanged(this.editEnabled);
        } else if (this.editEnabled && GOD_OFF.equals(cheat)) {
            this.editEnabled = false;
            Tools.getGUIData().godModeChanged(this.editEnabled);
        } else if (CHEAT_LIST.equals(cheat)) {
            StringBuilder list = new StringBuilder();
            for (String ch : CHEATS_MAP.keySet()) {
                list.append(ch);
                list.append('\n');
            }
            this.addCommandOutput(list.toString());
        } else if (RUN_GC.equals(cheat)) {
            System.gc();
            Tools.info("run gc");
        } else if (ALLOCATE_10.equals(cheat)) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    Tools.info("allocate mem");
                    Byte[] b = new Byte[1024000];
                    Tools.info("allocate mem done.");
                    System.gc();
                    Tools.info("run gc");
                    Tools.sleep(60000);
                    Tools.info("free mem.");
                }
            });
            t.start();
        } else if (CLICKTEST_SHORT.equals(cheat)) {
            RoboTest.startClicker(1, false);
        } else if (CLICKTEST_LONG.equals(cheat)) {
            RoboTest.startClicker(480, false);
        } else if (CLICKTEST_LAZY_SHORT.equals(cheat)) {
            RoboTest.startClicker(1, true);
        } else if (CLICKTEST_LAZY_LONG.equals(cheat)) {
            RoboTest.startClicker(480, true);
        } else if (RIGHT_CLICKTEST_SHORT.equals(cheat)) {
            RoboTest.startRightClicker(1, false);
        } else if (RIGHT_CLICKTEST_LONG.equals(cheat)) {
            RoboTest.startRightClicker(480, false);
        } else if (RIGHT_CLICKTEST_LAZY_SHORT.equals(cheat)) {
            RoboTest.startRightClicker(1, true);
        } else if (RIGHT_CLICKTEST_LAZY_LONG.equals(cheat)) {
            RoboTest.startRightClicker(480, true);
        } else if (MOVETEST_SHORT.equals(cheat)) {
            RoboTest.startMover(1, false);
        } else if (MOVETEST_LONG.equals(cheat)) {
            RoboTest.startMover(480, false);
        } else if (MOVETEST_LAZY_SHORT.equals(cheat)) {
            RoboTest.startMover(1, true);
        } else if (MOVETEST_LAZY_LONG.equals(cheat)) {
            RoboTest.startMover(480, true);
        } else if (DEBUG_INC.equals(cheat)) {
            Tools.incrementDebugLevel();
        } else if (DEBUG_DEC.equals(cheat)) {
            Tools.decrementDebugLevel();
        } else if (TESTS.containsKey(cheat)) {
            RoboTest.startTest(TESTS.get(cheat), this.host.getCluster());
        } else if (REGISTER_MOVEMENT.equals(cheat)) {
            RoboTest.registerMovement();
        }
        this.nextCommand();
    }

    public void resetTerminalArea() {
        for (int i = 0; i < 10; ++i) {
            try {
                MyDocument doc = (MyDocument)this.terminalArea.getStyledDocument();
                this.mPosLock.lock();
                this.commandOffset = 0;
                this.pos = 0;
                this.maxPos = 0;
                doc.removeForced(0, doc.getLength());
                this.mPosLock.unlock();
                return;
            }
            catch (BadLocationException e) {
                continue;
            }
        }
    }

    static {
        TESTS.put("starttest0", "0");
        TESTS.put("starttest1", "1");
        TESTS.put("starttest2", "2");
        TESTS.put("starttest3", "3");
        TESTS.put("starttest4", "4");
        TESTS.put("starttest5", "5");
        TESTS.put("starttest6", "6");
        TESTS.put("starttest7", "7");
        TESTS.put("starttest8", "8");
        TESTS.put("starttest9", "9");
        TESTS.put("starttestx1", "x1");
        TESTS.put("starttestx2", "x2");
        TESTS.put("starttestx3", "x3");
        TESTS.put("starttestx4", "x4");
        TESTS.put("starttestx5", "x5");
        TESTS.put("starttestx6", "x6");
        TESTS.put("starttestx7", "x7");
        TESTS.put("starttestx8", "x8");
        TESTS.put("starttestx9", "x9");
        TESTS.put("starttesta", "a");
        TESTS.put("starttestb", "b");
        TESTS.put("starttestc", "c");
        TESTS.put("starttestd", "d");
        TESTS.put("startteste", "e");
        TESTS.put("starttestf", "f");
        TESTS.put("starttestg", "g");
        TESTS.put("starttesth", "h");
        TESTS.put("starttesti", "i");
        TESTS.put("starttestj", "j");
        CHEATS_MAP = new LinkedHashMap<String, Integer>();
        CHEATS_MAP.put(CHEAT_LIST, 0);
        CHEATS_MAP.put(GOD_OFF, 0);
        CHEATS_MAP.put(GOD_ON, 0);
        CHEATS_MAP.put(RUN_GC, 0);
        CHEATS_MAP.put(ALLOCATE_10, 0);
        CHEATS_MAP.put(CLICKTEST_SHORT, 0);
        CHEATS_MAP.put(CLICKTEST_LONG, 0);
        CHEATS_MAP.put(CLICKTEST_LAZY_SHORT, 0);
        CHEATS_MAP.put(CLICKTEST_LAZY_LONG, 0);
        CHEATS_MAP.put(RIGHT_CLICKTEST_SHORT, 0);
        CHEATS_MAP.put(RIGHT_CLICKTEST_LONG, 0);
        CHEATS_MAP.put(RIGHT_CLICKTEST_LAZY_SHORT, 0);
        CHEATS_MAP.put(RIGHT_CLICKTEST_LAZY_LONG, 0);
        CHEATS_MAP.put(MOVETEST_SHORT, 0);
        CHEATS_MAP.put(MOVETEST_LONG, 0);
        CHEATS_MAP.put(MOVETEST_LAZY_SHORT, 0);
        CHEATS_MAP.put(MOVETEST_LAZY_LONG, 0);
        CHEATS_MAP.put(DEBUG_INC, 0);
        CHEATS_MAP.put(DEBUG_DEC, 0);
        for (String test : TESTS.keySet()) {
            CHEATS_MAP.put(test, 0);
        }
        CHEATS_MAP.put(REGISTER_MOVEMENT, 0);
    }

    class MyDocument
    extends DefaultStyledDocument {
        private static final long serialVersionUID = 1L;

        MyDocument() {
        }

        @Override
        public void insertString(int offs, String s, AttributeSet a) throws BadLocationException {
            TerminalPanel.this.mPosLock.lock();
            if (offs < TerminalPanel.this.commandOffset) {
                TerminalPanel.this.terminalArea.setCaretPosition(TerminalPanel.this.commandOffset);
                offs = TerminalPanel.this.commandOffset;
            }
            if (TerminalPanel.this.userCommand) {
                if (TerminalPanel.this.editEnabled) {
                    if (s.charAt(s.length() - 1) == '\n') {
                        int end = TerminalPanel.this.terminalArea.getDocument().getLength();
                        super.insertString(end, "\n", TerminalPanel.this.commandColor);
                        String command = (this.getText(TerminalPanel.this.commandOffset, end - TerminalPanel.this.commandOffset) + s).trim();
                        TerminalPanel.this.prevLine = end + 1;
                        TerminalPanel.this.pos = end;
                        TerminalPanel.this.maxPos = end;
                        TerminalPanel.this.execCommand(command);
                    } else {
                        super.insertString(offs, s, TerminalPanel.this.commandColor);
                    }
                }
                for (String cheat : CHEATS_MAP.keySet()) {
                    int cheatPos;
                    if (s.equals(cheat.substring(cheatPos = ((Integer)CHEATS_MAP.get(cheat)).intValue(), cheatPos + 1))) {
                        CHEATS_MAP.put(cheat, ++cheatPos);
                        if (cheatPos != cheat.length()) continue;
                        for (String ch : CHEATS_MAP.keySet()) {
                            CHEATS_MAP.put(ch, 0);
                        }
                        TerminalPanel.this.startCheat(cheat);
                        continue;
                    }
                    CHEATS_MAP.put(cheat, 0);
                }
            } else {
                super.insertString(offs, s, a);
            }
            TerminalPanel.this.mPosLock.unlock();
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            TerminalPanel.this.mPosLock.lock();
            if (offs >= TerminalPanel.this.commandOffset) {
                for (String cheat : CHEATS_MAP.keySet()) {
                    int cheatPos = (Integer)CHEATS_MAP.get(cheat);
                    if (cheatPos <= 0) continue;
                    CHEATS_MAP.put(cheat, cheatPos - 1);
                }
                if (TerminalPanel.this.editEnabled) {
                    super.remove(offs, len);
                }
            }
            TerminalPanel.this.mPosLock.unlock();
        }

        void removeForced(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
        }
    }
}

