/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.drbdConfig;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.drbdConfig.Resource;
import lcmc.gui.dialog.drbdConfig.Volume;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.DrbdInfo;
import lcmc.gui.resources.DrbdResourceInfo;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.StringInfo;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.Tools;

public final class Start
extends WizardDialog {
    private static final long serialVersionUID = 1L;
    private Widget drbdResourceWi;
    private static final int COMBOBOX_WIDTH = 250;
    private final DrbdInfo drbdInfo;
    private final BlockDevInfo blockDevInfo1;
    private final BlockDevInfo blockDevInfo2;
    private DrbdResourceInfo drbdResourceInfo;

    public Start(WizardDialog previousDialog, DrbdInfo drbdInfo, BlockDevInfo blockDevInfo1, BlockDevInfo blockDevInfo2) {
        super(previousDialog);
        this.drbdInfo = drbdInfo;
        this.blockDevInfo1 = blockDevInfo1;
        this.blockDevInfo2 = blockDevInfo2;
    }

    @Override
    public WizardDialog nextDialog() {
        boolean newResource = false;
        Info i = (Info)this.drbdResourceWi.getValue();
        if (i.getInternalValue() == null) {
            ArrayList<BlockDevInfo> bdis = new ArrayList<BlockDevInfo>(Arrays.asList(this.blockDevInfo1, this.blockDevInfo2));
            this.drbdResourceInfo = this.drbdInfo.getNewDrbdResource(DrbdVolumeInfo.getHostsFromBlockDevices(bdis));
            this.drbdInfo.addDrbdResource(this.drbdResourceInfo);
            newResource = true;
        } else {
            this.drbdResourceInfo = (DrbdResourceInfo)i;
        }
        DrbdVolumeInfo dvi = this.drbdInfo.getNewDrbdVolume(this.drbdResourceInfo, new ArrayList<BlockDevInfo>(Arrays.asList(this.blockDevInfo1, this.blockDevInfo2)));
        this.drbdResourceInfo.addDrbdVolume(dvi);
        this.drbdInfo.addDrbdVolume(dvi);
        if (newResource) {
            return new Resource(this, dvi);
        }
        return new Volume(this, dvi);
    }

    @Override
    protected String getDialogTitle() {
        return Tools.getString("Dialog.DrbdConfig.Start.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.DrbdConfig.Start.Description");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        if (Tools.getConfigData().getAutoOptionGlobal("autodrbd") != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Start.this.pressNextButton();
                }
            });
        }
    }

    @Override
    protected JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        JPanel inputPane = new JPanel(new SpringLayout());
        JLabel drbdResourceLabel = new JLabel(Tools.getString("Dialog.DrbdConfig.Start.DrbdResource"));
        String newDrbdResource = Tools.getString("Dialog.DrbdConfig.Start.NewDrbdResource");
        ArrayList<Info> choices = new ArrayList<Info>();
        choices.add(new StringInfo(newDrbdResource, null, null));
        for (DrbdResourceInfo dri : this.drbdInfo.getDrbdResources()) {
            choices.add(dri);
        }
        this.drbdResourceWi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, Widget.NO_DEFAULT, choices.toArray(new Info[choices.size()]), Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        inputPane.add(drbdResourceLabel);
        inputPane.add(this.drbdResourceWi);
        SpringUtilities.makeCompactGrid(inputPane, 1, 2, 1, 1, 1, 1);
        pane.add(inputPane);
        pane.add(this.getProgressBarPane(null));
        pane.add(this.getAnswerPane(""));
        SpringUtilities.makeCompactGrid(pane, 3, 1, 0, 0, 0, 0);
        return pane;
    }
}

