/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.lvm;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.resources.BlockDevice;
import lcmc.gui.Browser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.lvm.LV;
import lcmc.gui.widget.TextfieldWithUnit;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.LVM;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

public final class LVCreate
extends LV {
    private final Host host;
    private final MyButton createButton = new MyButton("Create");
    private Widget lvNameWi;
    private Widget sizeWi;
    private Widget maxSizeWi;
    private final String volumeGroup;
    private Map<Host, JCheckBox> hostCheckBoxes = null;
    private BlockDevice selectedBlockDevice;
    private static final String LV_CREATE_DESCRIPTION = "Create a logical volume in an existing volume group.";
    private static final int CREATE_TIMEOUT = 5000;

    public LVCreate(Host host, String volumeGroup, BlockDevice selectedBlockDevice) {
        super(null);
        this.host = host;
        this.volumeGroup = volumeGroup;
        this.selectedBlockDevice = selectedBlockDevice;
    }

    @Override
    protected void finishDialog() {
    }

    @Override
    protected String getDialogTitle() {
        return "Create LV";
    }

    @Override
    protected String getDescription() {
        return LV_CREATE_DESCRIPTION;
    }

    @Override
    public String cancelButton() {
        return "Close";
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[0]);
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        this.makeDefaultAndRequestFocusLater(this.sizeWi);
        this.makeDefaultButton(this.createButton);
    }

    protected void checkButtons() {
        SwingUtilities.invokeLater(new EnableCreateRunnable(true));
    }

    @Override
    protected JComponent getInputPane() {
        String defaultName;
        this.createButton.setEnabled(false);
        JPanel pane = new JPanel(new SpringLayout());
        JPanel inputPane = new JPanel(new SpringLayout());
        inputPane.setBackground(Browser.BUTTON_PANEL_BACKGROUND);
        inputPane.add(new JLabel("Group"));
        inputPane.add(new JLabel(this.volumeGroup));
        inputPane.add(new JLabel());
        Set<String> logicalVolumes = this.host.getLogicalVolumesFromVolumeGroup(this.volumeGroup);
        int i = 0;
        while (true) {
            defaultName = "lvol" + i;
            if (logicalVolumes == null || !logicalVolumes.contains(defaultName)) break;
            ++i;
        }
        this.lvNameWi = WidgetFactory.createInstance(Widget.Type.TEXTFIELD, defaultName, Widget.NO_ITEMS, Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.OP, false), Widget.NO_BUTTON);
        inputPane.add(new JLabel("LV Name"));
        inputPane.add(this.lvNameWi);
        inputPane.add(new JLabel());
        this.lvNameWi.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                LVCreate.this.checkButtons();
            }
        });
        String maxBlockSize = this.getMaxBlockSize();
        String newBlockSize = Long.toString(Long.parseLong(maxBlockSize) / 2L);
        JLabel sizeLabel = new JLabel("New Size");
        this.sizeWi = new TextfieldWithUnit(Tools.convertKilobytes(newBlockSize), LVCreate.getUnits(), Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.OP, false), Widget.NO_BUTTON);
        inputPane.add(sizeLabel);
        inputPane.add(this.sizeWi);
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Tools.invokeAndWait(new EnableCreateRunnable(false));
                        LVCreate.this.disableComponents();
                        LVCreate.this.getProgressBar().start(5000 * LVCreate.this.hostCheckBoxes.size());
                        boolean oneFailed = false;
                        for (Host h : LVCreate.this.hostCheckBoxes.keySet()) {
                            boolean ret;
                            if (!((JCheckBox)LVCreate.this.hostCheckBoxes.get(h)).isSelected() || (ret = LVCreate.this.lvCreate(h, LVCreate.this.lvNameWi.getStringValue(), LVCreate.this.sizeWi.getStringValue()))) continue;
                            oneFailed = true;
                        }
                        for (Host h : LVCreate.this.hostCheckBoxes.keySet()) {
                            h.getBrowser().getClusterBrowser().updateHWInfo(h);
                        }
                        String maxBlockSize = LVCreate.this.getMaxBlockSize();
                        long maxSize = Long.parseLong(maxBlockSize);
                        LVCreate.this.maxSizeWi.setValue(Tools.convertKilobytes(maxBlockSize));
                        LVCreate.this.enableComponents();
                        if (oneFailed) {
                            LVCreate.this.progressBarDoneError();
                        } else {
                            LVCreate.this.progressBarDone();
                        }
                    }
                });
                thread.start();
            }
        });
        inputPane.add(this.createButton);
        JLabel maxSizeLabel = new JLabel("Max Size");
        maxSizeLabel.setEnabled(false);
        this.maxSizeWi = new TextfieldWithUnit(Tools.convertKilobytes(maxBlockSize), LVCreate.getUnits(), Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.OP, false), Widget.NO_BUTTON);
        this.maxSizeWi.setEnabled(false);
        inputPane.add(maxSizeLabel);
        inputPane.add(this.maxSizeWi);
        inputPane.add(new JLabel());
        this.sizeWi.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                LVCreate.this.checkButtons();
            }
        });
        SpringUtilities.makeCompactGrid(inputPane, 4, 3, 1, 1, 1, 1);
        pane.add(inputPane);
        JPanel hostsPane = new JPanel(new FlowLayout(0));
        Cluster cluster = this.host.getCluster();
        this.hostCheckBoxes = Tools.getHostCheckBoxes(cluster);
        hostsPane.add(new JLabel("Select Hosts: "));
        for (Host h : this.hostCheckBoxes.keySet()) {
            this.hostCheckBoxes.get(h).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    LVCreate.this.checkButtons();
                }
            });
            if (this.host == h) {
                this.hostCheckBoxes.get(h).setEnabled(false);
                this.hostCheckBoxes.get(h).setSelected(true);
            } else if (this.selectedBlockDevice != null && this.selectedBlockDevice.isDrbd()) {
                this.hostCheckBoxes.get(h).setEnabled(false);
                this.hostCheckBoxes.get(h).setSelected(false);
            } else if (!h.getVolumeGroupNames().contains(this.volumeGroup)) {
                this.hostCheckBoxes.get(h).setEnabled(false);
                this.hostCheckBoxes.get(h).setSelected(false);
            } else {
                this.hostCheckBoxes.get(h).setEnabled(true);
                this.hostCheckBoxes.get(h).setSelected(false);
            }
            hostsPane.add(this.hostCheckBoxes.get(h));
        }
        JScrollPane sp = new JScrollPane(hostsPane);
        sp.setPreferredSize(new Dimension(0, 45));
        pane.add(sp);
        pane.add(this.getProgressBarPane(null));
        pane.add(this.getAnswerPane(""));
        SpringUtilities.makeCompactGrid(pane, 4, 1, 0, 0, 0, 0);
        this.checkButtons();
        return pane;
    }

    private boolean lvCreate(Host host, String lvName, String size) {
        boolean ret = LVM.lvCreate(host, lvName, this.volumeGroup, size, false);
        if (ret) {
            this.answerPaneAddText("Logical volume " + lvName + " was successfully created in " + this.volumeGroup + " on " + host.getName() + ".");
        } else {
            this.answerPaneAddTextError("Creating of logical volume " + lvName + " failed.");
        }
        return ret;
    }

    private String getMaxBlockSize() {
        long free = this.host.getFreeInVolumeGroup(this.volumeGroup) / 1024L;
        if (this.hostCheckBoxes != null) {
            for (Host h : this.hostCheckBoxes.keySet()) {
                if (!this.hostCheckBoxes.get(h).isSelected() || h.getFreeInVolumeGroup(this.volumeGroup) / 1024L >= free) continue;
                free = h.getFreeInVolumeGroup(this.volumeGroup) / 1024L;
            }
        }
        return Long.toString(free);
    }

    private class EnableCreateRunnable
    implements Runnable {
        private final boolean enable;

        public EnableCreateRunnable(boolean enable) {
            this.enable = enable;
        }

        @Override
        public void run() {
            boolean e = this.enable;
            if (this.enable) {
                String maxBlockSize = LVCreate.this.getMaxBlockSize();
                long maxSize = Long.parseLong(maxBlockSize);
                LVCreate.this.maxSizeWi.setValue(Tools.convertKilobytes(maxBlockSize));
                long size = Tools.convertToKilobytes(LVCreate.this.sizeWi.getStringValue());
                if (size > maxSize || size <= 0L) {
                    e = false;
                    LVCreate.this.sizeWi.wrongValue();
                } else {
                    LVCreate.this.sizeWi.setBackground("", "", true);
                }
                boolean lvNameCorrect = true;
                if ("".equals(LVCreate.this.lvNameWi.getStringValue())) {
                    lvNameCorrect = false;
                } else if (LVCreate.this.hostCheckBoxes != null) {
                    for (Host h : LVCreate.this.hostCheckBoxes.keySet()) {
                        Set<String> lvs;
                        if (!((JCheckBox)LVCreate.this.hostCheckBoxes.get(h)).isSelected() || (lvs = h.getLogicalVolumesFromVolumeGroup(LVCreate.this.volumeGroup)) == null || !lvs.contains(LVCreate.this.lvNameWi.getStringValue())) continue;
                        lvNameCorrect = false;
                        break;
                    }
                }
                if (lvNameCorrect) {
                    LVCreate.this.lvNameWi.setBackground("", "", true);
                } else {
                    e = false;
                    LVCreate.this.lvNameWi.wrongValue();
                }
            }
            LVCreate.this.createButton.setEnabled(e);
        }
    }
}

