/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import lcmc.Exceptions;
import lcmc.configs.AppDefaults;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.DRBDtestData;
import lcmc.data.DrbdXML;
import lcmc.data.Host;
import lcmc.data.resources.DrbdResource;
import lcmc.data.resources.NetInterface;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.HostBrowser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.DrbdGuiInfo;
import lcmc.gui.resources.DrbdInfo;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.NetInfo;
import lcmc.gui.resources.ProxyNetInfo;
import lcmc.gui.resources.ServiceInfo;
import lcmc.gui.resources.StringInfo;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.DRBD;
import lcmc.utilities.MyButton;
import lcmc.utilities.MyMenu;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;
import lcmc.utilities.WidgetListener;

public final class DrbdResourceInfo
extends DrbdGuiInfo {
    private final Set<DrbdVolumeInfo> drbdVolumes = new LinkedHashSet<DrbdVolumeInfo>();
    private JComponent infoPanel = null;
    private boolean haveToCreateMD = false;
    static final String DRBD_RES_PARAM_NAME = "name";
    private Map<Host, Widget> addressComboBoxHash = new HashMap<Host, Widget>();
    private Map<Host, Widget> insideIpComboBoxHash = new HashMap<Host, Widget>();
    private Map<Host, Widget> outsideIpComboBoxHash = new HashMap<Host, Widget>();
    private Map<Host, Widget> addressComboBoxHashWizard = new HashMap<Host, Widget>();
    private Map<Host, Widget> insideIpComboBoxHashWizard = new HashMap<Host, Widget>();
    private Map<Host, Widget> outsideIpComboBoxHashWizard = new HashMap<Host, Widget>();
    private final Map<Host, String> savedHostAddresses = new HashMap<Host, String>();
    private final Map<Host, String> savedInsideIps = new HashMap<Host, String>();
    private final Map<Host, String> savedOutsideIps = new HashMap<Host, String>();
    private String savedPort = null;
    private String savedInsidePort = null;
    private String savedOutsidePort = null;
    private Widget portComboBox = null;
    private Widget portComboBoxWizard = null;
    private Widget insidePortComboBox = null;
    private Widget outsidePortComboBox = null;
    private Widget insidePortComboBoxWizard = null;
    private Widget outsidePortComboBoxWizard = null;
    private Widget resyncAfterParamWi = null;
    private ServiceInfo isUsedByCRM;
    private final Set<Host> hosts;
    private final Set<Host> selectedProxyHosts = new HashSet<Host>();
    private static final String SECTION_PROXY = "proxy";
    private static final String SECTION_PROXY_PORTS = Tools.getString("DrbdResourceInfo.ProxyPorts");
    private static final String PROXY_DEFAULT_PROTOCOL = "A";
    private static final String PROXY_DEFAULT_PING_TIMEOUT = "100";
    public static final Pattern DRBDP_ADDRESS = Pattern.compile("^proxy: (\\d+\\.\\d+\\.\\d+\\.\\d+)(\\s+\\S+\\s+(\\S+))$");

    DrbdResourceInfo(String name, Set<Host> hosts, Browser browser) {
        super(name, browser);
        this.hosts = hosts;
        this.setResource(new DrbdResource(name));
    }

    public void addDrbdVolume(DrbdVolumeInfo drbdVolume) {
        this.drbdVolumes.add(drbdVolume);
    }

    String proxyConfig(ProxyNetInfo proxyNetInfo) throws Exceptions.DrbdConfigException {
        StringBuilder config = new StringBuilder(50);
        Host host = proxyNetInfo.getProxyHost();
        String insideIp = this.getIp(this.insideIpComboBoxHash.get(host).getValue());
        String insidePort = this.insidePortComboBox.getStringValue();
        String outsideIp = this.getIp(this.outsideIpComboBoxHash.get(host).getValue());
        String outsidePort = this.outsidePortComboBox.getStringValue();
        config.append("\n\t\tproxy on ");
        config.append(host.getName());
        config.append(" {\n");
        config.append("\t\t\tinside ");
        config.append(this.getNetInterfaceWithPort(insideIp, insidePort));
        config.append(";\n\t\t\toutside ");
        config.append(this.getNetInterfaceWithPort(outsideIp, outsidePort));
        config.append(";\n\t\t}");
        return config.toString();
    }

    String drbdResourceConfig(Host configOnHost) throws Exceptions.DrbdConfigException {
        String[] params;
        StringBuilder config = new StringBuilder(50);
        config.append("resource " + this.getName() + " {\n");
        for (String param : params = this.getBrowser().getDrbdXML().getSectionParams("resource")) {
            String value = this.getComboBoxValue(param);
            if (value != null && value.equals(this.getParamDefault(param))) continue;
            config.append('\t');
            config.append(param);
            config.append('\t');
            config.append(value);
            config.append(";\n");
        }
        if (params.length != 0) {
            config.append('\n');
        }
        config.append(this.drbdSectionsConfig(configOnHost));
        boolean volumesAvailable = configOnHost.hasVolumes();
        for (Host host : this.getHosts()) {
            ArrayList<String> volumeConfigs = new ArrayList<String>();
            for (DrbdVolumeInfo dvi : this.drbdVolumes) {
                String volumeConfig = dvi.drbdVolumeConfig(host, volumesAvailable);
                if ("".equals(volumeConfig)) continue;
                volumeConfigs.add(volumeConfig);
            }
            if (volumeConfigs.isEmpty()) continue;
            config.append("\ton ");
            config.append(host.getName());
            config.append(" {\n\t\t");
            config.append(Tools.join("\n\n\t\t", volumeConfigs));
            Widget awi = this.addressComboBoxHash.get(host);
            Widget pwi = this.portComboBox;
            if (awi != null && pwi != null) {
                Matcher drbdpM;
                Object o = awi.getValue();
                if (o == null) {
                    throw new Exceptions.DrbdConfigException("Address not defined in " + this.getCluster().getName() + " (" + this.getName() + ")");
                }
                String ip = this.getIp(o);
                config.append("\n\t\taddress\t\t");
                config.append(this.getNetInterfaceWithPort(ip, pwi.getStringValue()));
                config.append(";");
                if (awi.getValue() instanceof ProxyNetInfo) {
                    config.append(this.proxyConfig((ProxyNetInfo)awi.getValue()));
                } else if (this.isProxyAddress(awi.getValue()) && (drbdpM = DRBDP_ADDRESS.matcher(awi.getValue().toString())).matches()) {
                    String proxyIp = drbdpM.group(1);
                    String hostName = drbdpM.group(3);
                    Host proxyHost = this.getCluster().getProxyHostByName(hostName);
                    config.append(this.proxyConfig(new ProxyNetInfo("", new NetInterface("", proxyIp, "", "", false), this.getBrowser(), proxyHost)));
                }
            }
            config.append("\n\t}\n");
        }
        config.append("}");
        this.getDrbdResource().setCommited(true);
        return config.toString();
    }

    @Override
    public boolean selectAutomaticallyInTreeMenu() {
        return this.infoPanel == null;
    }

    @Override
    public JPanel getGraphicalView() {
        return this.getBrowser().getDrbdGraph().getGraphPanel();
    }

    @Override
    public String[] getParametersFromXML() {
        return this.getEnabledSectionParams(this.getBrowser().getDrbdXML().getParameters());
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        if ("resync-after".equals(param) || "after".equals(param)) {
            return true;
        }
        return this.getBrowser().getDrbdXML().checkParam(param, newValue);
    }

    @Override
    public String getParamDefault(String param) {
        String common = this.getDrbdInfo().getParamSaved(param);
        if (common != null) {
            return common;
        }
        return this.getBrowser().getDrbdXML().getParamDefault(param);
    }

    @Override
    protected String getSection(String param) {
        return this.getBrowser().getDrbdXML().getSection(param);
    }

    @Override
    protected String isEnabled(String param) {
        if (this.getDrbdResource().isCommited() && DRBD_RES_PARAM_NAME.equals(param)) {
            return "";
        }
        return null;
    }

    @Override
    protected Widget createWidget(String param, String prefix, int width) {
        Widget paramWi;
        if (DRBD_RES_PARAM_NAME.equals(param)) {
            String resName = this.getParamSaved(DRBD_RES_PARAM_NAME) == null ? this.getResource().getDefaultValue(DRBD_RES_PARAM_NAME) : this.getResource().getName();
            paramWi = WidgetFactory.createInstance(Widget.GUESS_TYPE, resName, Widget.NO_ITEMS, "^\\S+$", width, Widget.NO_ABBRV, new AccessMode(this.getAccessType(param), this.isEnabledOnlyInAdvancedMode(param)), Widget.NO_BUTTON);
            paramWi.setEnabled(!this.getDrbdResource().isCommited());
            this.widgetAdd(param, prefix, paramWi);
        } else if ("resync-after".equals(param) || "after".equals(param)) {
            ArrayList<Info> l = new ArrayList<Info>();
            String defaultItem = this.getParamSaved(param);
            StringInfo di = new StringInfo(Tools.getString("ClusterBrowser.None"), "-1", this.getBrowser());
            l.add(di);
            Map<String, DrbdResourceInfo> drbdResHash = this.getBrowser().getDrbdResHash();
            for (String drbdRes : drbdResHash.keySet()) {
                DrbdResourceInfo r;
                DrbdResourceInfo odri = r = drbdResHash.get(drbdRes);
                boolean cyclicRef = false;
                while ((odri = drbdResHash.get(odri.getParamSaved(param))) != null) {
                    if (odri != this) continue;
                    cyclicRef = true;
                }
                if (r == this || cyclicRef) continue;
                l.add(r);
            }
            this.getBrowser().putDrbdResHash();
            paramWi = this.resyncAfterParamWi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, defaultItem, l.toArray(new Info[l.size()]), Widget.NO_REGEXP, width, Widget.NO_ABBRV, new AccessMode(this.getAccessType(param), this.isEnabledOnlyInAdvancedMode(param)), Widget.NO_BUTTON);
            this.widgetAdd(param, prefix, paramWi);
        } else {
            paramWi = super.createWidget(param, prefix, width);
        }
        return paramWi;
    }

    DrbdResource getDrbdResource() {
        return (DrbdResource)this.getResource();
    }

    public void apply(boolean testOnly) {
        if (!testOnly) {
            String[] params = this.getParametersFromXML();
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DrbdResourceInfo.this.getApplyButton().setEnabled(false);
                    DrbdResourceInfo.this.getRevertButton().setEnabled(false);
                }
            });
            this.getInfoPanel();
            this.waitForInfoPanel();
            this.getBrowser().getDrbdResHash().remove(this.getName());
            this.getBrowser().putDrbdResHash();
            this.storeComboBoxValues(params);
            String name = this.getParamSaved(DRBD_RES_PARAM_NAME);
            this.getDrbdResource().setName(name);
            this.setName(name);
            this.getBrowser().getDrbdResHash().put(name, this);
            this.getBrowser().putDrbdResHash();
            this.getBrowser().getDrbdGraph().repaint();
            this.getDrbdInfo().setAllApplyButtons();
            this.getDrbdInfo().reloadDRBDResourceComboBoxes();
            this.getResource().setNew(false);
        }
    }

    void setAllApplyButtons() {
        for (DrbdVolumeInfo dvi : this.drbdVolumes) {
            dvi.setAllApplyButtons();
        }
        this.setApplyButtons(null, this.getParametersFromXML());
    }

    @Override
    public JComponent getInfoPanel() {
        if (this.infoPanel != null) {
            return this.infoPanel;
        }
        ButtonCallback buttonCallback = new ButtonCallback(){
            private volatile boolean mouseStillOver = false;

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void mouseOut() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = false;
                DrbdResourceInfo.this.getBrowser().getDrbdGraph().stopTestAnimation(DrbdResourceInfo.this.getApplyButton());
                DrbdResourceInfo.this.getApplyButton().setToolTipText(null);
            }

            @Override
            public void mouseOver() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = true;
                DrbdResourceInfo.this.getApplyButton().setToolTipText(Tools.getString("ClusterBrowser.StartingDRBDtest"));
                DrbdResourceInfo.this.getApplyButton().setToolTipBackground(Tools.getDefaultColor("ClusterBrowser.Test.Tooltip.Background"));
                Tools.sleep(250);
                if (!this.mouseStillOver) {
                    return;
                }
                this.mouseStillOver = false;
                CountDownLatch startTestLatch = new CountDownLatch(1);
                DrbdResourceInfo.this.getBrowser().getDrbdGraph().startTestAnimation(DrbdResourceInfo.this.getApplyButton(), startTestLatch);
                DrbdResourceInfo.this.getBrowser().drbdtestLockAcquire();
                DrbdResourceInfo.this.getBrowser().setDRBDtestData(null);
                LinkedHashMap<Host, String> testOutput = new LinkedHashMap<Host, String>();
                try {
                    DrbdResourceInfo.this.getDrbdInfo().createDrbdConfig(true);
                    for (Host h : DrbdResourceInfo.this.getHosts()) {
                        DRBD.adjust(h, "all", null, true);
                        testOutput.put(h, DRBD.getDRBDtest());
                    }
                }
                catch (Exceptions.DrbdConfigException dce) {
                    DrbdResourceInfo.this.getBrowser().drbdtestLockRelease();
                    return;
                }
                DRBDtestData dtd = new DRBDtestData(testOutput);
                DrbdResourceInfo.this.getApplyButton().setToolTipText(dtd.getToolTip());
                DrbdResourceInfo.this.getBrowser().setDRBDtestData(dtd);
                DrbdResourceInfo.this.getBrowser().drbdtestLockRelease();
                startTestLatch.countDown();
            }
        };
        this.initApplyButton(buttonCallback, Tools.getString("Browser.ApplyDRBDResource"));
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, 50));
        buttonPanel.setPreferredSize(new Dimension(0, 50));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentX(0.0f);
        mainPanel.add(buttonPanel);
        buttonPanel.add((Component)this.getActionsButton(), "East");
        this.getResource().setValue(DRBD_RES_PARAM_NAME, this.getDrbdResource().getName());
        String[] params = this.getParametersFromXML();
        this.addHostAddresses(optionsPanel, ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH, false, this.getApplyButton());
        this.enableSection(SECTION_PROXY, false, false);
        this.addParams(optionsPanel, params, Tools.getDefaultSize("ClusterBrowser.DrbdResLabelWidth"), Tools.getDefaultSize("ClusterBrowser.DrbdResFieldWidth"), null);
        this.getApplyButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Tools.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                DrbdResourceInfo.this.getApplyButton().setEnabled(false);
                                DrbdResourceInfo.this.getRevertButton().setEnabled(false);
                            }
                        });
                        DrbdResourceInfo.this.getBrowser().drbdStatusLock();
                        try {
                            DrbdResourceInfo.this.getDrbdInfo().createDrbdConfig(false);
                            for (Host h : DrbdResourceInfo.this.getHosts()) {
                                DRBD.adjust(h, "all", null, false);
                            }
                        }
                        catch (Exceptions.DrbdConfigException dce) {
                            DrbdResourceInfo.this.getBrowser().drbdStatusUnlock();
                            Tools.appError("config failed");
                            return;
                        }
                        DrbdResourceInfo.this.apply(false);
                        DrbdResourceInfo.this.getBrowser().drbdStatusUnlock();
                    }
                });
                thread.start();
            }
        });
        this.getRevertButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        DrbdResourceInfo.this.getBrowser().drbdStatusLock();
                        DrbdResourceInfo.this.revert();
                        DrbdResourceInfo.this.getBrowser().drbdStatusUnlock();
                    }
                });
                thread.start();
            }
        });
        this.addApplyButton(buttonPanel);
        this.addRevertButton(buttonPanel);
        mainPanel.add(optionsPanel);
        JPanel newPanel = new JPanel();
        newPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(buttonPanel);
        newPanel.add(this.getMoreOptionsPanel(Tools.getDefaultSize("ClusterBrowser.DrbdResLabelWidth") + Tools.getDefaultSize("ClusterBrowser.DrbdResFieldWidth") + 4));
        newPanel.add(new JScrollPane(mainPanel));
        this.infoPanel = newPanel;
        this.setProxyPanels(false);
        this.infoPanelDone();
        return this.infoPanel;
    }

    public void removeFromHashes() {
        this.getBrowser().getDrbdResHash().remove(this.getName());
        this.getBrowser().putDrbdResHash();
        for (DrbdVolumeInfo dvi : this.drbdVolumes) {
            this.removeDrbdVolumeFromHashes(dvi);
        }
    }

    public void removeDrbdVolumeFromHashes(DrbdVolumeInfo drbdVolume) {
        this.getBrowser().getDrbdDevHash().remove(drbdVolume.getDevice());
        this.getBrowser().putDrbdDevHash();
        for (BlockDevInfo bdi : drbdVolume.getBlockDevInfos()) {
            bdi.removeFromDrbd();
        }
    }

    @Override
    public String toString() {
        String name = this.getName();
        if (name == null || "".equals(name)) {
            name = Tools.getString("ClusterBrowser.DrbdResUnconfigured");
        }
        return "drbd: " + name;
    }

    public boolean equals(Object value) {
        if (value == null) {
            return false;
        }
        if (this.toString() == null) {
            return false;
        }
        return this.toString().equals(value.toString());
    }

    public StringInfo[] getCommonFileSystems(String defaultValue) {
        return this.getBrowser().getCommonFileSystems(defaultValue);
    }

    boolean resourceInHost(Host host) {
        for (DrbdVolumeInfo dvi : this.drbdVolumes) {
            for (BlockDevInfo bdi : dvi.getBlockDevInfos()) {
                if (bdi.getHost() != host) continue;
                return true;
            }
        }
        return false;
    }

    public void setHaveToCreateMD(boolean haveToCreateMD) {
        this.haveToCreateMD = haveToCreateMD;
    }

    public boolean isHaveToCreateMD() {
        return this.haveToCreateMD;
    }

    private void setNetworkParameters(DrbdXML dxml) {
        String hostPort = null;
        boolean infoPanelOk = this.infoPanel != null;
        for (Host host : this.getHosts()) {
            Widget wi;
            String hostAddress = dxml.getVirtualInterface(host.getName(), this.getName());
            String hp = dxml.getVirtualInterfacePort(host.getName(), this.getName());
            if (hostPort != null && !hostPort.equals(hp)) {
                Tools.appWarning("more ports in " + this.getName() + " " + hp + " " + hostPort);
            }
            hostPort = hp;
            String savedAddress = this.savedHostAddresses.get(host);
            if (Tools.areEqual(hostAddress, savedAddress)) continue;
            if (hostAddress == null) {
                this.savedHostAddresses.remove(host);
            } else {
                this.savedHostAddresses.put(host, hostAddress);
            }
            if (!infoPanelOk || (wi = this.addressComboBoxHash.get(host)) == null) continue;
            wi.setValue(hostAddress);
        }
        if (!Tools.areEqual(hostPort, this.savedPort)) {
            Widget wi;
            this.savedPort = hostPort;
            for (Host host : this.getHosts()) {
                host.getBrowser().getUsedPorts().add(this.savedPort);
            }
            if (infoPanelOk && (wi = this.portComboBox) != null) {
                if (hostPort == null) {
                    wi.setValue(Widget.NOTHING_SELECTED_DISPLAY);
                } else {
                    wi.setValue(hostPort);
                }
            }
        }
    }

    private void setProxyParameters(DrbdXML dxml) {
        Widget wi;
        String hostInsidePort = null;
        String hostOutsidePort = null;
        boolean infoPanelOk = this.infoPanel != null;
        Set<Host> configuredProxyHosts = this.getConfiguredProxyHosts();
        for (Host host : this.getHosts()) {
            Widget wi2;
            String savedOutsideIp;
            Host proxyHost;
            DrbdXML.HostProxy hostProxy = dxml.getHostProxy(host.getName(), this.getName());
            String insideIp = null;
            String outsideIp = null;
            String insidePort = null;
            String outsidePort = null;
            if (hostProxy != null) {
                insideIp = hostProxy.getInsideIp();
                outsideIp = hostProxy.getOutsideIp();
                insidePort = hostProxy.getInsidePort();
                outsidePort = hostProxy.getOutsidePort();
                proxyHost = this.getCluster().getProxyHostByName(hostProxy.getProxyHostName());
            } else {
                proxyHost = host;
            }
            if (insidePort != null && hostInsidePort != null && !insidePort.equals(hostInsidePort)) {
                Tools.appWarning("multiple proxy inside ports in " + this.getName() + " " + insidePort + " " + hostInsidePort);
            }
            hostInsidePort = insidePort;
            if (outsidePort != null && hostOutsidePort != null && !outsidePort.equals(hostOutsidePort)) {
                Tools.appWarning("multiple proxy outside ports in " + this.getName() + " " + outsidePort + " " + hostOutsidePort);
            }
            hostOutsidePort = outsidePort;
            String savedInsideIp = this.savedInsideIps.get(proxyHost);
            if (!Tools.areEqual(insideIp, savedInsideIp)) {
                Widget wi3;
                if (insideIp == null) {
                    this.savedInsideIps.remove(proxyHost);
                } else {
                    this.savedInsideIps.put(proxyHost, insideIp);
                }
                if (infoPanelOk && (wi3 = this.insideIpComboBoxHash.get(proxyHost)) != null) {
                    wi3.setValue(insideIp);
                }
            }
            if (Tools.areEqual(outsideIp, savedOutsideIp = this.savedOutsideIps.get(proxyHost))) continue;
            if (outsideIp == null) {
                this.savedOutsideIps.remove(proxyHost);
            } else {
                this.savedOutsideIps.put(proxyHost, outsideIp);
            }
            if (!infoPanelOk || (wi2 = this.outsideIpComboBoxHash.get(proxyHost)) == null) continue;
            wi2.setValue(outsideIp);
        }
        if (!Tools.areEqual(hostInsidePort, this.savedInsidePort)) {
            this.savedInsidePort = hostInsidePort;
            for (Host host : this.getHosts()) {
                host.getBrowser().getUsedPorts().add(hostInsidePort);
            }
            if (infoPanelOk && (wi = this.insidePortComboBox) != null) {
                if (hostInsidePort == null) {
                    wi.setValue(Widget.NOTHING_SELECTED_DISPLAY);
                } else {
                    wi.setValue(hostInsidePort);
                }
            }
        }
        if (!Tools.areEqual(hostOutsidePort, this.savedOutsidePort)) {
            this.savedOutsidePort = hostOutsidePort;
            for (Host host : configuredProxyHosts) {
                host.getBrowser().getUsedProxyPorts().add(hostOutsidePort);
            }
            if (infoPanelOk && (wi = this.outsidePortComboBox) != null) {
                if (hostOutsidePort == null) {
                    wi.setValue(Widget.NOTHING_SELECTED_DISPLAY);
                } else {
                    wi.setValue(hostOutsidePort);
                }
            }
        }
    }

    public void setParameters() {
        this.getDrbdResource().setCommited(true);
        DrbdXML dxml = this.getBrowser().getDrbdXML();
        String resName = this.getResource().getName();
        for (String sectionString : dxml.getSections()) {
            String section = sectionString.replaceAll("-options$", "");
            for (String param : dxml.getSectionParams(section)) {
                String value = dxml.getConfigValue(resName, section, param);
                String defaultValue = this.getParamDefault(param);
                String oldValue = this.getParamSaved(param);
                if ("".equals(value)) {
                    value = defaultValue;
                }
                Widget wi = this.getWidget(param, null);
                if (Tools.areEqual(value, oldValue)) continue;
                this.getResource().setValue(param, value);
                if (wi == null) continue;
                wi.setValue(value);
            }
        }
        this.setNetworkParameters(dxml);
        this.setProxyParameters(dxml);
    }

    @Override
    public boolean checkResourceFieldsChanged(String param, String[] params) {
        return this.checkResourceFieldsChanged(param, params, false);
    }

    boolean checkResourceFieldsChanged(String param, String[] params, boolean fromDrbdInfo) {
        boolean changed = false;
        for (DrbdVolumeInfo dvi : this.drbdVolumes) {
            if (!dvi.checkResourceFieldsChanged(param, dvi.getParametersFromXML(), fromDrbdInfo, true)) continue;
            changed = true;
        }
        if (this.checkHostAddressesFieldsChanged()) {
            changed = true;
        }
        if (this.isSectionEnabled(SECTION_PROXY) && this.checkProxyFieldsChanged()) {
            changed = true;
        }
        return super.checkResourceFieldsChanged(param, params) || changed;
    }

    @Override
    public boolean checkResourceFieldsCorrect(String param, String[] params) {
        return this.checkResourceFieldsCorrect(param, params, false);
    }

    private boolean checkPort(String port) {
        if (!Tools.isNumber(port)) {
            return false;
        }
        long p = Long.parseLong(port);
        return p >= 0L && p < 65536L;
    }

    private boolean checkPortCorrect() {
        String port = this.portComboBox.getStringValue();
        Widget pwi = this.portComboBox;
        Widget pwizardWi = this.portComboBoxWizard;
        boolean correct = true;
        if (this.checkPort(port)) {
            pwi.setBackground(null, this.savedPort, true);
            if (pwizardWi != null) {
                pwizardWi.setBackground(null, this.savedPort, true);
            }
        } else {
            correct = false;
            pwi.wrongValue();
            if (pwizardWi != null) {
                pwizardWi.wrongValue();
            }
        }
        return correct;
    }

    private boolean checkAddressCorrect() {
        HashMap<Host, Widget> addressComboBoxHashClone = new HashMap<Host, Widget>(this.addressComboBoxHash);
        boolean correct = true;
        for (Host host : addressComboBoxHashClone.keySet()) {
            Widget wi = (Widget)addressComboBoxHashClone.get(host);
            Widget wizardWi = this.addressComboBoxHashWizard.get(host);
            if (wi.getValue() == null) {
                correct = false;
                wi.wrongValue();
                if (wizardWi == null) continue;
                wizardWi.wrongValue();
                continue;
            }
            wi.setBackground(null, this.savedHostAddresses.get(host), true);
            if (wizardWi == null) continue;
            wizardWi.setBackground(null, this.savedHostAddresses.get(host), true);
        }
        return correct;
    }

    private boolean checkProxyPortCorrect(Widget pwi, Widget pWizardWi, String savedPort) {
        String port = pwi.getStringValue();
        boolean correct = true;
        if (this.checkPort(port)) {
            pwi.setBackground(null, savedPort, true);
            if (pWizardWi != null) {
                pWizardWi.setBackground(null, savedPort, true);
            }
        } else {
            correct = false;
            pwi.wrongValue();
            if (pWizardWi != null) {
                pWizardWi.wrongValue();
            }
        }
        return correct;
    }

    private boolean checkProxyInsideIpCorrect() {
        HashMap<Host, Widget> insideIpComboBoxHashClone = new HashMap<Host, Widget>(this.insideIpComboBoxHash);
        boolean correct = true;
        DrbdXML dxml = this.getBrowser().getDrbdXML();
        for (Host host : this.getHosts()) {
            Host proxyHost = this.getProxyHost(host, false);
            if (proxyHost == null) continue;
            Widget wi = (Widget)insideIpComboBoxHashClone.get(proxyHost);
            Widget wizardWi = this.insideIpComboBoxHashWizard.get(proxyHost);
            if (wi.getValue() == null) {
                correct = false;
                wi.wrongValue();
                if (wizardWi == null) continue;
                wizardWi.wrongValue();
                continue;
            }
            String defaultInsideIp = this.getDefaultInsideIp(proxyHost);
            String savedInsideIp = this.savedInsideIps.get(proxyHost);
            if (savedInsideIp == null) {
                savedInsideIp = defaultInsideIp;
            }
            wi.setBackground(defaultInsideIp, savedInsideIp, true);
            if (wizardWi == null) continue;
            wizardWi.setBackground(defaultInsideIp, savedInsideIp, true);
        }
        return correct;
    }

    private boolean checkProxyOutsideIpCorrect() {
        HashMap<Host, Widget> outsideIpComboBoxHashClone = new HashMap<Host, Widget>(this.outsideIpComboBoxHash);
        boolean correct = true;
        DrbdXML dxml = this.getBrowser().getDrbdXML();
        for (Host host : this.getHosts()) {
            Host proxyHost = this.getProxyHost(host, false);
            if (proxyHost == null) continue;
            Widget wi = (Widget)outsideIpComboBoxHashClone.get(proxyHost);
            Widget wizardWi = this.outsideIpComboBoxHashWizard.get(proxyHost);
            if (wi.getValue() == null) {
                correct = false;
                wi.wrongValue();
                if (wizardWi == null) continue;
                wizardWi.wrongValue();
                continue;
            }
            wi.setBackground(null, this.savedOutsideIps.get(proxyHost), true);
            if (wizardWi == null) continue;
            wizardWi.setBackground(null, this.savedOutsideIps.get(proxyHost), true);
        }
        return correct;
    }

    boolean checkResourceFieldsCorrect(String param, String[] params, boolean fromDrbdInfo) {
        DrbdInfo di = this.getDrbdInfo();
        boolean correct = true;
        DrbdXML dxml = this.getBrowser().getDrbdXML();
        if (dxml != null && dxml.isDrbdDisabled()) {
            correct = false;
        }
        for (DrbdVolumeInfo dvi : this.drbdVolumes) {
            if (dvi.checkResourceFieldsCorrect(param, dvi.getParametersFromXML(), fromDrbdInfo, true)) continue;
            correct = false;
        }
        if (!this.checkPortCorrect()) {
            correct = false;
        }
        if (!this.checkAddressCorrect()) {
            correct = false;
        }
        if (this.isSectionEnabled(SECTION_PROXY)) {
            if (!this.checkProxyPortCorrect(this.insidePortComboBox, this.insidePortComboBoxWizard, this.savedInsidePort)) {
                correct = false;
            }
            if (!this.checkProxyPortCorrect(this.outsidePortComboBox, this.outsidePortComboBoxWizard, this.savedOutsidePort)) {
                correct = false;
            }
            if (!this.checkProxyInsideIpCorrect()) {
                correct = false;
            }
            if (!this.checkProxyOutsideIpCorrect()) {
                correct = false;
            }
        }
        return super.checkResourceFieldsCorrect(param, params) && correct;
    }

    @Override
    public void revert() {
        super.revert();
        for (DrbdVolumeInfo dvi : this.drbdVolumes) {
            for (BlockDevInfo bdi : dvi.getBlockDevInfos()) {
                if (bdi == null) continue;
                bdi.revert();
            }
        }
        HashMap<Host, Widget> addressComboBoxHashClone = new HashMap<Host, Widget>(this.addressComboBoxHash);
        for (Host host : addressComboBoxHashClone.keySet()) {
            Widget wi = (Widget)addressComboBoxHashClone.get(host);
            String haSaved = this.savedHostAddresses.get(host);
            if (Tools.areEqual(wi.getValue(), haSaved)) continue;
            Widget wizardWi = this.addressComboBoxHashWizard.get(host);
            if (wizardWi == null) {
                wi.setValue(haSaved);
                continue;
            }
            wizardWi.setValue(haSaved);
        }
        Widget pwi = this.portComboBox;
        if (!pwi.getStringValue().equals(this.savedPort)) {
            Widget wizardWi = this.portComboBoxWizard;
            if (wizardWi == null) {
                pwi.setValue(this.savedPort);
            } else {
                wizardWi.setValue(this.savedPort);
            }
        }
        HashMap<Host, Widget> insideIpComboBoxHashClone = new HashMap<Host, Widget>(this.insideIpComboBoxHash);
        for (Host host : insideIpComboBoxHashClone.keySet()) {
            Widget wi = (Widget)insideIpComboBoxHashClone.get(host);
            String ipSaved = this.savedInsideIps.get(host);
            if (ipSaved == null) {
                ipSaved = this.getDefaultInsideIp(host);
            }
            if (Tools.areEqual(wi.getValue(), ipSaved)) continue;
            Widget wizardWi = this.insideIpComboBoxHashWizard.get(host);
            if (wizardWi == null) {
                wi.setValue(ipSaved);
                continue;
            }
            wizardWi.setValue(ipSaved);
        }
        Widget ipwi = this.insidePortComboBox;
        if (!ipwi.getStringValue().equals(this.savedInsidePort)) {
            Widget wizardWi = this.insidePortComboBoxWizard;
            if (wizardWi == null) {
                ipwi.setValue(this.savedInsidePort);
            } else {
                wizardWi.setValue(this.savedInsidePort);
            }
        }
        HashMap<Host, Widget> outsideIpComboBoxHashClone = new HashMap<Host, Widget>(this.outsideIpComboBoxHash);
        for (Host host : outsideIpComboBoxHashClone.keySet()) {
            Widget wi = (Widget)outsideIpComboBoxHashClone.get(host);
            String ipSaved = this.savedOutsideIps.get(host);
            if (Tools.areEqual(wi.getValue(), ipSaved)) continue;
            Widget wizardWi = this.outsideIpComboBoxHashWizard.get(host);
            if (wizardWi == null) {
                wi.setValue(ipSaved);
                continue;
            }
            wizardWi.setValue(ipSaved);
        }
        Widget opwi = this.outsidePortComboBox;
        if (!opwi.getStringValue().equals(this.savedOutsidePort)) {
            Widget wizardWi = this.outsidePortComboBoxWizard;
            if (wizardWi == null) {
                opwi.setValue(this.savedOutsidePort);
            } else {
                wizardWi.setValue(this.savedOutsidePort);
            }
        }
    }

    @Override
    public void setDialogStarted(boolean dialogStarted) {
        for (DrbdVolumeInfo dvi : this.drbdVolumes) {
            for (BlockDevInfo bdi : dvi.getBlockDevInfos()) {
                if (bdi == null) continue;
                bdi.setDialogStarted(dialogStarted);
            }
        }
        super.setDialogStarted(dialogStarted);
    }

    String getVolumeNr(BlockDevInfo thisBDI) {
        for (DrbdVolumeInfo dvi : this.drbdVolumes) {
            for (BlockDevInfo bdi : dvi.getBlockDevInfos()) {
                if (bdi != thisBDI) continue;
                return dvi.getName();
            }
        }
        Tools.appWarning("could not get volume nr for: " + thisBDI.getName());
        return null;
    }

    public void updateAllVolumes() {
        for (DrbdVolumeInfo dvi : this.drbdVolumes) {
            for (BlockDevInfo bdi : dvi.getBlockDevInfos()) {
                if (bdi == null) continue;
                bdi.checkResourceFieldsChanged(null, bdi.getParametersFromXML());
                bdi.updateAdvancedPanels();
            }
        }
    }

    public String getAvailVolumeNumber() {
        int maxNr = -1;
        for (DrbdVolumeInfo dvi : this.drbdVolumes) {
            int nr;
            String nrString = dvi.getName();
            if (!Tools.isNumber(nrString) || (nr = Integer.parseInt(nrString)) <= maxNr) continue;
            maxNr = nr;
        }
        return Integer.toString(maxNr + 1);
    }

    public void addHostAddresses(JPanel optionsPanel, int leftWidth, int rightWidth, boolean wizard, MyButton thisApplyButton) {
        int defaultPortInt;
        Widget wi;
        int rows = 0;
        HashMap<Host, Widget> newAddressComboBoxHash = new HashMap<Host, Widget>();
        HashMap<Host, Widget> newInsideIpComboBoxHash = new HashMap<Host, Widget>();
        HashMap<Host, Widget> newOutsideIpComboBoxHash = new HashMap<Host, Widget>();
        JPanel panel = this.getParamPanel(Tools.getString("DrbdResourceInfo.HostAddresses"));
        panel.setLayout(new SpringLayout());
        for (Host host : this.getHosts()) {
            wi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, Widget.NO_DEFAULT, this.getNetInterfacesWithProxies(host.getBrowser()), Widget.NO_REGEXP, rightWidth, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
            String haSaved = this.savedHostAddresses.get(host);
            wi.setValueAndWait(haSaved);
            newAddressComboBoxHash.put(host, wi);
        }
        for (Host host : this.getHosts()) {
            wi = (Widget)newAddressComboBoxHash.get(host);
            String addr = Tools.getString("DrbdResourceInfo.AddressOnHost") + host.getName();
            JLabel label = new JLabel(addr);
            wi.setLabel(label, addr);
            this.addField(panel, label, wi, leftWidth, rightWidth, 0);
            wi.setToolTipText(this.getToolTipText(null, wi));
            ++rows;
        }
        String defaultPort = this.savedPort;
        if (defaultPort == null) {
            defaultPortInt = this.getLowestUnusedPort();
            defaultPort = Integer.toString(defaultPortInt);
        } else {
            defaultPortInt = Integer.parseInt(defaultPort);
        }
        List<String> drbdPorts = this.getPossibleDrbdPorts(defaultPortInt);
        Widget pwi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, defaultPort, drbdPorts.toArray(new String[drbdPorts.size()]), "^\\d*$", leftWidth, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
        pwi.setAlwaysEditable(true);
        String port = Tools.getString("DrbdResourceInfo.NetInterfacePort");
        JLabel label = new JLabel(port);
        this.addField(panel, label, pwi, leftWidth, rightWidth, 0);
        pwi.setLabel(label, port);
        if (wizard) {
            this.portComboBoxWizard = pwi;
            this.portComboBox.setValueAndWait(defaultPort);
        } else {
            this.portComboBox = pwi;
        }
        SpringUtilities.makeCompactGrid(panel, ++rows, 2, 1, 1, 1, 1);
        optionsPanel.add(panel);
        this.addProxyPorts(optionsPanel, leftWidth, rightWidth, wizard);
        this.addProxyIps(optionsPanel, leftWidth, rightWidth, wizard, newInsideIpComboBoxHash, newOutsideIpComboBoxHash);
        this.addHostAddressListener(wizard, thisApplyButton, newAddressComboBoxHash, this.addressComboBoxHash);
        this.addPortListeners(wizard, thisApplyButton, this.portComboBoxWizard, this.portComboBox);
        this.addPortListeners(wizard, thisApplyButton, this.insidePortComboBoxWizard, this.insidePortComboBox);
        this.addPortListeners(wizard, thisApplyButton, this.outsidePortComboBoxWizard, this.outsidePortComboBox);
        this.addIpListeners(wizard, thisApplyButton, newInsideIpComboBoxHash, this.insideIpComboBoxHash);
        this.addIpListeners(wizard, thisApplyButton, newOutsideIpComboBoxHash, this.outsideIpComboBoxHash);
        if (wizard) {
            this.addressComboBoxHashWizard = newAddressComboBoxHash;
            this.insideIpComboBoxHashWizard = newInsideIpComboBoxHash;
            this.outsideIpComboBoxHashWizard = newOutsideIpComboBoxHash;
        } else {
            this.addressComboBoxHash = newAddressComboBoxHash;
            this.insideIpComboBoxHash = newInsideIpComboBoxHash;
            this.outsideIpComboBoxHash = newOutsideIpComboBoxHash;
        }
    }

    private void addProxyPorts(JPanel optionsPanel, int leftWidth, int rightWidth, boolean wizard) {
        int outsideDefaultPortInt;
        int rows = 0;
        JPanel panel = this.getParamPanel(SECTION_PROXY_PORTS);
        this.addSectionPanel(SECTION_PROXY_PORTS, wizard, panel);
        this.enableSection(SECTION_PROXY_PORTS, false, wizard);
        panel.setLayout(new SpringLayout());
        panel.setBackground(AppDefaults.LIGHT_ORANGE);
        int insideDefaultPortInt = this.getDefaultInsidePort();
        String insideDefaultPort = Integer.toString(insideDefaultPortInt);
        List<String> insideDrbdPorts = this.getPossibleDrbdPorts(insideDefaultPortInt);
        Widget insidePortWi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, insideDefaultPort, insideDrbdPorts.toArray(new String[insideDrbdPorts.size()]), "^\\d*$", leftWidth, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
        insidePortWi.setAlwaysEditable(true);
        JLabel insidePortLabel = new JLabel(Tools.getString("DrbdResourceInfo.ProxyInsidePort"));
        insidePortWi.setLabel(insidePortLabel, Tools.getString("DrbdResourceInfo.ProxyInsidePort.ToolTip"));
        this.addField(panel, insidePortLabel, insidePortWi, leftWidth, rightWidth, 0);
        if (wizard) {
            this.insidePortComboBoxWizard = insidePortWi;
        } else {
            this.insidePortComboBox = insidePortWi;
        }
        ++rows;
        String outsideDefaultPort = this.savedOutsidePort;
        if (outsideDefaultPort == null) {
            outsideDefaultPortInt = this.getLowestUnusedProxyPort();
            if (outsideDefaultPortInt < insideDefaultPortInt - 1) {
                outsideDefaultPortInt = insideDefaultPortInt - 1;
            }
            outsideDefaultPort = Integer.toString(outsideDefaultPortInt);
        } else {
            outsideDefaultPortInt = Integer.parseInt(outsideDefaultPort);
        }
        List<String> outsideDrbdPorts = this.getPossibleDrbdPorts(outsideDefaultPortInt);
        Widget outsidePortWi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, outsideDefaultPort, outsideDrbdPorts.toArray(new String[outsideDrbdPorts.size()]), "^\\d*$", leftWidth, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
        outsidePortWi.setAlwaysEditable(true);
        JLabel outsidePortLabel = new JLabel(Tools.getString("DrbdResourceInfo.ProxyOutsidePort"));
        outsidePortWi.setLabel(outsidePortLabel, Tools.getString("DrbdResourceInfo.ProxyOutsidePort.ToolTip"));
        this.addField(panel, outsidePortLabel, outsidePortWi, leftWidth, rightWidth, 0);
        if (wizard) {
            this.outsidePortComboBoxWizard = outsidePortWi;
        } else {
            this.outsidePortComboBox = outsidePortWi;
        }
        SpringUtilities.makeCompactGrid(panel, ++rows, 2, 1, 1, 1, 1);
        optionsPanel.add(panel);
    }

    private void addProxyIps(JPanel optionsPanel, int leftWidth, int rightWidth, boolean wizard, Map<Host, Widget> newInsideIpComboBoxHash, Map<Host, Widget> newOutsideIpComboBoxHash) {
        Widget iIpWi;
        DrbdXML.HostProxy hostProxy;
        DrbdXML dxml = this.getBrowser().getDrbdXML();
        for (Host pHost : new HashSet<Host>(this.getCluster().getProxyHosts())) {
            hostProxy = dxml.getHostProxy(pHost.getName(), this.getName());
            String section = Tools.getString("DrbdResourceInfo.Proxy") + pHost.getName();
            JPanel sectionPanel = this.getParamPanel(section);
            this.addSectionPanel(section, wizard, sectionPanel);
            this.enableSection(section, false, wizard);
            sectionPanel.setBackground(AppDefaults.LIGHT_ORANGE);
            Object[] proxyNetInterfaces = this.getNetInterfaces(pHost.getBrowser());
            if (proxyNetInterfaces == null) {
                // empty if block
            }
            iIpWi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, Widget.NO_DEFAULT, proxyNetInterfaces, Widget.NO_REGEXP, rightWidth, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
            iIpWi.setAlwaysEditable(!pHost.isConnected());
            newInsideIpComboBoxHash.put(pHost, iIpWi);
            JLabel insideIpLabel = new JLabel(Tools.getString("DrbdResourceInfo.ProxyInsideIp"));
            iIpWi.setLabel(insideIpLabel, Tools.getString("DrbdResourceInfo.ProxyInsideIp.ToolTip"));
            JPanel panel = new JPanel();
            this.addField(panel, insideIpLabel, iIpWi, leftWidth, rightWidth, 0);
            panel.setBackground(AppDefaults.LIGHT_ORANGE);
            panel.setLayout(new SpringLayout());
            sectionPanel.add(panel);
            Widget oIpWi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, Widget.NO_DEFAULT, proxyNetInterfaces, Widget.NO_REGEXP, rightWidth, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
            oIpWi.setAlwaysEditable(!pHost.isConnected());
            newOutsideIpComboBoxHash.put(pHost, oIpWi);
            JLabel outsideIpLabel = new JLabel(Tools.getString("DrbdResourceInfo.ProxyOutsideIp"));
            oIpWi.setLabel(outsideIpLabel, Tools.getString("DrbdResourceInfo.ProxyOutsideIp.ToolTip"));
            this.addField(panel, outsideIpLabel, oIpWi, leftWidth, rightWidth, 0);
            SpringUtilities.makeCompactGrid(panel, 2, 2, 1, 1, 1, 1);
            optionsPanel.add(sectionPanel);
        }
        for (Host host : this.getHosts()) {
            Host proxyHost;
            hostProxy = dxml.getHostProxy(host.getName(), this.getName());
            String insideIpSaved = null;
            String outsideIpSaved = null;
            if (hostProxy != null) {
                insideIpSaved = hostProxy.getInsideIp();
                outsideIpSaved = hostProxy.getOutsideIp();
                proxyHost = this.getCluster().getProxyHostByName(hostProxy.getProxyHostName());
            } else {
                proxyHost = host;
            }
            iIpWi = newInsideIpComboBoxHash.get(proxyHost);
            iIpWi.setValueAndWait(insideIpSaved);
            iIpWi.setToolTipText(this.getToolTipText(null, iIpWi));
            Widget oIpWi = newOutsideIpComboBoxHash.get(proxyHost);
            oIpWi.setValueAndWait(outsideIpSaved);
            oIpWi.setToolTipText(this.getToolTipText(null, oIpWi));
        }
    }

    private Object[] getNetInterfaces(HostBrowser hostBrowser) {
        ArrayList<Info> list = new ArrayList<Info>();
        list.add(null);
        Enumeration<TreeNode> e = hostBrowser.getNetInterfacesNode().children();
        while (e.hasMoreElements()) {
            Info i = (Info)((DefaultMutableTreeNode)e.nextElement()).getUserObject();
            list.add(i);
        }
        return list.toArray(new Object[list.size()]);
    }

    private Object[] getNetInterfacesWithProxies(HostBrowser hostBrowser) {
        ArrayList<Info> list = new ArrayList<Info>();
        list.add(null);
        Enumeration<TreeNode> n = hostBrowser.getNetInterfacesNode().children();
        while (n.hasMoreElements()) {
            Info i = (Info)((DefaultMutableTreeNode)n.nextElement()).getUserObject();
            list.add(i);
        }
        Enumeration<TreeNode> np = hostBrowser.getNetInterfacesNode().children();
        while (np.hasMoreElements()) {
            NetInfo i = (NetInfo)((DefaultMutableTreeNode)np.nextElement()).getUserObject();
            list.add(new ProxyNetInfo(i, hostBrowser, hostBrowser.getHost()));
        }
        for (Host h : this.getCluster().getProxyHosts()) {
            Enumeration<TreeNode> nph;
            if (h == hostBrowser.getHost() || !(nph = hostBrowser.getNetInterfacesNode().children()).hasMoreElements()) continue;
            while (nph.hasMoreElements()) {
                NetInfo i = (NetInfo)((DefaultMutableTreeNode)nph.nextElement()).getUserObject();
                if (i.isLocalHost()) continue;
                list.add(new ProxyNetInfo(i, hostBrowser, h));
            }
        }
        return list.toArray(new Object[list.size()]);
    }

    private boolean checkHostAddressesFieldsChanged() {
        boolean changed = false;
        for (Host host : this.getHosts()) {
            Object value;
            String haSaved;
            Widget wi = this.addressComboBoxHash.get(host);
            if (wi == null || Tools.areEqual(haSaved = this.savedHostAddresses.get(host), value = wi.getValue())) continue;
            changed = true;
        }
        Widget pwi = this.portComboBox;
        if (pwi != null && !Tools.areEqual(this.savedPort, pwi.getValue())) {
            changed = true;
        }
        return changed;
    }

    private boolean checkProxyFieldsChanged() {
        Object value;
        boolean changed = false;
        if (this.insidePortComboBox != null && !Tools.areEqual(this.savedInsidePort, this.insidePortComboBox.getValue())) {
            changed = true;
        }
        if (this.outsidePortComboBox != null && !Tools.areEqual(this.savedOutsidePort, this.outsidePortComboBox.getValue())) {
            changed = true;
        }
        DrbdXML dxml = this.getBrowser().getDrbdXML();
        for (Host host : this.getHosts()) {
            Widget wi;
            Host proxyHost = this.getProxyHost(host, false);
            if (proxyHost == null || (wi = this.insideIpComboBoxHash.get(proxyHost)) == null) continue;
            String ipSaved = this.savedInsideIps.get(proxyHost);
            String defaultInsideIp = this.getDefaultInsideIp(proxyHost);
            if (ipSaved == null) {
                ipSaved = defaultInsideIp;
            }
            if (Tools.areEqual(ipSaved, value = wi.getValue())) continue;
            changed = true;
        }
        for (Host host : this.getHosts()) {
            String ipSaved;
            DrbdXML.HostProxy hostProxy = dxml.getHostProxy(host.getName(), this.getName());
            Host proxyHost = hostProxy != null ? this.getCluster().getProxyHostByName(hostProxy.getProxyHostName()) : host;
            Widget wi = this.outsideIpComboBoxHash.get(proxyHost);
            if (wi == null || Tools.areEqual(ipSaved = this.savedOutsideIps.get(proxyHost), value = wi.getValue())) continue;
            changed = true;
        }
        return changed;
    }

    private void storeHostAddresses() {
        this.savedHostAddresses.clear();
        this.savedPort = this.portComboBox.getStringValue();
        for (Host host : this.getHosts()) {
            Widget wi = this.addressComboBoxHash.get(host);
            if (wi == null) continue;
            String address = this.getIp(wi.getValue());
            if (address == null || "".equals(address)) {
                this.savedHostAddresses.remove(host);
            } else {
                this.savedHostAddresses.put(host, address);
            }
            host.getBrowser().getUsedPorts().add(this.savedPort);
        }
    }

    private void storeProxyInfo() {
        String sop;
        String sip;
        this.savedInsideIps.clear();
        this.savedOutsideIps.clear();
        this.savedInsidePort = sip = this.insidePortComboBox.getStringValue();
        this.savedOutsidePort = sop = this.outsidePortComboBox.getStringValue();
        for (Host host : this.getConfiguredProxyHosts()) {
            Widget insideWi = this.insideIpComboBoxHash.get(host);
            if (insideWi != null) {
                String defaultInsideIp = this.getDefaultInsideIp(host);
                String insideIp = this.getIp(insideWi.getValue());
                if (insideIp == null) {
                    this.savedInsideIps.remove(host);
                } else {
                    this.savedInsideIps.put(host, insideIp);
                }
            }
            host.getBrowser().getUsedPorts().add(sip);
            Widget outsideWi = this.outsideIpComboBoxHash.get(host);
            if (outsideWi != null) {
                String outsideIp = this.getIp(outsideWi.getValue());
                if (outsideIp == null || "".equals(outsideIp)) {
                    this.savedOutsideIps.remove(host);
                } else {
                    this.savedOutsideIps.put(host, outsideIp);
                }
            }
            host.getBrowser().getUsedProxyPorts().add(sop);
        }
    }

    private String getNetInterfaceWithPort(String address, String port) {
        return address + ":" + port;
    }

    public void setProxyPanels(boolean wizard) {
        String portLabel;
        Widget portCB;
        Widget outsidePortCB;
        Widget insidePortCB;
        Map<Host, Widget> addressHash;
        HashSet<Host> visible = new HashSet<Host>();
        if (wizard) {
            addressHash = this.addressComboBoxHashWizard;
            insidePortCB = this.insidePortComboBoxWizard;
            outsidePortCB = this.insidePortComboBoxWizard;
            portCB = this.portComboBoxWizard;
        } else {
            addressHash = this.addressComboBoxHash;
            insidePortCB = this.insidePortComboBox;
            outsidePortCB = this.insidePortComboBox;
            portCB = this.portComboBox;
        }
        for (Host host : this.getHosts()) {
            Host proxyHost = this.getProxyHost(host, wizard);
            if (proxyHost == null) continue;
            visible.add(proxyHost);
        }
        visible.addAll(this.selectedProxyHosts);
        boolean isProxy = !visible.isEmpty();
        for (Host pHost : this.getCluster().getProxyHosts()) {
            String section = Tools.getString("DrbdResourceInfo.Proxy") + pHost.getName();
            this.enableSection(section, visible.contains(pHost), wizard);
        }
        this.enableSection(SECTION_PROXY, isProxy, wizard);
        this.enableSection(SECTION_PROXY_PORTS, isProxy, wizard);
        if (isProxy) {
            if (insidePortCB.isNew() && (this.savedInsidePort == null || "".equals(this.savedInsidePort))) {
                insidePortCB.setValue(Integer.toString(this.getDefaultInsidePort()));
            }
            if (outsidePortCB.isNew() && (this.savedOutsidePort == null || "".equals(this.savedOutsidePort))) {
                outsidePortCB.setValue(this.savedPort);
            }
            portLabel = Tools.getString("DrbdResourceInfo.NetInterfacePortToProxy");
            this.getDrbdInfo().enableProxySection(wizard);
        } else {
            portLabel = Tools.getString("DrbdResourceInfo.NetInterfacePort");
        }
        portCB.getLabel().setText(portLabel);
        Widget protocolWi = this.getWidget("protocol", "widget");
        Widget pingTimeoutWi = this.getWidget("ping-timeout", "widget");
        DrbdXML dxml = this.getBrowser().getDrbdXML();
        if (protocolWi != null && this.getResource().isNew()) {
            if (isProxy) {
                protocolWi.setValue(PROXY_DEFAULT_PROTOCOL);
                pingTimeoutWi.setValue(PROXY_DEFAULT_PING_TIMEOUT);
            } else {
                protocolWi.setValue(dxml.getParamDefault("protocol"));
                pingTimeoutWi.setValue(dxml.getParamDefault("ping-timeout"));
            }
        }
    }

    private void addHostAddressListener(final boolean wizard, final MyButton thisApplyButton, Map<Host, Widget> newIpComboBoxHash, Map<Host, Widget> ipComboBoxHash) {
        for (final Host host : this.getHosts()) {
            Widget rwi;
            Widget wi;
            if (wizard) {
                wi = newIpComboBoxHash.get(host);
                rwi = ipComboBoxHash.get(host);
            } else {
                wi = newIpComboBoxHash.get(host);
                rwi = null;
            }
            if (wi == null) continue;
            final Widget comboBox = wi;
            final Widget realComboBox = rwi;
            comboBox.addListeners(new WidgetListener(){

                @Override
                public void check(Object value) {
                    DrbdResourceInfo.this.checkParameterFields(comboBox, realComboBox, null, null, thisApplyButton);
                    DrbdResourceInfo.this.setProxyPanels(wizard);
                    if (value instanceof ProxyNetInfo && ((ProxyNetInfo)value).getNetInterface() == null) {
                        final int s = "proxy: ".length();
                        comboBox.setAlwaysEditable(true);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                comboBox.select(s, s + "--.--.--.--".length());
                            }
                        });
                    } else if (value instanceof String) {
                        comboBox.setAlwaysEditable(true);
                    } else {
                        comboBox.setAlwaysEditable(false);
                    }
                    if (value instanceof ProxyNetInfo && ((ProxyNetInfo)value).isLocalHost()) {
                        Map cb = wizard ? DrbdResourceInfo.this.insideIpComboBoxHashWizard : DrbdResourceInfo.this.insideIpComboBoxHash;
                        Host proxyHost = DrbdResourceInfo.this.getProxyHost(host, wizard);
                        ((Widget)cb.get(proxyHost)).setValueAndWait(DrbdResourceInfo.this.getIp(value));
                    }
                }
            });
        }
    }

    private void addIpListeners(boolean wizard, final MyButton thisApplyButton, Map<Host, Widget> newIpComboBoxHash, Map<Host, Widget> ipComboBoxHash) {
        for (Host pHost : new HashSet<Host>(this.getCluster().getProxyHosts())) {
            Widget rwi;
            Widget wi;
            if (wizard) {
                wi = newIpComboBoxHash.get(pHost);
                rwi = ipComboBoxHash.get(pHost);
            } else {
                wi = newIpComboBoxHash.get(pHost);
                rwi = null;
            }
            if (wi == null) continue;
            final Widget comboBox = wi;
            final Widget realComboBox = rwi;
            comboBox.addListeners(new WidgetListener(){

                @Override
                public void check(Object value) {
                    DrbdResourceInfo.this.checkParameterFields(comboBox, realComboBox, null, null, thisApplyButton);
                }
            });
        }
    }

    private void addPortListeners(boolean wizard, final MyButton thisApplyButton, Widget newPortWi, Widget portWi) {
        Widget prwi;
        Widget pwi;
        if (wizard) {
            pwi = newPortWi;
            prwi = portWi;
        } else {
            pwi = portWi;
            prwi = null;
        }
        final Widget comboBox = pwi;
        final Widget realComboBox = prwi;
        pwi.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                DrbdResourceInfo.this.checkParameterFields(comboBox, realComboBox, null, null, thisApplyButton);
            }
        });
    }

    @Override
    protected void storeComboBoxValues(String[] params) {
        super.storeComboBoxValues(params);
        this.storeHostAddresses();
        this.storeProxyInfo();
    }

    public DrbdVolumeInfo getDrbdVolumeInfo(String volumeNr) {
        if (volumeNr == null) {
            return null;
        }
        for (DrbdVolumeInfo dvi : this.drbdVolumes) {
            if (!volumeNr.equals(dvi.getName())) continue;
            return dvi;
        }
        return null;
    }

    public boolean removeDrbdVolume(DrbdVolumeInfo dvi) {
        this.drbdVolumes.remove(dvi);
        return this.drbdVolumes.isEmpty();
    }

    @Override
    public void removeMyself(boolean testOnly) {
        super.removeMyself(testOnly);
        this.getBrowser().getDrbdXML().removeResource(this.getName());
        Set<Host> hosts = this.getHosts();
        for (Host host : hosts) {
            host.getBrowser().getUsedPorts().remove(this.portComboBox.getStringValue());
            host.getBrowser().getUsedPorts().remove(this.insidePortComboBox.getStringValue());
            host.getBrowser().getUsedProxyPorts().remove(this.outsidePortComboBox.getStringValue());
        }
        Map<String, DrbdResourceInfo> drbdResHash = this.getBrowser().getDrbdResHash();
        DrbdResourceInfo dri = drbdResHash.get(this.getName());
        drbdResHash.remove(this.getName());
        this.getBrowser().putDrbdResHash();
        if (dri != null) {
            dri.setName(null);
        }
        if (!testOnly) {
            this.removeNode();
        }
        this.getDrbdInfo().reloadDRBDResourceComboBoxes();
    }

    public Set<DrbdVolumeInfo> getDrbdVolumes() {
        return this.drbdVolumes;
    }

    @Override
    public void reloadComboBoxes() {
        super.reloadComboBoxes();
        String param = "resync-after";
        if (!this.getDrbdInfo().atLeastVersion("8.4")) {
            param = "after";
        }
        ArrayList<Info> l = new ArrayList<Info>();
        String defaultItem = this.getParamSaved(param);
        StringInfo di = new StringInfo(Tools.getString("ClusterBrowser.None"), "-1", this.getBrowser());
        l.add(di);
        Map<String, DrbdResourceInfo> drbdResHash = this.getBrowser().getDrbdResHash();
        for (String drbdRes : drbdResHash.keySet()) {
            DrbdResourceInfo r;
            DrbdResourceInfo odri = r = drbdResHash.get(drbdRes);
            boolean cyclicRef = false;
            while ((odri = drbdResHash.get(odri.getParamSaved(param))) != null) {
                if (odri != this) continue;
                cyclicRef = true;
            }
            if (r == this || cyclicRef) continue;
            l.add(r);
        }
        this.getBrowser().putDrbdResHash();
        if (this.resyncAfterParamWi != null) {
            String value = this.resyncAfterParamWi.getStringValue();
            this.resyncAfterParamWi.reloadComboBox(value, l.toArray(new Info[l.size()]));
        }
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        for (final DrbdVolumeInfo dvi : this.drbdVolumes) {
            MyMenu volumesMenu = new MyMenu(dvi.toString(), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
                private static final long serialVersionUID = 1L;
                private final Lock mUpdateLock;
                {
                    super(x0, x1, x2);
                    this.mUpdateLock = new ReentrantLock();
                }

                @Override
                public String enablePredicate() {
                    return null;
                }

                @Override
                public void update() {
                    Thread t = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (mUpdateLock.tryLock()) {
                                try {
                                    this.updateThread();
                                }
                                finally {
                                    mUpdateLock.unlock();
                                }
                            }
                        }
                    });
                    t.start();
                }

                public void updateThread() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.setEnabled(false);
                        }
                    });
                    Tools.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            this.removeAll();
                        }
                    });
                    final ArrayList<UpdatableItem> volumeMenus = new ArrayList<UpdatableItem>();
                    for (UpdatableItem u : dvi.createPopup()) {
                        volumeMenus.add(u);
                        u.update();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (UpdatableItem u : volumeMenus) {
                                this.add((JMenuItem)((Object)u));
                            }
                        }
                    });
                    super.update();
                }
            };
            items.add(volumesMenu);
        }
        return items;
    }

    public void setUsedByCRM(ServiceInfo isUsedByCRM) {
        this.isUsedByCRM = isUsedByCRM;
    }

    public boolean isUsedByCRM() {
        return this.isUsedByCRM != null && this.isUsedByCRM.isManaged(false);
    }

    private Set<Host> getHosts() {
        return this.hosts;
    }

    @Override
    protected Color getSectionColor(String section) {
        if (SECTION_PROXY.equals(section)) {
            return AppDefaults.LIGHT_ORANGE;
        }
        return super.getSectionColor(section);
    }

    private String getIp(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ProxyNetInfo) {
            return ((ProxyNetInfo)o).getInternalValue();
        }
        if (this.isProxyAddress(o.toString())) {
            Matcher drbdpM = DRBDP_ADDRESS.matcher(o.toString());
            if (drbdpM.matches()) {
                return drbdpM.group(1);
            }
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return ((NetInfo)o).getInternalValue();
    }

    Host getProxyHost(Host host, boolean wizard) {
        Matcher drbdpM;
        Widget addrW = wizard ? this.addressComboBoxHashWizard.get(host) : this.addressComboBoxHash.get(host);
        if (addrW == null) {
            return null;
        }
        Object o = addrW.getValue();
        if (o == null) {
            return null;
        }
        if (o instanceof ProxyNetInfo) {
            ProxyNetInfo pni = (ProxyNetInfo)o;
            return pni.getProxyHost();
        }
        if (this.isProxyAddress(o.toString()) && (drbdpM = DRBDP_ADDRESS.matcher(o.toString())).matches()) {
            String name = drbdpM.group(3);
            return this.getCluster().getProxyHostByName(name);
        }
        return null;
    }

    private String getDefaultInsideIp(Host host) {
        Widget wi = this.addressComboBoxHash.get(host);
        if (wi != null) {
            return this.getIp(wi.getValue());
        }
        return null;
    }

    public int getLowestUnusedPort() {
        int lowest = -1;
        for (Host host : this.getHosts()) {
            for (String usedPortS : host.getBrowser().getUsedPorts()) {
                if (!Tools.isNumber(usedPortS)) continue;
                int usedPort = Integer.parseInt(usedPortS);
                if (lowest >= 0 && usedPort <= lowest) continue;
                lowest = usedPort;
            }
        }
        if (lowest < 0) {
            return Tools.getDefaultInt("HostBrowser.DrbdNetInterfacePort");
        }
        return lowest + 1;
    }

    public int getLowestUnusedProxyPort() {
        int lowest = -1;
        for (Host host : this.getHosts()) {
            for (String usedPortS : host.getBrowser().getUsedProxyPorts()) {
                if (!Tools.isNumber(usedPortS)) continue;
                int usedPort = Integer.parseInt(usedPortS);
                if (lowest >= 0 && usedPort <= lowest) continue;
                lowest = usedPort;
            }
        }
        if (lowest < 0) {
            return Tools.getDefaultInt("HostBrowser.DrbdNetInterfacePort");
        }
        return lowest + 1;
    }

    List<String> getPossibleDrbdPorts(int defaultPortInt) {
        int i = 0;
        ArrayList<String> drbdPorts = new ArrayList<String>();
        drbdPorts.add(null);
        while (i < 10) {
            String port = Integer.toString(defaultPortInt);
            boolean contains = false;
            for (Host host : this.getHosts()) {
                if (!host.getBrowser().getUsedPorts().contains(port)) continue;
                contains = true;
            }
            if (!contains || i == 0) {
                drbdPorts.add(port);
                ++i;
            }
            ++defaultPortInt;
        }
        return drbdPorts;
    }

    private int getDefaultInsidePort() {
        String insideDefaultPort = this.savedInsidePort;
        int insideDefaultPortInt = insideDefaultPort == null || "".equals(insideDefaultPort) ? (this.savedPort == null || "".equals(this.savedPort) ? this.getLowestUnusedPort() + 1 : Integer.parseInt(this.savedPort) + 1) : Integer.parseInt(insideDefaultPort);
        return insideDefaultPortInt;
    }

    public boolean isProxy(Host host) {
        Widget cb = this.addressComboBoxHash.get(host);
        if (cb != null) {
            return this.isProxyAddress(cb.getValue());
        }
        return false;
    }

    private boolean isProxyAddress(Object address) {
        return address instanceof ProxyNetInfo || address != null && address.toString().startsWith("proxy: ");
    }

    @Override
    public void resetInfoPanel() {
        super.resetInfoPanel();
        this.infoPanel = null;
    }

    public Set<Host> getConfiguredProxyHosts() {
        HashSet<Host> proxyHosts = new HashSet<Host>();
        for (Host host : this.getHosts()) {
            Host proxyHost = this.getProxyHost(host, false);
            if (proxyHost == null) continue;
            proxyHosts.add(proxyHost);
        }
        return proxyHosts;
    }

    public void addSelectedProxyHost(Host host) {
        this.selectedProxyHosts.add(host);
    }

    public void removeSelectedProxyHost(Host host) {
        this.selectedProxyHosts.remove(host);
    }

    public void resetDrbdResourcePanel() {
        this.resetInfoPanel();
        this.getInfoPanel();
        this.waitForInfoPanel();
        this.selectMyself();
    }
}

