/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.VMSXML;
import lcmc.gui.Browser;
import lcmc.gui.resources.StringInfo;
import lcmc.gui.resources.VMSHardwareInfo;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import org.w3c.dom.Node;

public final class VMSGraphicsInfo
extends VMSHardwareInfo {
    private final Map<String, Widget> portWi = new HashMap<String, Widget>();
    private final Map<String, Widget> listenWi = new HashMap<String, Widget>();
    private final Map<String, Widget> passwdWi = new HashMap<String, Widget>();
    private final Map<String, Widget> keymapWi = new HashMap<String, Widget>();
    private final Map<String, Widget> displayWi = new HashMap<String, Widget>();
    private final Map<String, Widget> xauthWi = new HashMap<String, Widget>();
    private static final String[] PARAMETERS = new String[]{"type", "port", "listen", "passwd", "keymap", "display", "xauth"};
    private static final String[] VNC_PARAMETERS = new String[]{"type", "port", "listen", "passwd", "keymap"};
    private static final String[] SDL_PARAMETERS = new String[]{"type", "display", "xauth"};
    private static final Map<String, Widget.Type> FIELD_TYPES = new HashMap<String, Widget.Type>();
    private static final Map<String, String> SHORTNAME_MAP = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_VALUES = new HashMap<String, String>();
    private static final Set<String> IS_ENABLED_ONLY_IN_ADVANCED = new HashSet<String>(Arrays.asList("keymap"));
    private static final Set<String> IS_REQUIRED = new HashSet<String>(Arrays.asList("type"));
    private static final Map<String, String> DEFAULTS_MAP = new HashMap<String, String>();
    private static final Map<String, Object[]> POSSIBLE_VALUES = new HashMap<String, Object[]>();
    private JComponent tablePanel = null;

    VMSGraphicsInfo(String name, Browser browser, VMSVirtualDomainInfo vmsVirtualDomainInfo) {
        super(name, browser, vmsVirtualDomainInfo);
    }

    @Override
    protected void addHardwareTable(JPanel mainPanel) {
        this.tablePanel = this.getTablePanel("Displays", "graphics", VMSGraphicsInfo.getNewBtn(this.getVMSVirtualDomainInfo()));
        if (this.getResource().isNew()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VMSGraphicsInfo.this.tablePanel.setVisible(false);
                }
            });
        }
        mainPanel.add(this.tablePanel);
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        return VMSVirtualDomainInfo.VNC_ICON_SMALL;
    }

    @Override
    protected String getParamLongDesc(String param) {
        return this.getParamShortDesc(param);
    }

    @Override
    protected String getParamShortDesc(String param) {
        String name = SHORTNAME_MAP.get(param);
        if (name == null) {
            return param;
        }
        return name;
    }

    @Override
    protected String getParamPreferred(String param) {
        return PREFERRED_VALUES.get(param);
    }

    @Override
    protected String getParamDefault(String param) {
        return DEFAULTS_MAP.get(param);
    }

    @Override
    public String[] getParametersFromXML() {
        return (String[])PARAMETERS.clone();
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        if ("listen".equals(param)) {
            Map<String, String> networksIntersection = null;
            List<Host> definedOnHosts = this.getVMSVirtualDomainInfo().getDefinedOnHosts();
            for (Host host : definedOnHosts) {
                networksIntersection = host.getNetworksIntersection(networksIntersection);
            }
            ArrayList<StringInfo> commonNetworks = new ArrayList<StringInfo>();
            commonNetworks.add(null);
            commonNetworks.add(new StringInfo("All Interfaces/0.0.0.0", "0.0.0.0", null));
            commonNetworks.add(new StringInfo("localhost/127.0.0.1", "127.0.0.1", null));
            if (networksIntersection != null) {
                for (String netIp : networksIntersection.keySet()) {
                    StringInfo network = new StringInfo(netIp, netIp, null);
                    commonNetworks.add(network);
                }
            }
            return commonNetworks.toArray(new StringInfo[commonNetworks.size()]);
        }
        if ("keymap".equals(param)) {
            ArrayList<String> keymaps = null;
            List<Host> definedOnHosts = this.getVMSVirtualDomainInfo().getDefinedOnHosts();
            for (Host host : definedOnHosts) {
                if (keymaps == null) {
                    keymaps = new ArrayList<String>();
                    keymaps.add(null);
                    keymaps.addAll(host.getQemuKeymaps());
                    continue;
                }
                Set<String> hostKeymaps = host.getQemuKeymaps();
                ArrayList<String> newKeymaps = new ArrayList<String>();
                newKeymaps.add(null);
                for (String km : keymaps) {
                    if (km == null || !hostKeymaps.contains(km)) continue;
                    newKeymaps.add(km);
                }
                keymaps = newKeymaps;
            }
            if (keymaps == null) {
                return new String[]{null};
            }
            return keymaps.toArray(new String[keymaps.size()]);
        }
        return POSSIBLE_VALUES.get(param);
    }

    @Override
    protected String getSection(String param) {
        return "Display Options";
    }

    @Override
    protected boolean isRequired(String param) {
        return IS_REQUIRED.contains(param);
    }

    @Override
    protected boolean isInteger(String param) {
        return false;
    }

    @Override
    protected boolean isLabel(String param) {
        return false;
    }

    @Override
    protected boolean isTimeType(String param) {
        return false;
    }

    @Override
    protected boolean isCheckBox(String param) {
        return false;
    }

    @Override
    protected String getParamType(String param) {
        return "undef";
    }

    @Override
    protected String getParamRegexp(String param) {
        if ("port".equals(param)) {
            return "^(-1|\\d+|aa)$";
        }
        if ("listen".equals(param)) {
            return "^(\\d+\\.\\d+\\.\\d+\\.\\d+)?$";
        }
        if ("display".equals(param)) {
            return "^:\\d+\\.\\d+$";
        }
        return null;
    }

    @Override
    protected Widget.Type getFieldType(String param) {
        return FIELD_TYPES.get(param);
    }

    @Override
    protected Map<String, String> getHWParameters(boolean allParams) {
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                VMSGraphicsInfo.this.getInfoPanel();
            }
        });
        HashMap<String, String> parameters = new HashMap<String, String>();
        String[] params = new String[]{};
        boolean vnc = false;
        if ("vnc".equals(this.getComboBoxValue("type"))) {
            vnc = true;
            params = VNC_PARAMETERS;
        } else if ("sdl".equals(this.getComboBoxValue("type"))) {
            params = SDL_PARAMETERS;
        }
        for (String param : params) {
            String value = this.getComboBoxValue(param);
            if (!allParams && Tools.areEqual(this.getParamSaved(param), value)) continue;
            if (Tools.areEqual(this.getParamDefault(param), value)) {
                parameters.put(param, null);
            } else {
                parameters.put(param, value);
            }
            if (!vnc) continue;
            if ("port".equals(param) && "-1".equals(value)) {
                parameters.put("autoport", "yes");
                continue;
            }
            parameters.put("autoport", "no");
        }
        this.setName(VMSXML.graphicsDisplayName(this.getParamSaved("type"), this.getParamSaved("port"), this.getParamSaved("display")));
        return parameters;
    }

    @Override
    void apply(boolean testOnly) {
        if (testOnly) {
            return;
        }
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                VMSGraphicsInfo.this.getApplyButton().setEnabled(false);
                VMSGraphicsInfo.this.getRevertButton().setEnabled(false);
            }
        });
        this.getInfoPanel();
        this.waitForInfoPanel();
        Map<String, String> parameters = this.getHWParameters(this.getResource().isNew());
        String[] params = this.getRealParametersFromXML();
        for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null) continue;
            parameters.put("saved_type", this.getParamSaved("type"));
            String domainName = this.getVMSVirtualDomainInfo().getDomainName();
            Node domainNode = vmsxml.getDomainNode(domainName);
            this.modifyXML(vmsxml, domainNode, domainName, parameters);
            String virshOptions = this.getVMSVirtualDomainInfo().getVirshOptions();
            vmsxml.saveAndDefine(domainNode, domainName, virshOptions);
        }
        this.getResource().setNew(false);
        this.getBrowser().reload(this.getNode(), false);
        this.getBrowser().periodicalVMSUpdate(this.getVMSVirtualDomainInfo().getDefinedOnHosts());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VMSGraphicsInfo.this.tablePanel.setVisible(true);
            }
        });
        if (!testOnly) {
            this.storeComboBoxValues(params);
        }
        this.checkResourceFieldsChanged(null, params);
    }

    @Override
    protected Object[][] getTableData(String tableName) {
        if ("header".equals(tableName)) {
            return this.getVMSVirtualDomainInfo().getMainTableData();
        }
        if ("graphics".equals(tableName)) {
            if (this.getResource().isNew()) {
                return new Object[0][];
            }
            return new Object[][]{this.getVMSVirtualDomainInfo().getGraphicsDataRow(this.getName(), null, this.getVMSVirtualDomainInfo().getGraphicDisplays(), true)};
        }
        return new Object[0][];
    }

    @Override
    protected boolean isAdvanced(String param) {
        return false;
    }

    @Override
    protected String isEnabled(String param) {
        if (this.getResource().isNew() || !"type".equals(param)) {
            return null;
        }
        return "";
    }

    @Override
    protected boolean isEnabledOnlyInAdvancedMode(String param) {
        return IS_ENABLED_ONLY_IN_ADVANCED.contains(param);
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return ConfigData.AccessType.ADMIN;
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        if ("type".equals(param)) {
            final boolean vnc = "vnc".equals(newValue);
            final boolean sdl = "sdl".equals(newValue);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (String p : VMSGraphicsInfo.this.listenWi.keySet()) {
                        ((Widget)VMSGraphicsInfo.this.listenWi.get(p)).setVisible(vnc);
                    }
                    for (String p : VMSGraphicsInfo.this.passwdWi.keySet()) {
                        ((Widget)VMSGraphicsInfo.this.passwdWi.get(p)).setVisible(vnc);
                    }
                    for (String p : VMSGraphicsInfo.this.keymapWi.keySet()) {
                        ((Widget)VMSGraphicsInfo.this.keymapWi.get(p)).setVisible(vnc);
                    }
                    for (String p : VMSGraphicsInfo.this.portWi.keySet()) {
                        ((Widget)VMSGraphicsInfo.this.portWi.get(p)).setVisible(vnc);
                    }
                    for (String p : VMSGraphicsInfo.this.displayWi.keySet()) {
                        ((Widget)VMSGraphicsInfo.this.displayWi.get(p)).setVisible(sdl);
                    }
                    for (String p : VMSGraphicsInfo.this.xauthWi.keySet()) {
                        ((Widget)VMSGraphicsInfo.this.xauthWi.get(p)).setVisible(sdl);
                    }
                }
            });
        }
        return !this.isRequired(param) || newValue != null && !"".equals(newValue);
    }

    @Override
    void updateParameters() {
        VMSXML.GraphicsData graphicsData;
        Map<String, VMSXML.GraphicsData> graphicDisplays = this.getVMSVirtualDomainInfo().getGraphicDisplays();
        if (graphicDisplays != null && (graphicsData = graphicDisplays.get(this.getName())) != null) {
            for (String param : this.getParametersFromXML()) {
                String oldValue = this.getParamSaved(param);
                String value = this.getParamSaved(param);
                Widget wi = this.getWidget(param, null);
                for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
                    String savedValue;
                    VMSXML vmsxml = this.getBrowser().getVMSXML(h);
                    if (vmsxml == null || (savedValue = graphicsData.getValue(param)) == null) continue;
                    value = savedValue;
                }
                if (Tools.areEqual(value, oldValue)) continue;
                this.getResource().setValue(param, value);
                if (wi == null) continue;
                wi.setValue(value);
            }
        }
        this.setName(VMSXML.graphicsDisplayName(this.getParamSaved("type"), this.getParamSaved("port"), this.getParamSaved("display")));
        this.updateTable("header");
        this.updateTable("graphics");
        this.checkResourceFieldsChanged(null, this.getParametersFromXML());
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(30);
        if (this.getName() == null) {
            s.append("new graphics device...");
        } else {
            s.append(this.getName());
        }
        return s.toString();
    }

    @Override
    protected void removeMyselfNoConfirm(boolean testOnly) {
        if (testOnly) {
            return;
        }
        String virshOptions = this.getVMSVirtualDomainInfo().getVirshOptions();
        for (Host h : this.getVMSVirtualDomainInfo().getDefinedOnHosts()) {
            VMSXML vmsxml = this.getBrowser().getVMSXML(h);
            if (vmsxml == null) continue;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("saved_type", this.getParamSaved("type"));
            vmsxml.removeGraphicsXML(this.getVMSVirtualDomainInfo().getDomainName(), parameters, virshOptions);
        }
        this.getBrowser().periodicalVMSUpdate(this.getVMSVirtualDomainInfo().getDefinedOnHosts());
        this.removeNode();
    }

    @Override
    protected String isRemoveable() {
        return null;
    }

    static MyButton getNewBtn(final VMSVirtualDomainInfo vdi) {
        MyButton newBtn = new MyButton("Add Graphics Display");
        newBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        vdi.addGraphicsPanel();
                    }
                });
                t.start();
            }
        });
        return newBtn;
    }

    @Override
    protected Widget createWidget(String param, String prefix, int width) {
        Widget paramWi = super.createWidget(param, prefix, width);
        if ("port".equals(param)) {
            if (prefix == null) {
                this.portWi.put("", paramWi);
            } else {
                this.portWi.put(prefix, paramWi);
            }
        } else if ("listen".equals(param)) {
            if (prefix == null) {
                this.listenWi.put("", paramWi);
            } else {
                this.listenWi.put(prefix, paramWi);
            }
        } else if ("passwd".equals(param)) {
            if (prefix == null) {
                this.passwdWi.put("", paramWi);
            } else {
                this.passwdWi.put(prefix, paramWi);
            }
        } else if ("keymap".equals(param)) {
            if (prefix == null) {
                this.keymapWi.put("", paramWi);
            } else {
                this.keymapWi.put(prefix, paramWi);
            }
        } else if ("display".equals(param)) {
            if (prefix == null) {
                this.displayWi.put("", paramWi);
            } else {
                this.displayWi.put(prefix, paramWi);
            }
        } else if ("xauth".equals(param)) {
            if (prefix == null) {
                this.xauthWi.put("", paramWi);
            } else {
                this.xauthWi.put(prefix, paramWi);
            }
        }
        return paramWi;
    }

    @Override
    protected void modifyXML(VMSXML vmsxml, Node node, String domainName, Map<String, String> params) {
        if (vmsxml != null) {
            vmsxml.modifyGraphicsXML(node, domainName, params);
        }
    }

    @Override
    public String[] getRealParametersFromXML() {
        if ("vnc".equals(this.getComboBoxValue("type"))) {
            return (String[])VNC_PARAMETERS.clone();
        }
        if ("sdl".equals(this.getComboBoxValue("type"))) {
            return (String[])SDL_PARAMETERS.clone();
        }
        return (String[])PARAMETERS.clone();
    }

    static {
        FIELD_TYPES.put("type", Widget.Type.RADIOGROUP);
        FIELD_TYPES.put("passwd", Widget.Type.PASSWDFIELD);
        SHORTNAME_MAP.put("type", "Type");
        SHORTNAME_MAP.put("port", "Port");
        SHORTNAME_MAP.put("listen", "Listen");
        SHORTNAME_MAP.put("passwd", "Password");
        SHORTNAME_MAP.put("keymap", "Keymap");
        SHORTNAME_MAP.put("display", "Display");
        SHORTNAME_MAP.put("xauth", "Xauth File");
        PREFERRED_VALUES.put("port", "-1");
        PREFERRED_VALUES.put("display", ":0.0");
        PREFERRED_VALUES.put("xauth", System.getProperty("user.home") + "/.Xauthority");
        POSSIBLE_VALUES.put("type", new String[]{"vnc", "sdl"});
        POSSIBLE_VALUES.put("xauth", new String[]{null, System.getProperty("user.home") + "/.Xauthority"});
        POSSIBLE_VALUES.put("display", new String[]{null, ":0.0"});
        POSSIBLE_VALUES.put("port", new StringInfo[]{new StringInfo("auto", "-1", null), new StringInfo("5900", "5900", null), new StringInfo("5901", "5901", null)});
    }
}

