/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.utilities.ComponentWithTest;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public abstract class MyMenuItem
extends JMenuItem
implements ActionListener,
UpdatableItem,
ComponentWithTest {
    private static final long serialVersionUID = 1L;
    private String text1;
    private ImageIcon icon1;
    private String shortDesc1;
    private String text2;
    private ImageIcon icon2;
    private String shortDesc2;
    private JToolTip toolTip = null;
    private Point2D pos;
    private final Robot robot;
    private static final GraphicsDevice SCREEN_DEVICE = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    private Color toolTipBackground = null;
    private final AccessMode enableAccessMode;
    private final AccessMode visibleAccessMode;
    private String origToolTipText = "";

    public MyMenuItem(final String text, ImageIcon icon, AccessMode enableAccessMode, AccessMode visibleAccessMode) {
        super(text);
        this.text1 = text;
        this.icon1 = icon;
        this.enableAccessMode = enableAccessMode;
        this.visibleAccessMode = visibleAccessMode;
        this.toolTip = this.createToolTip();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MyMenuItem.this.toolTip.setTipText(text);
            }
        });
        this.setNormalFont();
        this.addActionListener(this);
        Robot r = null;
        try {
            r = new Robot(SCREEN_DEVICE);
        }
        catch (AWTException e) {
            Tools.appError("Robot error");
        }
        this.robot = r;
    }

    public MyMenuItem(String text, ImageIcon icon, final String shortDesc, AccessMode enableAccessMode, AccessMode visibleAccessMode) {
        super(text);
        if (shortDesc != null && !"".equals(shortDesc)) {
            this.toolTip = this.createToolTip();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyMenuItem.this.toolTip.setTipText(shortDesc);
                }
            });
        }
        this.setNormalFont();
        this.text1 = text;
        this.icon1 = icon;
        this.shortDesc1 = shortDesc == null ? "" : shortDesc;
        this.enableAccessMode = enableAccessMode;
        this.visibleAccessMode = visibleAccessMode;
        this.addActionListener(this);
        Robot r = null;
        try {
            r = new Robot(SCREEN_DEVICE);
        }
        catch (AWTException e) {
            Tools.appError("Robot error");
        }
        this.robot = r;
    }

    public MyMenuItem(String text1a, ImageIcon icon1a, String shortDesc1a, String text2, ImageIcon icon2, String shortDesc2, AccessMode enableAccessMode, AccessMode visibleAccessMode) {
        this(text1a, icon1a, shortDesc1a, enableAccessMode, visibleAccessMode);
        this.text2 = text2;
        this.icon2 = icon2;
        this.shortDesc2 = shortDesc2 == null ? "" : shortDesc2;
    }

    @Override
    public final void setPos(Point2D pos) {
        this.pos = pos;
    }

    protected final Point2D getPos() {
        return this.pos;
    }

    private void setNormalFont() {
        Font font = this.getFont();
        final String name = font.getFontName();
        boolean style = false;
        final int size = font.getSize();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MyMenuItem.this.setFont(new Font(name, 0, size));
            }
        });
    }

    public final void setSpecialFont() {
        Font font = this.getFont();
        final String name = font.getFontName();
        int style = 2;
        final int size = font.getSize();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MyMenuItem.this.setFont(new Font(name, 2, size));
            }
        });
    }

    public abstract void action();

    public boolean predicate() {
        return true;
    }

    public String enablePredicate() {
        return null;
    }

    public boolean visiblePredicate() {
        return true;
    }

    @Override
    public void update() {
        if (this.predicate()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyMenuItem.this.setText(MyMenuItem.this.text1);
                    if (MyMenuItem.this.icon1 != null) {
                        MyMenuItem.this.setIcon(MyMenuItem.this.icon1);
                    }
                    if (MyMenuItem.this.toolTip != null && MyMenuItem.this.shortDesc1 != null && !MyMenuItem.this.shortDesc1.equals(MyMenuItem.this.text1)) {
                        MyMenuItem.this.origToolTipText = MyMenuItem.this.shortDesc1;
                        MyMenuItem.this.toolTip.setTipText(MyMenuItem.this.shortDesc1);
                    }
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyMenuItem.this.setText(MyMenuItem.this.text2);
                    if (MyMenuItem.this.icon1 != null) {
                        MyMenuItem.this.setIcon(MyMenuItem.this.icon2);
                    }
                    if (MyMenuItem.this.toolTip != null && MyMenuItem.this.shortDesc2 != null && !MyMenuItem.this.shortDesc2.equals(MyMenuItem.this.text2)) {
                        MyMenuItem.this.origToolTipText = MyMenuItem.this.shortDesc2;
                        MyMenuItem.this.toolTip.setTipText(MyMenuItem.this.shortDesc2);
                    }
                }
            });
        }
        this.processAccessMode();
    }

    private void processAccessMode() {
        final boolean accessible = Tools.getConfigData().isAccessible(this.enableAccessMode);
        final String disableTooltip = this.enablePredicate();
        final boolean visible = this.visiblePredicate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MyMenuItem.this.setEnabled(disableTooltip == null && accessible);
                MyMenuItem.this.setVisible(visible && Tools.getConfigData().isAccessible(MyMenuItem.this.visibleAccessMode));
            }
        });
        if (this.toolTip != null && this.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!accessible && MyMenuItem.this.enableAccessMode.getAccessType() != ConfigData.AccessType.NEVER) {
                        String advanced = "";
                        if (MyMenuItem.this.enableAccessMode.isAdvancedMode()) {
                            advanced = "Advanced ";
                        }
                        MyMenuItem.this.setToolTipText0("<html><b>" + MyMenuItem.this.getText() + " (disabled)</b><br>available in \"" + advanced + ConfigData.OP_MODES_MAP.get((Object)MyMenuItem.this.enableAccessMode.getAccessType()) + "\" mode</html>");
                    } else if (disableTooltip != null) {
                        MyMenuItem.this.setToolTipText0("<html><b>" + MyMenuItem.this.getText() + " (disabled)</b><br>" + disableTooltip + "</html>");
                    } else if (MyMenuItem.this.origToolTipText != null) {
                        MyMenuItem.this.setToolTipText0(MyMenuItem.this.origToolTipText);
                    }
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                MyMenuItem.this.action();
            }
        });
        thread.start();
    }

    @Override
    public final String toString() {
        return this.getText();
    }

    @Override
    public final JToolTip createToolTip() {
        if (this.toolTip != null) {
            this.toolTip.setComponent(null);
        }
        this.toolTip = super.createToolTip();
        if (this.toolTipBackground != null) {
            this.toolTip.setBackground(this.toolTipBackground);
        }
        return this.toolTip;
    }

    @Override
    public final void setToolTipBackground(Color toolTipBackground) {
        this.toolTipBackground = toolTipBackground;
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        Point screenLocation = this.getLocationOnScreen();
        Rectangle sBounds = Tools.getScreenBounds(this);
        Dimension size = this.toolTip.getPreferredSize();
        if (screenLocation.x + size.width + event.getX() + 5 > sBounds.width) {
            return new Point(event.getX() - size.width - 5, event.getY() + 20);
        }
        return new Point(event.getX() + 5, event.getY() + 20);
    }

    @Override
    public final void setToolTipText(String toolTipText) {
        if (this.toolTip == null || toolTipText == null) {
            return;
        }
        this.origToolTipText = toolTipText;
        this.setToolTipText0(toolTipText);
    }

    private void moveMouse() {
        if (this.robot != null) {
            int x2;
            int x1;
            GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            int xOffset = 0;
            if (devices.length >= 2 && (x1 = devices[0].getDefaultConfiguration().getBounds().x) > (x2 = devices[1].getDefaultConfiguration().getBounds().x)) {
                xOffset = -x1;
            }
            Point p = MouseInfo.getPointerInfo().getLocation();
            this.robot.mouseMove((int)((Point2D)p).getX() + xOffset - 1, (int)((Point2D)p).getY());
            this.robot.mouseMove((int)((Point2D)p).getX() + xOffset + 1, (int)((Point2D)p).getY());
            this.robot.mouseMove((int)((Point2D)p).getX() + xOffset, (int)((Point2D)p).getY());
        }
    }

    private void setToolTipText0(String toolTipText) {
        if (this.toolTip == null) {
            return;
        }
        if ("".equals(toolTipText)) {
            toolTipText = this.text1;
        }
        this.toolTip.setTipText(toolTipText);
        super.setToolTipText(toolTipText);
        if (this.toolTip != null && this.robot != null && this.toolTip.isShowing()) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    Tools.sleep(1000);
                    MyMenuItem.this.moveMouse();
                    Tools.sleep(2000);
                    MyMenuItem.this.moveMouse();
                }
            });
            t.start();
        }
    }

    @Override
    public final void cleanup() {
        if (this.toolTip != null) {
            this.toolTip.setComponent(null);
        }
    }

    public final void setText1(String text1) {
        this.text1 = text1;
    }

    public final void setText2(String text2) {
        this.text2 = text2;
    }
}

