/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.functors;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections15.Closure;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.functors.FunctorUtils;
import org.apache.commons.collections15.functors.NOPClosure;

public class SwitchClosure<T>
implements Closure<T>,
Serializable {
    static final long serialVersionUID = 3518477308466486130L;
    private final Predicate<? super T>[] iPredicates;
    private final Closure<? super T>[] iClosures;
    private final Closure<? super T> iDefault;

    public static <T> Closure<T> getInstance(Predicate<? super T>[] predicates, Closure<? super T>[] closures, Closure<? super T> defaultClosure) {
        FunctorUtils.validate(predicates);
        FunctorUtils.validate(closures);
        if (predicates.length != closures.length) {
            throw new IllegalArgumentException("The predicate and closure arrays must be the same size");
        }
        if (predicates.length == 0) {
            return defaultClosure == null ? NOPClosure.INSTANCE : defaultClosure;
        }
        predicates = FunctorUtils.copy(predicates);
        closures = FunctorUtils.copy(closures);
        return new SwitchClosure<T>(predicates, closures, defaultClosure);
    }

    public static <T> Closure<T> getInstance(Map<Predicate<? super T>, Closure<? super T>> predicatesAndClosures) {
        Closure[] closures = null;
        Predicate[] preds = null;
        if (predicatesAndClosures == null) {
            throw new IllegalArgumentException("The predicate and closure map must not be null");
        }
        if (predicatesAndClosures.size() == 0) {
            return NOPClosure.INSTANCE;
        }
        Closure<? super T> defaultClosure = predicatesAndClosures.remove(null);
        int size = predicatesAndClosures.size();
        if (size == 0) {
            return defaultClosure == null ? NOPClosure.INSTANCE : defaultClosure;
        }
        closures = new Closure[size];
        preds = new Predicate[size];
        int i = 0;
        for (Map.Entry<Predicate<T>, Closure<T>> entry : predicatesAndClosures.entrySet()) {
            preds[i] = entry.getKey();
            closures[i] = entry.getValue();
            ++i;
        }
        return new SwitchClosure<T>(preds, closures, defaultClosure);
    }

    public SwitchClosure(Predicate<? super T>[] predicates, Closure<? super T>[] closures, Closure<? super T> defaultClosure) {
        this.iPredicates = predicates;
        this.iClosures = closures;
        this.iDefault = defaultClosure == null ? NOPClosure.INSTANCE : defaultClosure;
    }

    @Override
    public void execute(T input) {
        for (int i = 0; i < this.iPredicates.length; ++i) {
            if (!this.iPredicates[i].evaluate(input)) continue;
            this.iClosures[i].execute(input);
            return;
        }
        this.iDefault.execute(input);
    }

    public Predicate<? super T>[] getPredicates() {
        return this.iPredicates;
    }

    public Closure<? super T>[] getClosures() {
        return this.iClosures;
    }

    public Closure<? super T> getDefaultClosure() {
        return this.iDefault;
    }
}

