/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.functors;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;
import org.apache.commons.collections15.functors.FunctorUtils;

public class SwitchTransformer<I, O>
implements Transformer<I, O>,
Serializable {
    static final long serialVersionUID = -6404460890903469332L;
    private final Predicate<? super I>[] iPredicates;
    private final Transformer<? super I, ? extends O>[] iTransformers;
    private final Transformer<? super I, ? extends O> iDefault;

    public static <I, O> Transformer<I, O> getInstance(Predicate<? super I>[] predicates, Transformer<? super I, ? extends O>[] transformers, Transformer<? super I, ? extends O> defaultTransformer) {
        FunctorUtils.validate(predicates);
        FunctorUtils.validate(transformers);
        if (predicates.length != transformers.length) {
            throw new IllegalArgumentException("The predicate and transformer arrays must be the same size");
        }
        if (predicates.length == 0) {
            return defaultTransformer == null ? ConstantTransformer.NULL_INSTANCE : defaultTransformer;
        }
        predicates = FunctorUtils.copy(predicates);
        transformers = FunctorUtils.copy(transformers);
        return new SwitchTransformer<I, O>(predicates, transformers, defaultTransformer);
    }

    public static <I, O> Transformer<I, O> getInstance(Map<Predicate<? super I>, Transformer<? super I, ? extends O>> predicatesAndTransformers) {
        Transformer[] transformers = null;
        Predicate[] preds = null;
        if (predicatesAndTransformers == null) {
            throw new IllegalArgumentException("The predicate and transformer map must not be null");
        }
        if (predicatesAndTransformers.size() == 0) {
            return ConstantTransformer.NULL_INSTANCE;
        }
        Transformer<? super I, ? extends O> defaultTransformer = predicatesAndTransformers.remove(null);
        int size = predicatesAndTransformers.size();
        if (size == 0) {
            return defaultTransformer == null ? ConstantTransformer.NULL_INSTANCE : defaultTransformer;
        }
        transformers = new Transformer[size];
        preds = new Predicate[size];
        int i = 0;
        for (Map.Entry<Predicate<I>, Transformer<I, O>> entry : predicatesAndTransformers.entrySet()) {
            preds[i] = entry.getKey();
            transformers[i] = entry.getValue();
            ++i;
        }
        return new SwitchTransformer<I, O>(preds, transformers, defaultTransformer);
    }

    public SwitchTransformer(Predicate<? super I>[] predicates, Transformer<? super I, ? extends O>[] transformers, Transformer<? super I, ? extends O> defaultTransformer) {
        this.iPredicates = predicates;
        this.iTransformers = transformers;
        this.iDefault = defaultTransformer == null ? ConstantTransformer.NULL_INSTANCE : defaultTransformer;
    }

    @Override
    public O transform(I input) {
        for (int i = 0; i < this.iPredicates.length; ++i) {
            if (!this.iPredicates[i].evaluate(input)) continue;
            return this.iTransformers[i].transform(input);
        }
        return this.iDefault.transform(input);
    }

    public Predicate<? super I>[] getPredicates() {
        return this.iPredicates;
    }

    public Transformer<? super I, ? extends O>[] getTransformers() {
        return this.iTransformers;
    }

    public Transformer<? super I, ? extends O> getDefaultTransformer() {
        return this.iDefault;
    }
}

