/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.checkin;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceCheckInConsumer
implements StreamConsumer {
    private static final String CREATED_PATTERN = "^Change \\d+ created .+$";
    private static final String SUBMITTING_PATTERN = "^Submitting change \\d+\\.$";
    private static final String LOCKING_PATTERN = "^Locking \\d+ files \\.\\.\\.$";
    private static final String OP_PATTERN = "^[a-z]+ //[^#]+#\\d+$";
    private static final String COMPLETE_PATTERN = "^Change \\d+ .*submitted.$";
    public static final int STATE_CREATED = 1;
    public static final int STATE_SUBMITTING = 2;
    public static final int STATE_LOCKING = 3;
    public static final int STATE_OP = 4;
    public static final int STATE_COMPLETE = 5;
    public static final int STATE_ERROR = 6;
    private StringWriter errors = new StringWriter();
    private PrintWriter errorOutput = new PrintWriter(this.errors);
    private int currentState = 1;
    private RE opRegexp;

    public PerforceCheckInConsumer() {
        try {
            this.opRegexp = new RE(OP_PATTERN);
        }
        catch (RESyntaxException ignored) {
            ignored.printStackTrace();
        }
    }

    public void consumeLine(String line) {
        if (line.startsWith("... ")) {
            return;
        }
        switch (this.currentState) {
            case 1: {
                boolean created = new RE(CREATED_PATTERN).match(line);
                if (created) {
                    ++this.currentState;
                    break;
                }
                this.error(line);
                break;
            }
            case 2: {
                boolean submitting = new RE(SUBMITTING_PATTERN).match(line);
                if (submitting) {
                    ++this.currentState;
                    break;
                }
                this.error(line);
                break;
            }
            case 3: {
                boolean locked = new RE(LOCKING_PATTERN).match(line);
                if (locked) {
                    ++this.currentState;
                    break;
                }
                this.error(line);
                break;
            }
            case 4: {
                boolean operation = this.opRegexp.match(line);
                if (operation) break;
                if (new RE(COMPLETE_PATTERN).match(line)) {
                    ++this.currentState;
                    break;
                }
                this.error(line);
                break;
            }
            case 6: {
                this.error(line);
                break;
            }
        }
    }

    private void error(String line) {
        this.currentState = 6;
        this.errorOutput.println(line);
    }

    public boolean isSuccess() {
        return this.currentState == 5;
    }

    public String getOutput() {
        this.errorOutput.flush();
        this.errors.flush();
        return this.errors.toString();
    }
}

