/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.inheritance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.apache.maven.project.ModelUtils;
import org.apache.maven.project.inheritance.ModelInheritanceAssembler;
import org.codehaus.plexus.util.StringUtils;

public class DefaultModelInheritanceAssembler
implements ModelInheritanceAssembler {
    public void copyModel(Model dest, Model source) {
        this.assembleModelInheritance(dest, source, false);
    }

    public void assembleModelInheritance(Model child, Model parent) {
        this.assembleModelInheritance(child, parent, true);
    }

    private void assembleModelInheritance(Model child, Model parent, boolean appendPaths) {
        if (parent == null) {
            return;
        }
        if (child.getGroupId() == null) {
            child.setGroupId(parent.getGroupId());
        }
        if (child.getVersion() == null && child.getParent() != null) {
            child.setVersion(child.getParent().getVersion());
        }
        if (child.getInceptionYear() == null) {
            child.setInceptionYear(parent.getInceptionYear());
        }
        if (child.getUrl() == null) {
            if (parent.getUrl() != null) {
                child.setUrl(this.appendPath(parent.getUrl(), child.getArtifactId(), appendPaths));
            } else {
                child.setUrl(parent.getUrl());
            }
        }
        this.assembleDistributionInheritence(child, parent, appendPaths);
        if (child.getIssueManagement() == null) {
            child.setIssueManagement(parent.getIssueManagement());
        }
        if (child.getDescription() == null) {
            child.setDescription(parent.getDescription());
        }
        if (child.getOrganization() == null) {
            child.setOrganization(parent.getOrganization());
        }
        this.assembleScmInheritance(child, parent, appendPaths);
        if (child.getCiManagement() == null) {
            child.setCiManagement(parent.getCiManagement());
        }
        if (child.getDevelopers().size() == 0) {
            child.setDevelopers(parent.getDevelopers());
        }
        if (child.getLicenses().size() == 0) {
            child.setLicenses(parent.getLicenses());
        }
        if (child.getContributors().size() == 0) {
            child.setContributors(parent.getContributors());
        }
        if (child.getMailingLists().size() == 0) {
            child.setMailingLists(parent.getMailingLists());
        }
        this.assembleBuildInheritance(child, parent);
        this.assembleDependencyInheritance(child, parent);
        child.setRepositories(ModelUtils.mergeRepositoryLists(child.getRepositories(), parent.getRepositories()));
        child.setPluginRepositories(ModelUtils.mergeRepositoryLists(child.getPluginRepositories(), parent.getPluginRepositories()));
        this.assembleReportingInheritance(child, parent);
        this.assembleDependencyManagementInheritance(child, parent);
        this.assembleDistributionManagementInheritance(child, parent);
        Properties props = new Properties();
        ((Hashtable)props).putAll(parent.getProperties());
        ((Hashtable)props).putAll(child.getProperties());
        child.setProperties(props);
    }

    private void assembleDistributionManagementInheritance(Model child, Model parent) {
        DistributionManagement cDistMgmt = child.getDistributionManagement();
        DistributionManagement pDistMgmt = parent.getDistributionManagement();
        if (cDistMgmt == null) {
            child.setDistributionManagement(pDistMgmt);
        } else if (pDistMgmt != null) {
            if (cDistMgmt.getRepository() == null) {
                cDistMgmt.setRepository(pDistMgmt.getRepository());
            }
            if (cDistMgmt.getSnapshotRepository() == null) {
                cDistMgmt.setSnapshotRepository(pDistMgmt.getSnapshotRepository());
            }
            if (StringUtils.isEmpty((String)cDistMgmt.getDownloadUrl())) {
                cDistMgmt.setDownloadUrl(pDistMgmt.getDownloadUrl());
            }
            if (cDistMgmt.getRelocation() == null) {
                cDistMgmt.setRelocation(pDistMgmt.getRelocation());
            }
            if (cDistMgmt.getSite() == null) {
                cDistMgmt.setSite(pDistMgmt.getSite());
            }
        }
    }

    private void assembleDependencyManagementInheritance(Model child, Model parent) {
        DependencyManagement parentDepMgmt = parent.getDependencyManagement();
        DependencyManagement childDepMgmt = child.getDependencyManagement();
        if (parentDepMgmt != null) {
            if (childDepMgmt == null) {
                child.setDependencyManagement(parentDepMgmt);
            } else {
                Dependency dep;
                List childDeps = childDepMgmt.getDependencies();
                TreeMap<String, Dependency> mappedChildDeps = new TreeMap<String, Dependency>();
                Iterator it = childDeps.iterator();
                while (it.hasNext()) {
                    dep = (Dependency)it.next();
                    mappedChildDeps.put(dep.getManagementKey(), dep);
                }
                it = parentDepMgmt.getDependencies().iterator();
                while (it.hasNext()) {
                    dep = (Dependency)it.next();
                    if (mappedChildDeps.containsKey(dep.getManagementKey())) continue;
                    childDepMgmt.addDependency(dep);
                }
            }
        }
    }

    private void assembleReportingInheritance(Model child, Model parent) {
        Reporting childReporting = child.getReporting();
        Reporting parentReporting = parent.getReporting();
        if (parentReporting != null) {
            if (childReporting == null) {
                childReporting = new Reporting();
                child.setReporting(childReporting);
            }
            if (StringUtils.isEmpty((String)childReporting.getOutputDirectory())) {
                childReporting.setOutputDirectory(parentReporting.getOutputDirectory());
            }
            ModelUtils.mergeReportPluginLists(childReporting, parentReporting, true);
        }
    }

    private void assembleDependencyInheritance(Model child, Model parent) {
        Dependency dependency;
        Iterator it;
        HashMap<String, Dependency> depsMap = new HashMap<String, Dependency>();
        List deps = parent.getDependencies();
        if (deps != null) {
            it = deps.iterator();
            while (it.hasNext()) {
                dependency = (Dependency)it.next();
                depsMap.put(dependency.getManagementKey(), dependency);
            }
        }
        if ((deps = child.getDependencies()) != null) {
            it = deps.iterator();
            while (it.hasNext()) {
                dependency = (Dependency)it.next();
                depsMap.put(dependency.getManagementKey(), dependency);
            }
        }
        child.setDependencies(new ArrayList(depsMap.values()));
    }

    private void assembleBuildInheritance(Model child, Model parent) {
        Build childBuild = child.getBuild();
        Build parentBuild = parent.getBuild();
        if (parentBuild != null) {
            if (childBuild == null) {
                childBuild = new Build();
                child.setBuild(childBuild);
            }
            if (childBuild.getSourceDirectory() == null) {
                childBuild.setSourceDirectory(parentBuild.getSourceDirectory());
            }
            if (childBuild.getScriptSourceDirectory() == null) {
                childBuild.setScriptSourceDirectory(parentBuild.getScriptSourceDirectory());
            }
            if (childBuild.getTestSourceDirectory() == null) {
                childBuild.setTestSourceDirectory(parentBuild.getTestSourceDirectory());
            }
            if (childBuild.getOutputDirectory() == null) {
                childBuild.setOutputDirectory(parentBuild.getOutputDirectory());
            }
            if (childBuild.getTestOutputDirectory() == null) {
                childBuild.setTestOutputDirectory(parentBuild.getTestOutputDirectory());
            }
            ModelUtils.mergeExtensionLists(childBuild, parentBuild);
            if (childBuild.getDirectory() == null) {
                childBuild.setDirectory(parentBuild.getDirectory());
            }
            if (childBuild.getDefaultGoal() == null) {
                childBuild.setDefaultGoal(parentBuild.getDefaultGoal());
            }
            if (childBuild.getFinalName() == null) {
                childBuild.setFinalName(parentBuild.getFinalName());
            }
            ModelUtils.mergeFilterLists(childBuild.getFilters(), parentBuild.getFilters());
            List resources = childBuild.getResources();
            if (resources == null || resources.isEmpty()) {
                childBuild.setResources(parentBuild.getResources());
            }
            if ((resources = childBuild.getTestResources()) == null || resources.isEmpty()) {
                childBuild.setTestResources(parentBuild.getTestResources());
            }
            ModelUtils.mergePluginLists((PluginContainer)childBuild, (PluginContainer)parentBuild, true);
            PluginManagement dominantPM = childBuild.getPluginManagement();
            PluginManagement recessivePM = parentBuild.getPluginManagement();
            if (dominantPM == null && recessivePM != null) {
                childBuild.setPluginManagement(recessivePM);
            } else {
                ModelUtils.mergePluginLists((PluginContainer)childBuild.getPluginManagement(), (PluginContainer)parentBuild.getPluginManagement(), false);
            }
        }
    }

    private void assembleScmInheritance(Model child, Model parent, boolean appendPaths) {
        if (parent.getScm() != null) {
            Scm parentScm = parent.getScm();
            Scm childScm = child.getScm();
            if (childScm == null) {
                childScm = new Scm();
                child.setScm(childScm);
            }
            if (StringUtils.isEmpty((String)childScm.getConnection()) && !StringUtils.isEmpty((String)parentScm.getConnection())) {
                childScm.setConnection(this.appendPath(parentScm.getConnection(), child.getArtifactId(), appendPaths));
            }
            if (StringUtils.isEmpty((String)childScm.getDeveloperConnection()) && !StringUtils.isEmpty((String)parentScm.getDeveloperConnection())) {
                childScm.setDeveloperConnection(this.appendPath(parentScm.getDeveloperConnection(), child.getArtifactId(), appendPaths));
            }
            if (StringUtils.isEmpty((String)childScm.getUrl()) && !StringUtils.isEmpty((String)parentScm.getUrl())) {
                childScm.setUrl(this.appendPath(parentScm.getUrl(), child.getArtifactId(), appendPaths));
            }
        }
    }

    private void assembleDistributionInheritence(Model child, Model parent, boolean appendPaths) {
        if (parent.getDistributionManagement() != null) {
            DeploymentRepository repository;
            DistributionManagement parentDistMgmt = parent.getDistributionManagement();
            DistributionManagement childDistMgmt = child.getDistributionManagement();
            if (childDistMgmt == null) {
                childDistMgmt = new DistributionManagement();
                child.setDistributionManagement(childDistMgmt);
            }
            if (childDistMgmt.getSite() == null && parentDistMgmt.getSite() != null) {
                Site site = new Site();
                childDistMgmt.setSite(site);
                site.setId(parentDistMgmt.getSite().getId());
                site.setName(parentDistMgmt.getSite().getName());
                site.setUrl(parentDistMgmt.getSite().getUrl());
                if (site.getUrl() != null) {
                    site.setUrl(this.appendPath(site.getUrl(), child.getArtifactId(), appendPaths));
                }
            }
            if (childDistMgmt.getRepository() == null && parentDistMgmt.getRepository() != null) {
                repository = new DeploymentRepository();
                childDistMgmt.setRepository(repository);
                repository.setId(parentDistMgmt.getRepository().getId());
                repository.setName(parentDistMgmt.getRepository().getName());
                repository.setUrl(parentDistMgmt.getRepository().getUrl());
                repository.setUniqueVersion(parentDistMgmt.getRepository().isUniqueVersion());
            }
            if (childDistMgmt.getSnapshotRepository() == null && parentDistMgmt.getSnapshotRepository() != null) {
                repository = new DeploymentRepository();
                childDistMgmt.setSnapshotRepository(repository);
                repository.setId(parentDistMgmt.getSnapshotRepository().getId());
                repository.setName(parentDistMgmt.getSnapshotRepository().getName());
                repository.setUrl(parentDistMgmt.getSnapshotRepository().getUrl());
                repository.setUniqueVersion(parentDistMgmt.getSnapshotRepository().isUniqueVersion());
            }
        }
    }

    private String appendPath(String url, String path, boolean appendPaths) {
        if (appendPaths) {
            if (url.endsWith("/")) {
                return url + path;
            }
            return url + "/" + path;
        }
        return url;
    }
}

