/*
 * Decompiled with CFR 0.152.
 */
package org.pegdown;

import java.util.Random;
import org.parboiled.common.StringUtils;

public class FastEncoder {
    private static Random random = new Random(9766L);

    private FastEncoder() {
    }

    public static String encode(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            for (int i = 0; i < string.length(); ++i) {
                if (FastEncoder.encode(string.charAt(i)) == null) continue;
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    String encoded = FastEncoder.encode(c);
                    if (encoded != null) {
                        sb.append(encoded);
                        continue;
                    }
                    sb.append(c);
                }
                return sb.toString();
            }
            return string;
        }
        return "";
    }

    public static void encode(String string, StringBuilder sb) {
        if (StringUtils.isNotEmpty((String)string)) {
            for (int i = 0; i < string.length(); ++i) {
                if (FastEncoder.encode(string.charAt(i)) == null) continue;
                for (i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    String encoded = FastEncoder.encode(c);
                    if (encoded != null) {
                        sb.append(encoded);
                        continue;
                    }
                    sb.append(c);
                }
                return;
            }
            sb.append(string);
        }
    }

    public static String encode(char c) {
        switch (c) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&#39;";
            }
        }
        return null;
    }

    public static String obfuscate(String email) {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < email.length(); ++i) {
            char c = email.charAt(i);
            switch (random.nextInt(5)) {
                case 0: 
                case 1: {
                    sb.append("&#").append((int)c).append(';');
                    continue block5;
                }
                case 2: 
                case 3: {
                    sb.append("&#x").append(Integer.toHexString(c)).append(';');
                    continue block5;
                }
                case 4: {
                    String encoded = FastEncoder.encode(c);
                    if (encoded != null) {
                        sb.append(encoded);
                        continue block5;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

