/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractLoader
extends DefaultHandler {
    private final Map<String, String> mPublicIdToResourceNameMap;
    private final XMLReader mParser;

    protected AbstractLoader(String aPublicId, String aDtdResourceName) throws SAXException, ParserConfigurationException {
        this(new HashMap<String, String>(1));
        this.mPublicIdToResourceNameMap.put(aPublicId, aDtdResourceName);
    }

    protected AbstractLoader(Map<String, String> aPublicIdToResourceNameMap) throws SAXException, ParserConfigurationException {
        this.mPublicIdToResourceNameMap = Maps.newHashMap(aPublicIdToResourceNameMap);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        this.mParser = factory.newSAXParser().getXMLReader();
        this.mParser.setContentHandler(this);
        this.mParser.setEntityResolver(this);
        this.mParser.setErrorHandler(this);
    }

    public void parseInputSource(InputSource aInputSource) throws IOException, SAXException {
        this.mParser.parse(aInputSource);
    }

    @Override
    public InputSource resolveEntity(String aPublicId, String aSystemId) throws SAXException, IOException {
        if (this.mPublicIdToResourceNameMap.keySet().contains(aPublicId)) {
            String dtdResourceName = this.mPublicIdToResourceNameMap.get(aPublicId);
            ClassLoader loader = this.getClass().getClassLoader();
            InputStream dtdIS = loader.getResourceAsStream(dtdResourceName);
            if (dtdIS == null) {
                throw new SAXException("Unable to load internal dtd " + dtdResourceName);
            }
            return new InputSource(dtdIS);
        }
        return super.resolveEntity(aPublicId, aSystemId);
    }

    @Override
    public void warning(SAXParseException aEx) throws SAXException {
        throw aEx;
    }

    @Override
    public void error(SAXParseException aEx) throws SAXException {
        throw aEx;
    }

    @Override
    public void fatalError(SAXParseException aEx) throws SAXException {
        throw aEx;
    }
}

