/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.injection.scanner;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.exceptions.Reporter;

public class InjectMocksScanner {
    private final Class<?> clazz;

    public InjectMocksScanner(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void addTo(Set<Field> set) {
        set.addAll(this.scan());
    }

    private Set<Field> scan() {
        Field[] fieldArray;
        HashSet<Field> hashSet = new HashSet<Field>();
        for (Field field : fieldArray = this.clazz.getDeclaredFields()) {
            if (null == field.getAnnotation(InjectMocks.class)) continue;
            this.assertNoAnnotations(field, Mock.class, MockitoAnnotations.Mock.class, Captor.class);
            hashSet.add(field);
        }
        return hashSet;
    }

    void assertNoAnnotations(Field field, Class ... classArray) {
        for (Class clazz : classArray) {
            if (!field.isAnnotationPresent(clazz)) continue;
            new Reporter().unsupportedCombinationOfAnnotations(clazz.getSimpleName(), InjectMocks.class.getSimpleName());
        }
    }
}

