/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation.finder;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.util.MockUtil;
import org.mockito.invocation.Invocation;

public class AllInvocationsFinder {
    public List<Invocation> find(List<?> list) {
        TreeSet<Invocation> treeSet = new TreeSet<Invocation>(new SequenceNumberComparator());
        for (Object obj : list) {
            InternalMockHandler<?> internalMockHandler = new MockUtil().getMockHandler(obj);
            List<Invocation> list2 = internalMockHandler.getInvocationContainer().getInvocations();
            treeSet.addAll(list2);
        }
        return new LinkedList<Invocation>(treeSet);
    }

    private static final class SequenceNumberComparator
    implements Comparator<Invocation> {
        private SequenceNumberComparator() {
        }

        @Override
        public int compare(Invocation invocation, Invocation invocation2) {
            return Integer.valueOf(invocation.getSequenceNumber()).compareTo(invocation2.getSequenceNumber());
        }
    }
}

