/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.defaultanswers;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mockito.exceptions.Reporter;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ForwardsInvocations
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = -8343690268123254910L;
    private Object delegatedObject = null;

    public ForwardsInvocations(Object object) {
        this.delegatedObject = object;
    }

    @Override
    public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
        Method method = invocationOnMock.getMethod();
        Object object = null;
        try {
            Method method2 = this.getDelegateMethod(method);
            if (!ForwardsInvocations.compatibleReturnTypes(method.getReturnType(), method2.getReturnType())) {
                new Reporter().delegatedMethodHasWrongReturnType(method, method2, invocationOnMock.getMock(), this.delegatedObject);
            }
            object = method2.invoke(this.delegatedObject, invocationOnMock.getArguments());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            new Reporter().delegatedMethodDoesNotExistOnDelegate(method, invocationOnMock.getMock(), this.delegatedObject);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        return object;
    }

    private Method getDelegateMethod(Method method) throws NoSuchMethodException {
        if (method.getDeclaringClass().isAssignableFrom(this.delegatedObject.getClass())) {
            return method;
        }
        return this.delegatedObject.getClass().getMethod(method.getName(), method.getParameterTypes());
    }

    private static boolean compatibleReturnTypes(Class<?> clazz, Class<?> clazz2) {
        return clazz.equals(clazz2) || clazz.isAssignableFrom(clazz2);
    }
}

